/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import org.apache.cxf.jaxrs.ext.search.ConditionType;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static void startSqlQuery(StringBuilder sb, String table, String ... columns) {
        sb.append("SELECT ");
        if (columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                sb.append(columns[i]);
                if (i + 1 >= columns.length) continue;
                sb.append(",");
            }
        } else {
            sb.append("*");
        }
        sb.append(" FROM ").append(table).append(" WHERE ");
    }

    public static String conditionTypeToSqlOperator(ConditionType ct, String value) {
        String op;
        switch (ct) {
            case EQUALS: {
                op = value.contains("%") ? "LIKE" : "=";
                break;
            }
            case NOT_EQUALS: {
                op = value.contains("%") ? "NOT LIKE" : "<>";
                break;
            }
            case GREATER_THAN: {
                op = ">";
                break;
            }
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: {
                op = "<";
                break;
            }
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }
}

