/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.DatasetWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class DatasetWizard
extends Wizard
implements INewWizard {
    static String cacopyright = "Copyright (c) 2016 CA";
    private TT_TreeItem datasetParent = null;
    private Dataset dataset = null;
    private DatasetWizardPage page;
    private boolean newItem = true;
    private ServerTreeModel model = ServerTreeModel.getInstance();

    public boolean performFinish() {
        return this.page.doFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = this.model.findObject(object);
        if (treeItem != null) {
            Dataset value = (Dataset)treeItem.getAdapter(Dataset.class);
            if (value != null) {
                this.dataset = value;
                this.datasetParent = treeItem.getParent();
            } else if (treeItem.getAdapter(ProfileNode.class) != null) {
                this.datasetParent = treeItem;
            }
        }
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
    }

    public void addPages() {
        Object node;
        String title = this.newItem ? "New Dataset" : String.format("Update %s", this.dataset.toString());
        if (this.datasetParent != null && (node = this.datasetParent.getAdapter(ProfileNode.class)) instanceof ProfileNode) {
            this.page = (DatasetWizardPage)((ProfileNode)node).getChildwizardPage(Dataset.class, new Object[]{this.dataset, this.datasetParent, this.newItem, title});
        }
        this.addPage((IWizardPage)this.page);
        this.setWindowTitle(this.newItem ? "Add new Dataset" : "Update Dataset");
    }

    public void setNewItem(boolean newItem) {
        this.newItem = newItem;
        if (newItem) {
            this.dataset = null;
        }
    }

    public boolean isNewItem() {
        return this.newItem;
    }
}

