/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.dialogs;

import com.ca.testingtools.TestingToolsActivator;
import com.ca.testingtools.core.CobolVariable;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.ui.dialogs.ArrayRowList;
import com.ca.testingtools.ui.dialogs.TestingToolsDialog;
import com.ca.testingtools.ui.views.datawatch.HexColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.ValueColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.VariableColumnlabelProvider;
import com.ca.testingtools.ui.views.datawatch.WatchDataContentProvider;
import java.util.HashMap;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class DataViewArrayDialog
extends TestingToolsDialog {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String Variable_Column = "Name";
    private static final String Value_Column = "Value";
    private static final String Hex_Column = "Hex";
    private String title = "New Variable Value";
    private Variable variable;
    private TreeViewer viewer;
    private GridData gridData;
    private MenuManager menuMgr;
    protected static final int IDB_CLOSE = 1024;
    private HashMap<String, String> attributes;
    private Tree tree;

    public DataViewArrayDialog(Shell parentShell) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.testingtools.help.dataoccurs";
    }

    public DataViewArrayDialog(IShellProvider parentShell) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.testingtools.help.dataoccurs";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void init(Variable variable) {
        this.variable = variable;
        this.title = "Data View Array for " + variable.getName();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrolled = new ScrolledComposite(composite, 2816);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolled.setLayout((Layout)new GridLayout(1, true));
        Composite inner = new Composite((Composite)scrolled, 0);
        this.gridData = new GridData(1808);
        this.gridData.heightHint = 800;
        this.gridData.widthHint = 900;
        inner.setLayoutData((Object)this.gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.viewer = new TreeViewer(inner, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.tree = this.viewer.getTree();
        this.viewer.getControl().setFont(JFaceResources.getTextFont());
        String[] titles = new String[]{Variable_Column, Value_Column, Hex_Column};
        int[] styles = new int[]{16384, 16384, 16384};
        int[] bounds = new int[]{150, 200, 600};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        int columnIndex = 0;
        while (columnIndex < titles.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new VariableColumnlabelProvider());
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ValueColumnlabelProvider());
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new HexColumnlabelProvider());
                }
            }
            column.getColumn().setText(titles[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.getColumn().setData((Object)order[columnIndex]);
            column.getColumn().setWidth(bounds[columnIndex]);
            ++columnIndex;
        }
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new WatchDataArrayContentProvider());
        this.viewer.setColumnProperties(titles);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Variable variable = (Variable)element;
                return variable.getDatatype() != Variable.DataType.INDEX;
            }
        });
        this.hookContextMenu();
        Variable[] items = this.buildInput();
        GridData gd = new GridData(1808);
        gd.heightHint = this.tree.getItemHeight() * items.length;
        this.tree.setLayoutData((Object)gd);
        this.viewer.setInput((Object)items);
        scrolled.setContent((Control)inner);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setMinSize(inner.computeSize(-1, -1));
        scrolled.setShowFocusedControl(true);
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private Variable[] buildInput() {
        ArrayRowList buildList = new ArrayRowList(this.variable);
        return buildList.getRows();
    }

    private void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        Menu menu = this.menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                super.cancelPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, "Close", false);
    }

    @Override
    protected Bundle getBundle() {
        return TestingToolsActivator.plugin.getBundle();
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    public class WatchDataArrayContentProvider
    extends WatchDataContentProvider {
        @Override
        public boolean hasChildren(Object parent) {
            if (parent instanceof CobolVariable) {
                CobolVariable data = (CobolVariable)parent;
                return data.hasChildren() && !data.allChildrenAreIndex();
            }
            return super.hasChildren(parent);
        }
    }
}

