/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.ITreeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class TreeObject
implements IAdaptable,
Cloneable,
ITreeType {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected String name;
    protected final ObjectType type;
    protected int owner;
    protected ITreeType parent;
    protected ArrayList<TreeObject> children = new ArrayList(1);
    protected Properties attributes = new Properties();
    protected HashMap<String, Object> objectMap = null;
    private int lineNumber = 0;
    private int statementNumber = 0;

    protected TreeObject(String name, String type) {
        this.name = name == null ? "" : name;
        this.type = TreeObject.getType(type);
    }

    protected TreeObject(Element element) {
        this.name = XMLDocument.getName((Element)element);
        this.type = TreeObject.getType(element.getTagName());
        NamedNodeMap nodes = element.getAttributes();
        int i = 0;
        while (i < nodes.getLength()) {
            Attr attr = (Attr)nodes.item(i);
            this.setAttribute(attr.getName(), attr.getValue());
            ++i;
        }
        String value = this.attributes.getProperty("linenumber", "0");
        try {
            this.lineNumber = Integer.parseInt(value);
            value = this.attributes.getProperty("statementnumber", "0");
            this.statementNumber = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setParent(TreeObject parent) {
        if (this.parent == null) {
            this.parent = parent;
        }
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public String toString() {
        String string = this.getAttribute("name");
        return String.format("%s:%s", string.length() > 0 ? string : this.getName(), super.toString());
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public void removeChildTree(TreeObject child) {
        TreeObject[] treeObjectArray = child.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject item = treeObjectArray[n2];
            child.removeChildTree(item);
            ++n2;
        }
        this.removeChild(child);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getValue(String key) {
        return Attribute.getValue((String)key, (String)this.getAttribute(key));
    }

    public String getAttribute(String key) {
        return this.attributes.getProperty(key, "");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.type.ordinal();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TreeObject)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public ObjectType getType() {
        return this.type;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public TreeObject copy() {
        try {
            TreeObject copy = (TreeObject)super.clone();
            copy.children = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TreeObject clone = null;
        clone = (TreeObject)super.clone();
        clone.children = new ArrayList(this.children.size());
        clone.parent = null;
        for (TreeObject item : this.children) {
            clone.addChild((TreeObject)item.clone());
        }
        this.log.log(Level.INFO, "Cloning {0} to {1}", new Object[]{this.toString(), clone.toString()});
        return clone;
    }

    public void dispose() {
        for (TreeObject child : this.children) {
            child.dispose();
        }
        this.children.clear();
        if (this.objectMap != null) {
            this.objectMap = null;
        }
        this.attributes.clear();
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStatementNumber() {
        return this.statementNumber;
    }

    public static ObjectType getType(String typeStr) {
        if (typeStr.equals("variables")) {
            return ObjectType.VARIABLE;
        }
        if (typeStr.equals("pgmlabel")) {
            return ObjectType.LABEL;
        }
        if (typeStr.equals("pgmstructure")) {
            return ObjectType.STRUCTURE;
        }
        if (typeStr.equals("ROOT")) {
            return ObjectType.ROOT;
        }
        if (typeStr.equals("MEMORY")) {
            return ObjectType.MEMORY;
        }
        return ObjectType.UNKNOWN;
    }

    public Object getObject(String key) {
        return this.objectMap == null ? null : this.objectMap.get(key);
    }

    public void setObject(String key, Object value) {
        if (this.objectMap == null) {
            if (value == null) {
                return;
            }
            this.objectMap = new HashMap();
        }
        if (value == null) {
            this.objectMap.remove(key);
        } else {
            this.objectMap.put(key, value);
        }
    }

    @Override
    public <T> T getRoot(Class<T> classModel) {
        if (this.parent == null) {
            return (T)(classModel.isAssignableFrom(this.getClass()) ? this : null);
        }
        if (classModel.isAssignableFrom(this.parent.getClass())) {
            return this.parent.getRoot(classModel);
        }
        return (T)(classModel.isAssignableFrom(this.getClass()) ? this : null);
    }

    @Override
    public ITreeType getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int owner) {
        this.owner = owner;
        for (TreeObject child : this.children) {
            child.setOwner(owner);
        }
    }

    public static enum ObjectType {
        VARIABLE,
        LABEL,
        STRUCTURE,
        ROOT,
        MEMORY,
        UNKNOWN;

    }
}

