/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ResourceProperty {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private static final String FORMAT_OPEN = "Error %s opening %s";
    private static final Hashtable<IResource, ResourceProperty> stores = new Hashtable();
    private static final String plugin_id = "com.ca.testingtools";
    private static final ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new DefaultScope(), "com.ca.testingtools");
    private IResource resource;
    private Properties properties = new Properties();
    private boolean changed = false;
    private final ListenerList propertyChangeListeners = new ListenerList();

    protected ResourceProperty(IResource resource) {
        this.resource = resource;
        this.load();
    }

    private void load() {
        if (this.resource instanceof IFile) {
            this.properties = this.buildAttributes((IFile)this.resource);
        }
    }

    private Properties buildAttributes(IFile file) {
        Properties attribs = new Properties();
        IPath location = file.getLocation();
        File toFile = location.toFile();
        try {
            InputStream is;
            ZipFile zipFile = new ZipFile(toFile, 1);
            ZipEntry zipEntry = zipFile.getEntry("properties");
            if (zipEntry != null) {
                try {
                    is = zipFile.getInputStream(zipEntry);
                    attribs.loadFromXML(is);
                }
                catch (IOException iOException) {
                    zipEntry = null;
                }
            }
            if (zipEntry == null && (zipEntry = zipFile.getEntry("metadata")) != null) {
                is = zipFile.getInputStream(zipEntry);
                XMLRequest xml = new XMLRequest(is);
                this.extractAttributes(attribs, xml.getCommand());
                this.extractAttributes(attribs, xml.getFirstMember());
            }
            zipFile.close();
        }
        catch (Exception e) {
            String message = String.format(FORMAT_OPEN, HexUtil.getErrorText((Throwable)e), file.getName());
            this.log.log(Level.WARNING, message, e);
        }
        return attribs;
    }

    private void extractAttributes(Properties attribs, Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            String key = attr.getName();
            String value = attr.getValue().trim();
            attribs.setProperty(key, value);
            ++i;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public boolean contains(String name) {
        String result = this.getString(name);
        return result.length() > 0;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this.resource, name, oldValue, newValue);
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    public boolean getBoolean(String name) {
        String result = this.getString(name);
        return result.length() > 0 ? Boolean.parseBoolean(result) : this.getDefaultBoolean(name);
    }

    private boolean getDefaultBoolean(String name) {
        return store.getDefaultBoolean(name);
    }

    private double getDefaultDouble(String name) {
        return store.getDefaultDouble(name);
    }

    private float getDefaultFloat(String name) {
        return store.getDefaultFloat(name);
    }

    private int getDefaultInt(String name) {
        return store.getDefaultInt(name);
    }

    private long getDefaultLong(String name) {
        return store.getDefaultLong(name);
    }

    private String getDefaultString(String name) {
        return store.getDefaultString(name);
    }

    public double getDouble(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Double.parseDouble(result) : this.getDefaultDouble(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public float getFloat(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Float.parseFloat(result) : this.getDefaultFloat(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public int getHex(String name) {
        int value;
        String result = this.getString(name);
        try {
            value = result != null && (result.indexOf(120) == 1 || result.indexOf(88) == 1) ? Integer.decode(result).intValue() : Integer.valueOf(result, 16).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            value = 0;
        }
        return value;
    }

    public int getInt(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Integer.parseInt(result) : this.getDefaultInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(String name) {
        String result = this.getString(name);
        try {
            return result.length() > 0 ? Long.parseLong(result) : this.getDefaultLong(name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String getString(String name) {
        String result = this.properties.getProperty(name);
        if (result == null) {
            try {
                result = this.resource.getPersistentProperty(new QualifiedName(plugin_id, name));
            }
            catch (CoreException coreException) {}
        }
        return result == null ? this.getDefaultString(name) : result;
    }

    public boolean isDefault(String name) {
        String defaultstr = this.getDefaultString(name);
        try {
            String result = this.resource.getPersistentProperty(new QualifiedName(plugin_id, name));
            return result.equals(defaultstr);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected void putValue(String name, String value) {
        Assert.isTrue((boolean)this.properties.containsKey(name), (String)"Cannot update metadata");
        QualifiedName key = new QualifiedName(plugin_id, name);
        String oldValue = null;
        try {
            oldValue = this.resource.getPersistentProperty(key);
        }
        catch (CoreException coreException) {}
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        if (oldValue == value) {
            return;
        }
        this.firePropertyChangeEvent(name, oldValue, value);
        try {
            this.resource.setPersistentProperty(key, value);
        }
        catch (CoreException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        this.changed = true;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public void setToDefault(String name) {
        this.putValue(name, null);
    }

    public void setValue(String name, double value) {
        this.putValue(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        this.putValue(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        this.putValue(name, Integer.toString(value));
    }

    public void setHexValue(String name, int value) {
        this.putValue(name, Integer.toString(value, 16));
    }

    public void setValue(String name, long value) {
        this.putValue(name, Long.toString(value));
    }

    public void setValue(String name, String value) {
        this.putValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.putValue(name, Boolean.toString(value));
    }

    public void save() {
        if (this.changed && this.resource.exists() && !this.resource.getWorkspace().isTreeLocked()) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (ResourceProperty.this.resource.getType() == 1 && ResourceProperty.this.getBoolean(ResourceProperty.plugin_id)) {
                        ResourceProperty.this.resource.setPersistentProperty(new QualifiedName(ResourceProperty.plugin_id, ResourceProperty.plugin_id), "true");
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, (ISchedulingRule)this.resource.getProject(), 1, null);
                this.changed = false;
            }
            catch (CoreException e) {
                this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.save();
        super.finalize();
    }

    public IResource getResource() {
        return this.resource;
    }

    public void reLoad() {
        this.load();
    }

    public String toString() {
        if (this.resource != null) {
            return this.resource.toString();
        }
        return super.toString();
    }

    public static ResourceProperty getInstance(IResource resource) {
        ResourceProperty store = stores.get(resource);
        if (store == null) {
            store = new ResourceProperty(resource);
            stores.put(resource, store);
        }
        return store;
    }
}

