/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.handlers;

import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.protsym.Outline;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import java.util.logging.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TokenTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!"isVariable".equals(property)) {
            return false;
        }
        if (!(receiver instanceof TextSelection)) {
            return false;
        }
        TextSelection selection = (TextSelection)receiver;
        String text = selection.getText();
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof ListerEditor) {
            Outline outline = ((ListerEditor)editor).getOutline();
            TreeObject[] names = outline.getQualifiedObjects(text.trim());
            if (names.length == 1 && names[0] instanceof Variable) {
                return true;
            }
            int count = 0;
            int line = selection.getStartLine() + 1;
            int statement = outline.getStatementNumber(line);
            TreeObject[] treeObjectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                TreeObject obj = treeObjectArray[n2];
                if (obj instanceof Variable && ((Variable)obj).getStatementNumber() == statement) {
                    ++count;
                }
                ++n2;
            }
            return count == 1;
        }
        return false;
    }
}

