/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.protsym.ProtsymDataset;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Member
extends PropertyChangeManager
implements Comparable<Member> {
    static String cacopyright = "Copyright (c) 2016 CA";
    private ProtsymDataset dataset = null;
    private IMemoryManager memoryManager = null;
    private Properties properties = new Properties();

    public Member() {
    }

    public Member(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int ix = 0;
        while (ix < attributes.getLength()) {
            Node attrib = attributes.item(ix);
            this.properties.setProperty(attrib.getNodeName(), attrib.getNodeValue());
            ++ix;
        }
    }

    public Element getXMLMember(XMLRequest xml) {
        Element newmember = xml.newMember(this.getName());
        Enumeration<?> it = this.properties.propertyNames();
        while (it.hasMoreElements()) {
            String key = it.nextElement().toString();
            String value = this.properties.getProperty(key);
            if (value == null) continue;
            newmember.setAttribute(key, value);
        }
        XMLFile.setDsn((Element)newmember, (String)this.getDsn());
        XMLFile.setName((Element)newmember, (String)this.getName());
        XMLFile.setTimeStamp((Element)newmember, (Calendar)this.getTimestamp());
        return newmember;
    }

    public String getAttribute(String name) {
        return this.properties.getProperty(name);
    }

    public String getDsn() {
        return this.dataset == null ? this.getAttribute("dsn") : this.dataset.getName();
    }

    public String getName() {
        return this.properties.getProperty("name");
    }

    public String setAttribute(String name, String value) {
        if (value != null) {
            value = value.replace("\u0000", "");
        }
        if (value == null || value.length() == 0) {
            return (String)this.properties.remove(name);
        }
        return (String)this.properties.put(name, value);
    }

    public Calendar getTimestamp() {
        Calendar stamp = (Calendar)Attribute.getValue((String)"time", (Properties)this.properties);
        if (stamp == null) {
            Integer date = (Integer)Attribute.getValue((String)"gt_m_jul", (Properties)this.properties);
            Integer time = (Integer)Attribute.getValue((String)"gt_m_tim", (Properties)this.properties);
            return HexUtil.TimeStamp((int)date, (int)time);
        }
        return stamp;
    }

    public String getLanguage() {
        return Attribute.toString((String)"gt_m_lang", (String)this.properties.getProperty("gt_m_lang"));
    }

    public boolean isLocked() {
        return Boolean.parseBoolean(this.properties.getProperty("locked"));
    }

    public String toString() {
        String date = this.isLocked() ? "Locked" : this.properties.getProperty("time");
        return String.format("%1$s (%3$s) %2$s %4$s", this.getName(), date, this.getLanguage(), this.getDsn());
    }

    public ProtsymDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ProtsymDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public int compareTo(Member otherMember) {
        int result = this.getName().compareTo(otherMember.getName());
        return result == 0 ? this.getDsn().compareTo(otherMember.getDsn()) : result;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public IMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(IMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public String getAttribute(String offset, IMemoryManager memoryManager2) {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Member)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Member other = (Member)obj;
        return this.getDsn().equals(other.getDsn()) && this.getName().equals(other.getName());
    }
}

