/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;

public class TTException
extends Exception {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final long serialVersionUID = -1572520214450677768L;
    private String errorMessage;
    private int errorLevel = 0;
    private String reasonCode;

    public TTException() {
    }

    public TTException(String message) {
        super(message);
    }

    public TTException(String string, Throwable cause) {
        super(string, cause);
    }

    public TTException(Throwable cause) {
        super(cause);
    }

    public TTException(XMLRequest xml) {
        this(xml.getErrorMessage());
        this.errorMessage = xml.getErrorMessage();
        this.errorLevel = xml.getErrorLevel();
        this.reasonCode = xml.getReasonCode();
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = HexUtil.getErrorText(this, true);
        }
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getReasonCode() {
        Throwable cause;
        if ((this.reasonCode == null || this.reasonCode.isEmpty()) && (cause = this.getCause()) != null) {
            this.reasonCode = HexUtil.getErrorText(cause, true);
        }
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }
}

