/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Cavhconf;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCavhuapi {
    public static final String TAG_MFREQUEST = "MFRequest";
    public static final String TAG_CONFIG = "Config";
    public static final String TAG_CONFIG_OPTION = "ConfigOption";
    public static final String CAVHUAPI_PINT = "PINT";
    public static final String TAG_MFRESPONSE = "MFResponse";
    public static final String TAG_CONFIG_RESPONSE = "ConfigResponse";
    public static final String TAG_CONFIG_OPTION_RESPONSE = "ConfigOptionResponse";
    public static final String TAG_FUNCTION_RC = "FunctionRC";
    public static final String TAG_RETURN_CODE = "ReturnCode";
    public static final String TAG_MESSAGES = "Messages";
    public static final String TAG_INTBAT = "INTBAT";
    public static final String TAG_INTCICS = "INTCICS";
    public static final String TAG_SYMBAT = "SYMBAT";
    public static final String TAG_SYMCICS = "SYMCICS";
    public static final String TAG_ON = "ON";

    public static XMLDocument generatePintRequest() throws TTException {
        ArrayList<String> confOpts = new ArrayList<String>();
        confOpts.add(CAVHUAPI_PINT);
        return XMLCavhuapi.generateCavhuapiRequest(confOpts);
    }

    protected static XMLDocument generateCavhuapiRequest(List<String> confOpts) throws TTException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element mfReq = doc.createElement(TAG_MFREQUEST);
            doc.appendChild(mfReq);
            Element conf = doc.createElement(TAG_CONFIG);
            mfReq.appendChild(conf);
            for (String confOpt : confOpts) {
                Element confOptEl = doc.createElement(TAG_CONFIG_OPTION);
                confOptEl.appendChild(doc.createTextNode(confOpt));
                conf.appendChild(confOptEl);
            }
            return new XMLDocument(doc);
        }
        catch (ParserConfigurationException pce) {
            throw new TTException(pce);
        }
    }

    public static Cavhconf parseCavhuapiResponse(Document doc) {
        Element root = doc.getDocumentElement();
        if (root.getNodeName() != TAG_MFRESPONSE) {
            System.out.println("response parse failed");
            return null;
        }
        Pint pint = new Pint();
        ConfigResponse pintConf = null;
        NodeList respNodes = root.getChildNodes();
        int i = 0;
        while (i < respNodes.getLength()) {
            Node node = respNodes.item(i);
            if (node instanceof Element) {
                if (node.getNodeName() == TAG_CONFIG_RESPONSE) {
                    pintConf = XMLCavhuapi.parseConfigResponse(node);
                } else if (node.getNodeName() != TAG_FUNCTION_RC && node.getNodeName() != TAG_RETURN_CODE) {
                    node.getNodeName();
                }
            }
            ++i;
        }
        if (pintConf != null) {
            ConfigOptionResponse cor = pintConf.pop();
            while (cor != null && !(cor instanceof Pint)) {
                cor = pintConf.pop();
            }
            if (cor != null) {
                pint = (Pint)cor;
            }
        }
        return new Cavhconf(pint.isIntbt(), pint.isIntci(), pint.isSymbt(), pint.isSymci());
    }

    private static ConfigResponse parseConfigResponse(Node crNode) {
        ConfigResponse confResp = new ConfigResponse();
        NodeList confRespList = crNode.getChildNodes();
        int i = 0;
        while (i < confRespList.getLength()) {
            Node node = confRespList.item(i);
            if (node instanceof Element && node.getNodeName() == TAG_CONFIG_OPTION_RESPONSE) {
                confResp.add(XMLCavhuapi.parseConfigOptionResponse(node));
            }
            ++i;
        }
        return confResp;
    }

    private static ConfigOptionResponse parseConfigOptionResponse(Node corNode) {
        Pint pintConf = null;
        NodeList corList = corNode.getChildNodes();
        int i = 0;
        while (i < corList.getLength()) {
            Node node = corList.item(i);
            if (node instanceof Element && node.getNodeName() == CAVHUAPI_PINT) {
                pintConf = XMLCavhuapi.parsePint(node);
            }
            ++i;
        }
        return pintConf;
    }

    private static Pint parsePint(Node pNode) {
        Pint pint = new Pint();
        NodeList pintList = pNode.getChildNodes();
        int i = 0;
        while (i < pintList.getLength()) {
            Node node = pintList.item(i);
            if (node instanceof Element) {
                if (node.getNodeName() == TAG_INTBAT) {
                    pint.setIntbt(XMLCavhuapi.parsePintValue(node));
                } else if (node.getNodeName() == TAG_INTCICS) {
                    pint.setIntci(XMLCavhuapi.parsePintValue(node));
                } else if (node.getNodeName() == TAG_SYMBAT) {
                    pint.setSymbt(XMLCavhuapi.parsePintValue(node));
                } else if (node.getNodeName() == TAG_SYMCICS) {
                    pint.setSymci(XMLCavhuapi.parsePintValue(node));
                }
            }
            ++i;
        }
        return pint;
    }

    private static boolean parsePintValue(Node pNode) {
        return pNode.getTextContent().contains(TAG_ON);
    }

    static interface ConfigOptionResponse {
    }

    static class ConfigResponse {
        private LinkedList<ConfigOptionResponse> crList = new LinkedList();

        ConfigResponse() {
        }

        public void add(ConfigOptionResponse cr) {
            this.crList.add(cr);
        }

        public ConfigOptionResponse pop() {
            if (this.crList.isEmpty()) {
                return null;
            }
            return this.crList.pop();
        }
    }

    static class Pint
    implements ConfigOptionResponse {
        private boolean intbt = false;
        private boolean intci = false;
        private boolean symbt = false;
        private boolean symci = false;

        Pint() {
        }

        public boolean isIntbt() {
            return this.intbt;
        }

        public void setIntbt(boolean intbt) {
            this.intbt = intbt;
        }

        public boolean isIntci() {
            return this.intci;
        }

        public void setIntci(boolean intci) {
            this.intci = intci;
        }

        public boolean isSymbt() {
            return this.symbt;
        }

        public void setSymbt(boolean symbt) {
            this.symbt = symbt;
        }

        public boolean isSymci() {
            return this.symci;
        }

        public void setSymci(boolean sSymci) {
            this.symci = sSymci;
        }
    }
}

