/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.report;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeView;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ReportView
extends ViewPart
implements IPropertyListener,
IPropertyChangeListener,
ISelectionListener,
ISelectionChangedListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = ReportView.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static final String ID = "com.ca.symdump.ui.views.reportsview";
    private static final String CONTEXT_HELP_ID = "com.ca.symdump.help.reportview";
    private TextViewer reportViewer;
    private Abend abend;
    private DumpTreeNode node;
    private String secondary;
    private boolean firstTime = true;
    private static ScopedPreferenceStore store = null;

    public void createPartControl(Composite parent) {
        this.addPropertyListener(this);
        this.addPartPropertyListener(this);
        this.secondary = this.getViewSite().getSecondaryId();
        this.buildReportViewer(parent);
        this.log.log(Level.FINE, "view {0}:{1} created", new Object[]{ID, this.secondary});
    }

    private void buildReportViewer(Composite parent) {
        this.reportViewer = new TextViewer(parent, 68354);
        this.reportViewer.setEditable(false);
        this.reportViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.reportViewer.canDoOperation(4);
        this.reportViewer.canDoOperation(5);
        this.reportViewer.enableOperation(4, true);
        this.reportViewer.enableOperation(10, true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.reportViewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.reportViewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.reportViewer);
        Control control = this.reportViewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.reportViewer.getControl().setFont(JFaceResources.getTextFont());
        this.reportViewer.setInput((Object)new Document(""));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        ControlContribution copyAllButton = new ControlContribution("Copy (Ctrl+C)"){

            protected Control createControl(Composite parent) {
                Button button = new Button(parent, 0);
                button.setToolTipText("Copy (Ctrl+C)");
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/copy_16.png"), null);
                Image image = ImageDescriptor.createFromURL((URL)url).createImage();
                button.setImage(image);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ReportView.this.reportViewer.doOperation(4);
                    }
                });
                return button;
            }
        };
        new ControlContribution("Select All (Ctrl+A)"){

            protected Control createControl(Composite parent) {
                Button button = new Button(parent, 0);
                button.setToolTipText("Select All (Ctrl+A)");
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/select_all_16.png"), null);
                Image image = ImageDescriptor.createFromURL((URL)url).createImage();
                button.setImage(image);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ReportView.this.reportViewer.doOperation(7);
                    }
                });
                return button;
            }
        };
        ControlContribution addAddressToWatchViewButton = new ControlContribution("Add Address to Watch View"){

            protected Control createControl(Composite parent) {
                Button button = new Button(parent, 0);
                button.setToolTipText("Add Address to Watch View");
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/Add_Watch_View_16.png"), null);
                Image image = ImageDescriptor.createFromURL((URL)url).createImage();
                button.setImage(image);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ReportView.this.reportViewer.doOperation(4);
                        try {
                            String addr = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                            if (addr.matches("[0-9A-Fa-f _]+")) {
                                IHandlerService handlerService = ReportView.this.getHandlerService();
                                IHandlerService hs = (IHandlerService)ReportView.this.getSite().getService(IHandlerService.class);
                                ICommandService commandService = ReportView.this.getCommandService();
                                Command generateCmd = commandService.getCommand("com.ca.symdump.commands.addaddresstowatch");
                                handlerService.createExecutionEvent(generateCmd, new Event());
                                try {
                                    hs.executeCommand("com.ca.symdump.commands.addaddresstowatch", null);
                                }
                                catch (Exception exception) {}
                            } else {
                                String message = String.format("The request to view address %s is not available ", addr);
                                MessageDialog.openWarning(null, (String)"Request Address", (String)message);
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
                return button;
            }
        };
        toolBarManager.add((IContributionItem)copyAllButton);
        toolBarManager.add((IContributionItem)addAddressToWatchViewButton);
        menu.addMenuListener(new MenuListener(){
            private boolean buttonShown = true;

            public void menuShown(MenuEvent e) {
                if (this.buttonShown) {
                    Menu menu = (Menu)e.getSource();
                    HashMap<String, MenuItem> menuMap = new HashMap<String, MenuItem>();
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (menuMap.put(item.getText(), item) != null) {
                            item.dispose();
                        }
                        ++n2;
                    }
                    this.buttonShown = false;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    private ICommandService getCommandService() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Object serviceObject = workbench.getAdapter(ICommandService.class);
        if (serviceObject != null) {
            ICommandService service = (ICommandService)serviceObject;
            return service;
        }
        return null;
    }

    private IHandlerService getHandlerService() {
        Object serviceObject;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (serviceObject = wb.getAdapter(IHandlerService.class)) != null) {
            IHandlerService service = (IHandlerService)serviceObject;
            return service;
        }
        return null;
    }

    public void setContent(Document document, DumpTreeNode node) {
        if (this.firstTime) {
            this.firstTime = false;
            this.abend = node.getAbend();
            this.node = node;
            DumpTreeNode rootNode = node.getRoot();
            String partName = rootNode.getText();
            String toolTip = rootNode.getText();
            this.setTitleToolTip(toolTip);
            this.setContentDescription(partName);
            this.setPartName(partName);
            this.abend.addView(this);
        }
        this.reportViewer.setInput((Object)document);
        this.goTop(node);
    }

    public void setFocus() {
        this.reportViewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.removePropertyListener(this);
        this.removePartPropertyListener(this);
        if (this.abend != null) {
            this.abend.removeView(this);
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeSelection sel;
        Object obj;
        if (part instanceof DumpTreeView && selection instanceof TreeSelection && this.node == (obj = (sel = (TreeSelection)selection).getFirstElement())) {
            try {
                this.getSite().getPage().showView(ID, this.secondary, 2);
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void propertyChanged(Object source, int propId) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void goTop(DumpTreeNode node) {
        int line = node.getStartLine();
        this.reportViewer.setTopIndex(line);
        this.reportViewer.setTopIndex(line);
    }

    public Abend getAbend() {
        return this.abend;
    }

    public void setAbend(Abend abend) {
        this.abend = abend;
    }

    public DumpTreeNode getNode() {
        return this.node;
    }

    public void setNode(DumpTreeNode node) {
        this.node = node;
    }

    public String getSecondary() {
        return this.secondary;
    }

    private int getChunk() {
        if (store == null) {
            store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        }
        int size = store.getInt("chunksize");
        return size;
    }
}

