/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.ui.dialogs;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class SD_ErrorDialog
extends TT_ErrorDialog {
    private static final HashSet<String> duplicateCheck = new HashSet();
    protected static SD_ErrorDialog instance2 = new SD_ErrorDialog("com.ca.testingtools");

    protected SD_ErrorDialog(String plugin) {
        super(plugin);
    }

    protected void doError(final Shell parent, int statuscode, final String dialogTitle, final String message, Throwable e, List<String> extraText) {
        Logger log;
        final String key = String.valueOf(dialogTitle) + message + e.getMessage();
        if (duplicateCheck.contains(key)) {
            return;
        }
        duplicateCheck.add(key);
        StackTraceElement[] stack = e == null ? new Throwable().getStackTrace() : e.getStackTrace();
        int stackIx = 0;
        String classname = ((Object)((Object)this)).getClass().getName();
        String eventclass = null;
        String method = null;
        int lineno = 0;
        while (stackIx < stack.length) {
            StackTraceElement stackItem = stack[stackIx];
            if (!classname.equals(stackItem.getClassName()) && !baseclass.equals(stackItem.getClassName())) {
                eventclass = stackItem.getClassName();
                method = stackItem.getMethodName();
                lineno = stackItem.getLineNumber();
                break;
            }
            ++stackIx;
        }
        if (eventclass == null) {
            eventclass = "Unknown Class";
            log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        } else {
            log = Logger.getLogger(eventclass);
        }
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setLoggerName(eventclass);
        record.setSourceClassName(eventclass);
        record.setSourceMethodName(method);
        record.setThrown(e);
        log.log(record);
        String statusText = String.format("The error was detected in %5$s (%6$d)", this.provider, this.name, this.plugin, this.version, eventclass, lineno);
        ArrayList<Status> statusList = new ArrayList<Status>(10);
        statusList.addAll(this.standardStatus);
        statusList.add(new Status(4, "com.ca.testingtools", statusText, null));
        if (extraText != null) {
            for (String item : extraText) {
                statusList.add(new Status(4, "com.ca.testingtools", item, null));
            }
        }
        IStatus[] statusItem = statusList.toArray(new IStatus[statusList.size()]);
        final MultiStatus status = new MultiStatus("com.ca.testingtools", statuscode, statusItem, e == null ? null : HexUtil.getErrorText((Throwable)e), e);
        UIJob job = new UIJob(classname){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ErrorDialog.openError((Shell)parent, (String)dialogTitle, (String)message.replace("&", "&&"), (IStatus)status);
                duplicateCheck.remove(key);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openError(Shell parent, String title, String message, Throwable e) {
        SD_ErrorDialog.openError(parent, 4, title, message, e, null);
    }

    public static void openError(Shell parent, int statuscode, String dialogTitle, String message, Throwable e, List<String> extraText) {
        instance2.doError(parent, statuscode, dialogTitle, message, e, extraText);
    }
}

