/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.SymdumpHeaderMap;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class TreeBuild {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected Logger log;
    protected static final String IN1T = "in1t";
    protected static final String OPEN = "open";
    protected static final String TERM = "term";
    protected String errorMessage;
    protected int errorLevel;

    public TreeBuild() {
        String name = this.getClass().getName();
        this.log = Logger.getLogger(name);
        this.errorMessage = "OK";
        this.errorLevel = 0;
    }

    public DumpTreeNode getTree(Abend abend) throws TTException {
        DumpTreeNode treeNode = this.buildTree(abend);
        return treeNode;
    }

    protected abstract DumpTreeNode buildTree(Abend var1) throws TTException;

    protected DumpTreeNode buildTree(XMLRequest xml) throws TTException {
        DumpTreeNode rootNode = null;
        DumpTreeNode parentNode = null;
        DumpTreeNode treeNode = null;
        int nodecount = 0;
        int level = 1;
        ArrayList<SymdumpHeaderMap> headers = null;
        this.errorLevel = xml.getErrorLevel();
        if (this.errorLevel != 0) {
            this.errorMessage = String.format("ErrorLevel=%d Text=", this.errorLevel, xml.getErrorMessage());
            this.log.log(Level.WARNING, this.errorMessage, xml);
            throw new TTException(this.errorMessage);
        }
        Element element = xml.getCommand();
        NodeList lines = element.getElementsByTagName("Line");
        if (lines.getLength() == 0) {
            this.errorMessage = "No Dump Tree returned from server";
            xml.setStatus(8, this.errorMessage);
            this.log.log(Level.WARNING, this.errorMessage);
            throw new TTException(this.errorMessage);
        }
        this.log.log(Level.FINE, "Entering Tree Build", xml);
        int index = 0;
        while (index < lines.getLength()) {
            Element line = (Element)lines.item(index);
            String recstring = XMLFile.getStr((Element)line);
            this.log.log(Level.FINE, recstring);
            char first = recstring.charAt(0);
            switch (first) {
                case 'H': {
                    headers = SymdumpHeaderMap.buildHeaderMap(recstring, null);
                    break;
                }
                case 'D': {
                    if (headers == null) break;
                    String objectAddr = line.getAttribute("OBJADDR");
                    String[] columns = SymdumpHeaderMap.getColumns(headers, recstring);
                    String miscdata = columns[0];
                    if (columns.length < 2) break;
                    miscdata = miscdata.replaceAll("-", "").trim();
                    String node = columns[1].replaceAll("\\| ", "|");
                    String[] parts = node.split("\\|");
                    int partslevel = parts.length - 1;
                    if (miscdata.length() == 0 && columns.length > 2) {
                        miscdata = columns[2].trim();
                    }
                    treeNode = this.buildNode(objectAddr, parts[parts.length - 1], miscdata);
                    treeNode.setNodeNumber(nodecount++);
                    treeNode.setLevel(partslevel);
                    if (rootNode == null) {
                        rootNode = treeNode;
                        parentNode = treeNode;
                        level = partslevel;
                        break;
                    }
                    level = parentNode.getLevel();
                    if (level >= partslevel) {
                        parentNode = this.findParent(parentNode, partslevel);
                    }
                    parentNode.addChild(treeNode);
                    parentNode = treeNode;
                    level = partslevel;
                    break;
                }
            }
            ++index;
        }
        this.log.log(Level.FINE, "Exiting Tree Build. {0} nodes added.", nodecount);
        return rootNode;
    }

    protected abstract DumpTreeNode buildNode(String var1, String var2, String var3);

    protected DumpTreeNode buildTree(InputStream in) throws TTException {
        XMLRequest xml = new XMLRequest(in);
        return this.buildTree(xml);
    }

    protected DumpTreeNode findParent(DumpTreeNode parentNode, int partslevel) {
        if (parentNode.getLevel() >= partslevel) {
            return this.findParent(parentNode.getParent(), partslevel);
        }
        return parentNode;
    }
}

