/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.symdump.Abend;
import com.ca.symdump.CICSTrace;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.cicstrace.CicsTraceView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.StandbyDialog;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Element;

public abstract class RunGetTrace
extends Job
implements IJobChangeListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected final DumpTreeNode node;
    protected XMLRequest xml = null;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected Abend abend;
    private StandbyDialog dialog;
    private IWorkbenchPartSite site;

    public RunGetTrace(DumpTreeNode node) {
        super("Getting CICS Trace for " + node.getAbend().toString());
        this.node = node;
        this.abend = node.getAbend();
        this.addJobChangeListener(this);
    }

    public void aboutToRun(IJobChangeEvent event) {
        Display display = this.site.getShell().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RunGetTrace.this.dialog = new StandbyDialog(RunGetTrace.this.site.getShell(), "Fetching CICS Trace.");
                    RunGetTrace.this.dialog.open();
                }
            });
        }
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        Display display;
        final int result = this.xml.getErrorLevel();
        final String errorMessage = this.xml.getErrorMessage();
        if (result == 0) {
            this.buildTrace();
        }
        if ((display = this.site.getShell().getDisplay()) != null && this.dialog != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RunGetTrace.this.dialog.close();
                    if (result != 0) {
                        String title = "Request Failed for " + RunGetTrace.this.node.getText();
                        if (result < 8) {
                            MessageDialog.openWarning(null, (String)title, (String)errorMessage);
                        } else {
                            TT_ErrorDialog.openError(null, (String)title, (String)errorMessage);
                        }
                        RunGetTrace.this.node.setFailed(true);
                        return;
                    }
                    try {
                        IViewPart viewPart = RunGetTrace.this.site.getPage().showView("com.ca.symdump.ui.views.cicstraceview", RunGetTrace.this.abend.getID(), 1);
                        if (viewPart instanceof CicsTraceView) {
                            CicsTraceView viewer = (CicsTraceView)viewPart;
                            viewer.setContent(RunGetTrace.this.abend.getCICSTraceRecords(), RunGetTrace.this.node);
                        }
                    }
                    catch (PartInitException e) {
                        RunGetTrace.this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                }
            });
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private void buildTrace() {
        Element command = this.xml.getCommand();
        String filename = command.getAttribute("localfilename");
        CICSTrace tracerec = null;
        ArrayList<String> shortrec = new ArrayList<String>(2);
        ArrayList<String> fullrec = new ArrayList<String>(5);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            block10: while ((line = reader.readLine()) != null) {
                if (line.length() < 2) {
                    line = "  ";
                }
                char trctype = line.charAt(0);
                switch (trctype) {
                    case '=': {
                        this.addTraceItem(this.abend, tracerec, shortrec, fullrec);
                        tracerec = new CICSTrace();
                        shortrec.clear();
                        fullrec.clear();
                        String token = line.substring(1).trim();
                        try {
                            tracerec.setRecordnumber(Integer.parseInt(token));
                        }
                        catch (NumberFormatException e) {
                            this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
                        }
                        continue block10;
                    }
                    case '\u0001': {
                        tracerec.setAbrevRecord(line.substring(1));
                        break;
                    }
                    case '\u0002': {
                        shortrec.add(line.substring(1));
                        break;
                    }
                    case '\u0003': {
                        fullrec.add(line.substring(1));
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        this.addTraceItem(this.abend, tracerec, shortrec, fullrec);
    }

    private void addTraceItem(Abend abend, CICSTrace tracerec, ArrayList<String> shortrec, ArrayList<String> fullrec) {
        if (tracerec != null) {
            tracerec.setShortRecord(shortrec.toArray(new String[shortrec.size()]));
            tracerec.setFullRecord(fullrec.toArray(new String[fullrec.size()]));
            abend.addCICSTraceRecord(tracerec);
        }
    }

    public void setSite(IWorkbenchPartSite site) {
        this.site = site;
    }
}

