/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.system;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.TreeBuild;
import com.ca.symdump.system.SymSysDumpTreeNode;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.HashMap;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class SymSysTreeBuild
extends TreeBuild {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String FORMAT = "%s:%s %s %s";

    public DumpTreeNode buildTree(Abend abend) throws TTException {
        TTServer server = abend.getServer();
        ServerConnect connection = new ServerConnect(server, "symdump/server");
        HashMap<String, Object> map = new HashMap<String, Object>();
        XMLRequest xml = null;
        DumpTreeNode treeNode = null;
        map.put("indx", abend.getDsn());
        map.put("symd", abend.getSysd());
        try {
            xml = connection.connect("in1t", map, true);
            this.errorLevel = xml.getErrorLevel();
            if (this.errorLevel == 0) {
                Element element = xml.getCommand();
                abend.setUuid(XMLFile.getSessionID((Element)element));
            } else {
                this.errorMessage = String.format("ErrorLevel=%d Text=", this.errorLevel, xml.getErrorMessage());
                this.log.info(this.errorMessage);
                this.log.log(Level.FINE, "", xml);
            }
            if (this.errorLevel != 0) {
                throw new TTException(this.errorMessage);
            }
            map.clear();
            map.put("uuid", abend.getUuid());
            map.put("symd", abend.getSysd());
            String DSN1 = abend.getColumn("Reports");
            String DSN2 = abend.getColumn("Storage");
            map.put("dsn", new String[]{DSN1, DSN2});
            xml = connection.connect("open", map, false);
            this.errorLevel = xml.getErrorLevel();
            if (this.errorLevel == 0) {
                treeNode = this.buildTree(xml);
            } else {
                this.errorMessage = xml.getErrorMessage();
                String msg = String.format("ErrorLevel=%d Text=%s", this.errorLevel, this.errorMessage);
                this.log.info(msg);
                this.log.log(Level.FINE, this.errorMessage, xml);
            }
        }
        catch (Exception e) {
            this.errorMessage = HexUtil.getErrorText((Throwable)e, (boolean)true);
            this.errorLevel = 32;
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        if (this.errorLevel != 0) {
            throw new TTException(this.errorMessage);
        }
        if (treeNode != null) {
            treeNode.setObject(Abend.class.getName(), (Object)abend);
            String system = abend.getColumn(8);
            String abendcode = abend.getColumn(3);
            String date = abend.getColumn(4);
            String time = abend.getColumn(5);
            String format = FORMAT;
            treeNode.setMiscData(String.format(format, system, abendcode, date, time));
        }
        for (DumpTreeNode item : DumpTreeNode.getChain(treeNode)) {
            if (!item.getTitle().equals("Viewed Storage Areas")) continue;
            item.getParent().removeChild(item);
            break;
        }
        return treeNode;
    }

    protected DumpTreeNode buildNode(String objectAddr, String string, String miscdata) {
        return new SymSysDumpTreeNode(objectAddr, string, miscdata);
    }
}

