/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.Abend;
import com.ca.symdump.BuildDocument;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetReport;
import com.ca.symdump.cics.SymCicsAbend;
import com.ca.symdump.cics.SymCicsDumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeView;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.ProtsymImportJob;
import com.ca.testingtools.protsym.wizards.SelectProtsymWizard;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.NodeList;

public class CicsOpenSymbolicHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected static final SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public synchronized Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (part instanceof DumpTreeView && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !selection.isEmpty()) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof SymCicsDumpTreeNode) {
                IEditorReference[] references;
                SymCicsDumpTreeNode node = (SymCicsDumpTreeNode)((Object)obj);
                if (!node.isSymbolicNode()) {
                    return null;
                }
                IWorkbenchPage page = part.getSite().getPage();
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    try {
                        IEditorInput input = reference.getEditorInput();
                        if (input.getName().equals("")) {
                            break;
                        }
                    }
                    catch (PartInitException e) {
                        this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                    ++n2;
                }
                Object object = node.getObject("content");
                if (object instanceof IEditorInput) {
                    try {
                        page.openEditor((IEditorInput)object, "com.ca.testingtools.protsym.lister");
                        return null;
                    }
                    catch (PartInitException e) {
                        this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
                        node.setObject("content", null);
                        object = null;
                    }
                }
                RunGetReport runner = new RunGetReport((DumpTreeNode)node);
                BusyIndicator.showWhile((Display)part.getSite().getShell().getDisplay(), (Runnable)runner);
                XMLRequest xml = runner.getXml();
                int result = xml.getErrorLevel();
                if (result != 0) {
                    String title = "Request Failed for " + node.getText();
                    if (result < 8) {
                        MessageDialog.openWarning(null, (String)title, (String)xml.getErrorMessage());
                    } else {
                        TT_ErrorDialog.openError(null, (String)title, (String)xml.getErrorMessage());
                    }
                    return null;
                }
                Document document = BuildDocument.buildDocument((XMLRequest)xml);
                String str = document.get().replace(HexUtil.LF, " ");
                int index = str.indexOf(58) + 1;
                int end = str.indexOf(32, index + 1);
                String program = str.substring(index, end).trim();
                index = str.indexOf(58, end) + 1;
                end = str.indexOf(32, index + 1);
                String offset = str.substring(index, end).trim();
                index = str.indexOf(58, end) + 1;
                end = str.indexOf("  ", index + 1);
                String timestamp = str.substring(index, end).trim();
                StringBuilder year = new StringBuilder(20);
                if (!timestamp.equalsIgnoreCase("unknown")) {
                    try {
                        year.append(timestamp.substring(6, 10));
                        year.append('/');
                        year.append(timestamp.substring(0, 5));
                        year.append(' ');
                        year.append(timestamp.substring(11).replace('.', ':'));
                    }
                    catch (Exception exception) {
                        year.setLength(0);
                    }
                }
                index = str.indexOf(58, end) + 1;
                end = Math.min(index + 44, str.length());
                String dsn = str.substring(index, end).trim();
                String match = end < str.length() ? str.substring(end + 1).trim() : "";
                boolean notExact = match.indexOf("NO MATCH") != -1;
                Dataset dataset = null;
                for (Dataset set : node.getAbend().getProtsyms()) {
                    if (!dsn.equals(set.getName())) continue;
                    dataset = set;
                    break;
                }
                if (timestamp.equalsIgnoreCase("unknown")) {
                    dataset = null;
                }
                Pair dmp = new Pair(object, object);
                Member member = null;
                boolean mismatchFound = false;
                if (dataset == null) {
                    dmp = this.getSelection(match, program, year.toString(), node, shell);
                    dataset = (Dataset)dmp.getDataset();
                    member = (Member)dmp.getMember();
                    mismatchFound = true;
                }
                if (dataset != null) {
                    Object job;
                    member = mismatchFound ? (Member)dmp.getMember() : new Member();
                    int key = 0;
                    try {
                        key = Integer.parseInt(node.getObjectAddr());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String keyString = String.format("%08d", key);
                    member.setAttribute("node_key", keyString);
                    member.setAttribute("name", program);
                    member.setAttribute("member", program);
                    if (timestamp.equalsIgnoreCase("unknown") || dsn.equalsIgnoreCase("NOT FOUND")) {
                        member.setAttribute("dsn", dataset.getName());
                        Calendar time = dataset.getTimeStamp();
                        time.add(11, 4);
                        df.format(time != null ? time.getTime() : new Date());
                        String date2 = member.getAttribute("time");
                        member.setAttribute("time", date2);
                    } else {
                        member.setAttribute("dsn", dsn);
                        member.setAttribute("time", year.toString());
                    }
                    member.setAttribute("offset", offset);
                    member.setDataset((ProtsymDataset)dataset);
                    member.setMemoryManager(node.getAbend().getMemoryManager());
                    SymCicsAbend abend = (SymCicsAbend)node.getAbend();
                    abend.addMember(member);
                    final Member nm = member;
                    if (notExact) {
                        job = new UIJob("Open Listing"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                String message = String.format("A request to open program %s\ndid not find a member with a matching time and date", nm.getDsn(), nm.getName());
                                MessageDialog.openWarning(null, (String)"Abending Statement", (String)message);
                                return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
                            }
                        };
                        job.schedule();
                    }
                    job = new ProtsymImportJob(member);
                    job.schedule();
                }
                page.activate(part);
            }
            return null;
        }
        return null;
    }

    private Pair getSelection(String match, String program, String timestamp, SymCicsDumpTreeNode node, Shell shell) {
        NodeList nodes;
        ArrayList protsyms;
        block7: {
            Abend abend = node.getAbend();
            if (!abend.isEnabled()) {
                return null;
            }
            ServerConnect connect = new ServerConnect(abend.getServer(), "testingtools/protsym");
            protsyms = abend.getProtsyms();
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("dsn", protsyms);
            map.put("name", program);
            map.put("ignorelocked", "true");
            XMLRequest xml = connect.connect("info", map, true);
            int errorLevel = xml.getErrorLevel();
            nodes = xml.getMembers();
            if (errorLevel == 0 && nodes.getLength() != 0) break block7;
            String title = "Open Source Listing";
            String reason = xml.getReasonCode();
            String message = String.format("Open of Listing failed: %s\n%s", program, xml.getErrorMessage());
            if (reason.isEmpty()) {
                reason = "Missing member or PROTSYM definition";
            }
            TT_ErrorDialog.openError(null, (String)title, (String)message, (Throwable)new Exception(reason));
            return null;
        }
        try {
            SelectProtsymWizard wizard = new SelectProtsymWizard();
            wizard.setWindowTitle("Select Listing to Open");
            wizard.init(nodes);
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                Member member = wizard.getSelected();
                String dsn = member.getDsn();
                Calendar timeStamp = member.getTimestamp();
                timeStamp.getTime().toString();
                for (Dataset dataset : protsyms) {
                    if (!dataset.getName().equals(dsn)) continue;
                    dataset.setTimeStamp(timeStamp);
                    Pair<Dataset, Member> datasetMemberPair = new Pair<Dataset, Member>(dataset, member);
                    return datasetMemberPair;
                }
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }

    public class Pair<Dataset, Member> {
        public final Dataset d;
        public final Member m;

        public Pair(Dataset d, Member m) {
            this.d = d;
            this.m = m;
        }

        public Dataset getDataset() {
            return this.d;
        }

        public Member getMember() {
            return this.m;
        }
    }
}

