/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.BuildDocument;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.batch.SymBatAbend;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Data;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class BuildData {
    private SymBatAbend abend;
    private static final Pattern pattern = Pattern.compile("[^ \\t\\r\\n\\v\\f]+");
    private static final Pattern blockLocators = Pattern.compile("^BL[LWFKX]=[0-9A-F]{4}");
    private static final String[] skip = new String[]{"ADDRESS", "STATIC", "SQLA", "SQLCA"};
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = BuildData.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private Document document;
    private int currentLine = 0;
    private int startline = 0;
    private int endline = 0;
    private MFAddress.Amode aMode = MFAddress.Amode.UNDEFINED;

    public BuildData(SymBatAbend abend) {
        this.abend = abend;
    }

    public synchronized Data getData(SymBatDumpTreeNode node) {
        Data data = node.getData();
        if (data == null && !node.hasFailed()) {
            if (this.document == null) {
                this.document = this.buildDoc(node);
            }
            if (this.document != null) {
                data = this.extractData(node);
                node.setData(data);
                if (data != null && this.abend != null) {
                    data.setOwner(((Object)((Object)this.abend)).hashCode());
                }
            }
        }
        return data;
    }

    private synchronized Data extractData(SymBatDumpTreeNode node) {
        try {
            this.currentLine = this.startline = node.getStartLine();
            this.endline = node.getEndLine();
            int firstoffset = this.document.getLineOffset(this.startline);
            int lastoffset = this.endline == 0 ? this.document.getLength() : this.document.getLineOffset(this.endline) - 1;
            int span = lastoffset - firstoffset;
            String region = this.document.get(firstoffset, span);
            if (region.indexOf("PROGRAM STATUS WORD") > 0) {
                return this.addPSW(node);
            }
            return this.analyze(node);
        }
        catch (BadLocationException badLocationException) {
            Data newdata = new Data(node.getTitle());
            newdata.setMemoryManager(node.getAbend().getMemoryManager());
            return newdata;
        }
    }

    private Document buildDoc(DumpTreeNode node) {
        XMLRequest xml;
        Document doc = this.abend.getDocument();
        if (doc.getLength() == 0 && (xml = this.abend.getReport(node)).getErrorLevel() == 0) {
            try {
                doc.replace(0, 0, BuildDocument.buildDocument((XMLRequest)xml).get());
            }
            catch (BadLocationException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter((IDocument)doc);
        try {
            int index;
            IRegion region = finder.find(0, "-BIT ADDRESSING MODE", true, false, false, false);
            if (region != null && (index = region.getOffset() - 2) >= 0) {
                String mode = doc.get(index, 2);
                try {
                    switch (Integer.parseInt(mode)) {
                        case 64: {
                            this.aMode = MFAddress.Amode.AMODE64;
                            break;
                        }
                        case 31: {
                            this.aMode = MFAddress.Amode.AMODE31;
                            break;
                        }
                        case 24: {
                            this.aMode = MFAddress.Amode.AMODE24;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (BadLocationException badLocationException) {}
        this.abend.setAmode(this.aMode);
        return doc;
    }

    private Data addPSW(SymBatDumpTreeNode node) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        byte[] bytes = new byte[]{};
        int stride = 32;
        MFAddress address = MFAddress.ZERO_ADDR;
        address.setAmode(this.aMode);
        try {
            String line;
            while ((line = this.readLine()) != null) {
                int ptr = -1;
                ptr = line.indexOf(" PROGRAM STATUS WORD ");
                if (ptr <= -1) continue;
                int count = 0;
                while (count < 3) {
                    line = this.readLine();
                    ++count;
                }
                String psw = line.substring(0, 35).replaceAll(" ", "");
                bytes = HexUtil.HextoBytes((String)psw);
                writer.write(bytes);
                break;
            }
        }
        catch (IOException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        if (writer.size() > 0) {
            Data data = new Data(writer.toByteArray(), address, node.getTitle());
            data.setTooltipText(node.getFullTooltipText());
            data.setStride(stride);
            data.setMemoryManager(node.getAbend().getMemoryManager());
            return data;
        }
        return null;
    }

    private String readLine() {
        if (this.currentLine < this.startline) {
            this.currentLine = this.startline;
        }
        if (this.currentLine > this.endline) {
            return null;
        }
        try {
            IRegion region = this.document.getLineInformation(this.currentLine++);
            return this.document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            return null;
        }
    }

    private Data analyze(SymBatDumpTreeNode node) {
        String line;
        ArrayList<Data> data = new ArrayList<Data>();
        while ((line = this.readLine()) != null) {
            String addressWord = null;
            int address = -1;
            int decimal = line.indexOf("(DECIMAL");
            if (decimal != -1) {
                if (line.startsWith("MODULE LENGTH:")) {
                    decimal = -1;
                } else {
                    address = line.indexOf(32);
                    if (address != -1) {
                        addressWord = line.substring(0, ++address);
                    }
                }
            } else {
                address = line.indexOf("ADDRESS ");
                if (address != -1) {
                    addressWord = "ADDRESS ";
                }
            }
            if (address > -1 && addressWord != null) {
                int offset = line.indexOf(" OFFSET", address + addressWord.length());
                if (offset > 0 && address == 0) {
                    data.add(this.buildAddress(line, node));
                    continue;
                }
                int length = line.indexOf(" LENGTH ", address + addressWord.length());
                if (length <= 0) continue;
                Matcher matcher = pattern.matcher(line);
                int addrix = -1;
                int lengthix = -1;
                int decimalix = -1;
                int count = 0;
                String addr = null;
                block11: while (matcher.find()) {
                    String token = matcher.group();
                    switch (count++) {
                        case 0: {
                            if (!token.equals(addressWord.trim())) continue block11;
                            addrix = matcher.start();
                            break;
                        }
                        case 1: {
                            addr = token;
                            break;
                        }
                        case 2: {
                            if (!token.equals("LENGTH")) continue block11;
                            lengthix = matcher.start();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            if (!token.equals("(DECIMAL")) continue block11;
                            decimalix = matcher.start();
                        }
                    }
                }
                if (addrix == -1 || lengthix == -1 || decimalix == -1) continue;
                data.add(this.buildAddress2(addr, node, addressWord.trim()));
                continue;
            }
            if (!line.startsWith("R")) continue;
            int equals = line.indexOf(" = ", 1);
            if (equals > 0) {
                data.add(this.buildRegister(line, node));
                continue;
            }
            data.add(this.buildRegister2(line, node));
        }
        Iterator it = data.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        switch (data.size()) {
            case 0: {
                Data newdata = new Data(node.getTitle());
                newdata.setMemoryManager(node.getAbend().getMemoryManager());
                return newdata;
            }
            case 1: {
                return (Data)data.get(0);
            }
        }
        String title = node.getTitle().trim();
        int index = title.lastIndexOf("Section");
        if (index != -1) {
            title = title.substring(0, index).trim();
        }
        Data result = new Data(title);
        result.setMemoryManager(node.getAbend().getMemoryManager());
        result.addChildren(data);
        return result;
    }

    private Data buildRegister(String string, SymBatDumpTreeNode node) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        String register = null;
        MFAddress address = null;
        int addrstart = 0;
        int addrend = 0;
        int datastart = 0;
        Matcher matcher = pattern.matcher(string);
        int count = 0;
        int stride = -1;
        while (matcher.find() && count < 3) {
            switch (count++) {
                case 0: {
                    register = matcher.group();
                    break;
                }
                case 2: {
                    addrstart = matcher.start();
                    addrend = matcher.end();
                }
            }
        }
        String addr = string.substring(addrstart, addrend);
        try {
            address = new MFAddress(addr).setAmode(this.aMode).stripFlagBit();
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        String line = this.readLine();
        boolean line1 = true;
        boolean more = true;
        while ((line = this.readLine()) != null && more) {
            if (line1) {
                line1 = false;
                matcher = pattern.matcher(line);
                count = 0;
                while (matcher.find() && count < 3) {
                    switch (count++) {
                        case 0: {
                            addrstart = matcher.start();
                            addrend = matcher.end();
                            break;
                        }
                        case 2: {
                            datastart = matcher.start();
                        }
                    }
                }
            }
            if (line.trim().length() == 0) {
                more = false;
                break;
            }
            addr = line.substring(addrstart, addrend);
            MFAddress thisAddress = null;
            try {
                int firstStar;
                thisAddress = new MFAddress(addr);
                thisAddress.setAmode(this.aMode);
                if (thisAddress.compareTo(address) < 0 || (firstStar = line.indexOf(42)) <= datastart) continue;
                String data = line.substring(datastart, firstStar).replaceAll(" ", "");
                byte[] bytes = HexUtil.HextoBytes((String)data);
                if (stride == -1) {
                    stride = bytes.length;
                }
                try {
                    writer.write(bytes);
                }
                catch (IOException e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        if (writer.size() > 0) {
            Data data = new Data(writer.toByteArray(), address, register, Data.DataType.registerMemory);
            data.setTooltipText(node.getFullTooltipText());
            data.setStride(stride);
            data.setMemoryManager(node.getAbend().getMemoryManager());
            return data;
        }
        return null;
    }

    private Data buildRegister2(String string, SymBatDumpTreeNode node) {
        int index = string.indexOf(" - R");
        if (index == 3) {
            return null;
        }
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        MFAddress address = null;
        int addrstart = 4;
        int addrend = 12;
        int underscore = -1;
        int stride = 0;
        underscore = string.indexOf("_");
        if (underscore != -1) {
            addrend = 21;
        }
        String addr = string.substring(addrstart, addrend);
        byte[] bytes = HexUtil.HextoBytes((String)addr);
        try {
            address = new MFAddress(addr);
            writer.write(bytes);
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        try {
            String line;
            boolean more = true;
            while ((line = this.readLine()) != null && more) {
                if (line.trim().length() == 0) {
                    more = false;
                    break;
                }
                addr = line.substring(addrstart, addrend);
                String data = line.substring(addrstart, addrend);
                bytes = HexUtil.HextoBytes((String)data);
                try {
                    writer.write(bytes);
                }
                catch (IOException e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        if (writer.size() > 0) {
            Data data = new Data(writer.toByteArray(), address, node.getTitle());
            data.setTooltipText(node.getFullTooltipText());
            data.setStride(stride);
            data.setMemoryManager(node.getAbend().getMemoryManager());
            return data;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Data buildAddress2(String addr, SymBatDumpTreeNode node, String addressWord) {
        title = node.getTitle().trim();
        index = title.lastIndexOf("Section");
        if (index != -1) {
            title = title.substring(0, index).trim();
        }
        data = new Data(title);
        data.setMemoryManager(node.getAbend().getMemoryManager());
        writer = new ByteArrayOutputStream(4096);
        line1 = true;
        stride = 32;
        try {
            address = new MFAddress(addr);
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            address = MFAddress.ZERO_ADDR;
        }
        address.setAmode(this.aMode);
        bytes = new byte[]{};
        datastart = 0;
        type2 = true;
        more = true;
        block11: while ((line = this.readLine()) != null && more) {
            block27: {
                blCells = BuildData.blockLocators.matcher(line);
                if (blCells.find()) {
                    blcell = blCells.group();
                    data.setTitle(String.valueOf(data.getTitle()) + " [" + blcell + "]");
                    if (!line1) {
                        this.log.log(Level.FINE, "found {0} out of place", blcell);
                    }
                }
                if (!line1) break block27;
                if (line.equals("ADDRESS  OFFSET")) {
                    dataTitle = data.getTitle().trim();
                    if (addressWord.equals(dataTitle)) continue;
                    var21_30 = BuildData.skip;
                    var20_29 = BuildData.skip.length;
                    var19_25 = 0;
                    while (var19_25 < var20_29) {
                        title1 = var21_30[var19_25];
                        if (title1.equals(addressWord)) continue block11;
                        ++var19_25;
                    }
                    if (addressWord.equals("DSA") && (name = (parent = node.getParent()).getTitle()).startsWith("Procedure ")) {
                        index1 = name.lastIndexOf(32);
                        name = name.substring(index1).trim();
                        addressWord = String.format("%s:%s", new Object[]{addressWord, name});
                    }
                    data.setTitle(String.format("%s [%s]", new Object[]{dataTitle, addressWord}));
                    continue;
                }
                matcher = BuildData.pattern.matcher(line);
                count = 0;
                block13: while (matcher.find() && count < 3) {
                    token = matcher.group();
                    switch (count++) {
                        case 0: {
                            if (token.equals("OFFSET")) {
                                type2 = false;
                                continue block11;
                            }
                            ** GOTO lbl64
                        }
                        case 1: {
                            if (!type2) {
                                datastart = matcher.start();
                            }
                            ** GOTO lbl64
                        }
                        case 2: {
                            if (type2) {
                                datastart = matcher.start();
                            }
                        }
lbl64:
                        // 6 sources

                        default: {
                            continue block13;
                        }
                    }
                }
            }
            if (line.trim().length() == 0 || line.startsWith("ADDRESS ")) {
                --this.currentLine;
                more = false;
                break;
            }
            if (line.endsWith(" SAME AS ABOVE")) {
                skipped = this.findSkip(line);
                while (skipped >= 0) {
                    try {
                        writer.write(bytes);
                    }
                    catch (IOException e) {
                        this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                    }
                    skipped -= bytes.length;
                }
                continue;
            }
            firstStar = line.indexOf(42);
            if (firstStar <= datastart) continue;
            dataString = line.substring(datastart, firstStar).replaceAll(" ", "");
            bytes = HexUtil.HextoBytes((String)dataString);
            if (line1) {
                line1 = false;
                stride = bytes.length;
            }
            try {
                writer.write(bytes);
            }
            catch (IOException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        if (writer.size() > 0) {
            data.setAddress(address);
            data.setData(writer.toByteArray());
            data.setTooltipText(node.getFullTooltipText());
            data.setStride(stride);
            return data;
        }
        return null;
    }

    private Data buildAddress(String string, SymBatDumpTreeNode node) {
        String line;
        ByteArrayOutputStream writer = new ByteArrayOutputStream(4096);
        boolean line1 = true;
        int stride = 32;
        MFAddress address = MFAddress.ZERO_ADDR;
        address.setAmode(this.aMode);
        byte[] bytes = new byte[]{};
        int addrstart = 0;
        int addrend = 0;
        int datastart = 0;
        while ((line = this.readLine()) != null) {
            if (line1) {
                Matcher matcher = pattern.matcher(line);
                int count = 0;
                while (matcher.find() && count < 3) {
                    switch (count++) {
                        case 0: {
                            addrstart = matcher.start();
                            addrend = matcher.end();
                            break;
                        }
                        case 2: {
                            datastart = matcher.start();
                        }
                    }
                }
                String addr = line.substring(addrstart, addrend);
                try {
                    address = new MFAddress(addr);
                    address.setAmode(this.aMode);
                }
                catch (Exception e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
            }
            if (line.endsWith(" SAME AS ABOVE")) {
                int skipped = this.findSkip(line);
                while (skipped >= 0) {
                    try {
                        writer.write(bytes);
                    }
                    catch (IOException e) {
                        this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                    }
                    skipped -= bytes.length;
                }
                continue;
            }
            int firstStar = line.indexOf(42);
            if (firstStar <= datastart) continue;
            String data = line.substring(datastart, firstStar).replaceAll(" ", "");
            bytes = HexUtil.HextoBytes((String)data);
            if (line1) {
                line1 = false;
                stride = bytes.length;
            }
            try {
                writer.write(bytes);
            }
            catch (IOException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        if (writer.size() > 0) {
            Data data = new Data(writer.toByteArray(), address, node.getTitle());
            data.setTooltipText(node.getFullTooltipText());
            data.setStride(stride);
            data.setMemoryManager(node.getAbend().getMemoryManager());
            return data;
        }
        return null;
    }

    private int findSkip(String line) {
        StringTokenizer tokens = new StringTokenizer(line);
        int count = tokens.countTokens();
        if (count < 2) {
            return 0;
        }
        ArrayList<String> token = new ArrayList<String>(count);
        while (tokens.hasMoreTokens()) {
            token.add(tokens.nextToken());
        }
        String[] range = ((String)token.get(1)).split("-");
        try {
            int low = Integer.decode("0x" + range[0]);
            int high = Integer.decode("0x" + range[1]);
            return high - low;
        }
        catch (NumberFormatException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            return 0;
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

