/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.GetDisplay;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class BuildReport {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = BuildReport.class.getName();
    Logger log = Logger.getLogger(sourceClass);

    public XMLRequest buildReport(Abend abend, DumpTreeNode node, XMLRequest xml) {
        if (xml == null) {
            try {
                xml = GetDisplay.getDisplay((Abend)abend, (DumpTreeNode)node);
                Element command = xml.getCommand();
                command.setAttribute("title", node.getRoot().getText());
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                XMLRequest xmlnew = new XMLRequest();
                xmlnew.setCommand("disp");
                xmlnew.setStatus(16, HexUtil.getErrorText((Throwable)e));
                return xmlnew;
            }
        } else {
            xml.getCommand().removeAttribute("title");
        }
        DumpTreeNode root = node.getRoot();
        int position = 0;
        try {
            position = Integer.decode(node.getObjectAddr());
        }
        catch (NumberFormatException numberFormatException) {}
        int nextLine = 0;
        nextLine = node.hasChildren() ? this.checkNext(root, nextLine, position) : ((SymBatDumpTreeNode)node).getEndLine();
        if (node.getParent() == null) {
            position = 0;
            nextLine = Integer.MAX_VALUE;
        }
        node.setStartLine(position);
        ((SymBatDumpTreeNode)node).setEndLine(nextLine);
        return xml;
    }

    private int checkNext(DumpTreeNode node, int nextLine, int position) {
        int current = Integer.MAX_VALUE;
        int result = nextLine;
        try {
            current = Integer.decode(node.getObjectAddr());
        }
        catch (NumberFormatException numberFormatException) {}
        if (current > position && current < result) {
            result = current;
        }
        DumpTreeNode[] dumpTreeNodeArray = node.getChildren();
        int n = dumpTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DumpTreeNode item = dumpTreeNodeArray[n2];
            result = this.checkNext(item, result, position);
            ++n2;
        }
        return result;
    }
}

