/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.server.ServerList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ServerWizardExportPage
extends WizardDataTransferPage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String STORE_DESTINATION_NAMES_ID = "destination_names";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "ovewrite_existing";
    protected Combo destinationNameField;
    private Button destinationBrowseButton;
    private Button overwriteExistingFilesCheckbox;

    public ServerWizardExportPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ServerWizardExportPage_0);
        this.setDescription(Messages.ServerWizardExportPage_1);
    }

    public ServerWizardExportPage() {
        super(Messages.ServerWizardExportPage_2);
    }

    public boolean finish() {
        ServerList.save();
        File source = ServerList.getInstance().getPropertyFile();
        if (!source.exists()) {
            this.setErrorMessage(Messages.ServerWizardExportPage_3);
            return false;
        }
        File exportfile = new File(this.getDestinationValue());
        if (!this.ensureTargetIsValid(exportfile)) {
            return false;
        }
        try {
            FileReader fileReader = new FileReader(source);
            FileWriter fileWriter = new FileWriter(exportfile);
            XMLMemento xml = XMLMemento.createReadRoot((Reader)fileReader);
            xml.save((Writer)fileWriter);
            this.saveWidgetValues();
            return true;
        }
        catch (FileNotFoundException e) {
            Logger.loggit(e);
        }
        catch (WorkbenchException e) {
            Logger.loggit(e);
        }
        catch (IOException e) {
            Logger.loggit(e);
        }
        this.setErrorMessage(Messages.ServerWizardExportPage_4);
        return false;
    }

    public boolean cancel() {
        this.saveWidgetValues();
        return true;
    }

    private boolean ensureTargetIsValid(File file) {
        File parent;
        String msgtext = Messages.ServerWizardExportPage_5;
        if (file.exists()) {
            String msg;
            if (!this.getOverwriteExisting() && !this.queryYesNoQuestion(msg = String.format(msgtext, file.getAbsolutePath()))) {
                return false;
            }
            file.delete();
        } else if (!file.isDirectory() && (parent = file.getParentFile()) != null) {
            file.getParentFile().mkdirs();
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected void createDestinationGroup(Composite parent) {
        Font parentFont = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(768));
        destinationSelectionGroup.setFont(parentFont);
        Label dest = new Label(destinationSelectionGroup, 0);
        dest.setText(Messages.ServerWizardExportPage_6);
        dest.setFont(parentFont);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(parentFont);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(Messages.ServerWizardExportPage_7);
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(parentFont);
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        dialog.setText(Messages.ServerWizardExportPage_8);
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setDestinationValue(selectedFileName);
        }
    }

    protected int getFileDialogStyle() {
        return 8192;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
        }
    }

    protected void createOptionsGroup(Composite parent) {
        Font parentFont = parent.getFont();
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setFont(parentFont);
        this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(Messages.ServerWizardExportPage_9);
        this.overwriteExistingFilesCheckbox.setFont(parentFont);
    }

    protected boolean validateDestinationGroup() {
        if (!this.validDestination()) {
            this.setErrorMessage(this.getInvalidDestinationMessage());
            return false;
        }
        return true;
    }

    private String getInvalidDestinationMessage() {
        return Messages.ServerWizardExportPage_10;
    }

    protected boolean validDestination() {
        File file = new File(this.getDestinationValue());
        return file.getPath().length() > 0 && !file.isDirectory();
    }

    private boolean getOverwriteExisting() {
        return this.overwriteExistingFilesCheckbox.getSelection();
    }

    protected boolean allowNewContainerName() {
        return false;
    }
}

