/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.DummyListing;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.wizards.NewItemWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewItemPage
extends WizardPage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String TITLE = Messages.NewItemPage_0;
    private static final String ENTER_ITEM_NAME = Messages.NewItemPage_1;
    private static final String ITEM_NAME_ALREADY_EXISTS = Messages.NewItemPage_2;
    private Text program;
    private Button monitor;
    private Button programitem;
    private Button termitem;
    private Button tranitem;
    private NewItemWizard wizard;
    private debugSession session;
    private String CONTEXT_HELP_ID = "com.ca.intertest.additem";
    private boolean isCompositeSetup = false;

    protected NewItemPage(String pageName, boolean isCompositeSetup) {
        super(pageName);
        this.isCompositeSetup = isCompositeSetup;
    }

    public void createControl(Composite parent) {
        int charwidth;
        GridData gridData;
        this.wizard = (NewItemWizard)this.getWizard();
        this.session = this.wizard.getSession();
        if (this.session == null) {
            Label label = new Label(parent, 1);
            label.setText(Messages.NewItemPage_3);
            this.setControl((Control)label);
            return;
        }
        this.setTitle(String.valueOf(TITLE) + Messages.NewItemPage_4 + this.session.getName());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        if (this.session.isCICS() && !this.isCompositeSetup) {
            Group radio = new Group(composite, 0);
            radio.setText(Messages.NewItemPage_5);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            radio.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 3;
            radio.setLayout((Layout)layout);
            this.programitem = new Button((Composite)radio, 16);
            this.programitem.setText(Messages.NewItemPage_6);
            this.programitem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NewItemPage.this.program.setTextLimit(8);
                    NewItemPage.this.program.setText(HexUtil.spaceFill((String)NewItemPage.this.program.getText(), (int)8).trim());
                }
            });
            this.programitem.setSelection(true);
            this.termitem = new Button((Composite)radio, 16);
            this.termitem.setText(Messages.NewItemPage_7);
            this.termitem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NewItemPage.this.program.setTextLimit(4);
                    NewItemPage.this.program.setText(HexUtil.spaceFill((String)NewItemPage.this.program.getText(), (int)4).trim());
                }
            });
            this.termitem.setSelection(false);
            this.tranitem = new Button((Composite)radio, 16);
            this.tranitem.setText(Messages.NewItemPage_8);
            this.tranitem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NewItemPage.this.program.setTextLimit(4);
                    NewItemPage.this.program.setText(HexUtil.spaceFill((String)NewItemPage.this.program.getText(), (int)4).trim());
                }
            });
            this.tranitem.setSelection(false);
        }
        new Label(composite, 0).setText(Messages.NewItemPage_9);
        this.program = new Text(composite, 2048);
        this.program.setTextLimit(8);
        this.program.setToolTipText(Messages.NewItemPage_10);
        this.program.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.program.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewItemPage.this.getContainer().updateButtons();
            }
        });
        GC gc = new GC((Drawable)parent);
        try {
            charwidth = gc.getCharWidth('W');
        }
        finally {
            gc.dispose();
        }
        gridData = new GridData(1);
        gridData.widthHint = charwidth * this.program.getTextLimit();
        this.program.setLayoutData((Object)gridData);
        if (!this.isCompositeSetup) {
            this.monitor = new Button(composite, 32);
            this.monitor.setText(Messages.NewItemPage_11);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.monitor.setLayoutData((Object)gridData);
        }
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        composite.setSize(composite.computeSize(-1, -1));
        this.program.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.CONTEXT_HELP_ID);
        this.setControl((Control)composite);
    }

    public boolean doFinish() {
        if (this.isCompositeSetup && this.session.getFile(this.program.getText().trim()) != null) {
            return true;
        }
        Member member = new Member();
        String itemtype = "PROGID";
        String prefix = "";
        if (this.session.isCICS() && !this.isCompositeSetup) {
            if (this.termitem.getSelection()) {
                prefix = "$TERM_";
                itemtype = "TERMID";
            } else if (this.tranitem.getSelection()) {
                prefix = "$TRAN_";
                itemtype = "TRANID";
            }
        }
        String name = String.valueOf(prefix) + this.program.getText().trim();
        member.setName(name);
        if (this.isCompositeSetup) {
            member.setMonitor(false);
        } else {
            member.setMonitor(this.monitor.getSelection());
        }
        member.setAttribute("item_type", itemtype);
        DummyListing dummy = new DummyListing(member, this.session);
        dummy.build();
        if (dummy.getResult() != 2) {
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)HexUtil.getErrorText((Throwable)dummy.getInterrupt()));
            return false;
        }
        debugFile file = this.session.getFile(member.getName());
        if (file == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)Messages.NewItemPage_13);
            return false;
        }
        if (this.isCompositeSetup) {
            file.setMonitor(false);
        } else {
            file.setMonitor(this.monitor.getSelection());
        }
        return true;
    }

    public boolean isPageComplete() {
        if (this.session == null) {
            return false;
        }
        String prefix = "";
        this.setErrorMessage(null);
        if (this.isCompositeSetup) {
            this.setErrorMessage("If this program is part of a composite load module, please specify the main composite load module that the sub-program is linked with");
        } else if (this.session.isCICS()) {
            if (this.termitem.getSelection()) {
                prefix = "$TERM_";
            } else if (this.tranitem.getSelection()) {
                prefix = "$TRAN_";
            }
        }
        String name = String.valueOf(prefix) + this.program.getText().trim();
        if (this.program.getText().length() > 0) {
            if (this.session.getFile(name) != null && !this.isCompositeSetup) {
                this.setErrorMessage(ITEM_NAME_ALREADY_EXISTS);
                return false;
            }
        } else {
            if (!this.isCompositeSetup) {
                this.setErrorMessage(ENTER_ITEM_NAME);
            }
            return false;
        }
        return true;
    }

    public String getProgramName() {
        return this.program.getText().trim();
    }
}

