/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.debug.Debug;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.AbstractBreakpointWizard;
import com.ca.intertest.wizards.BatchGlobalBreakpointWizard;
import com.ca.intertest.wizards.BatchLineBreakpointWizard;
import com.ca.intertest.wizards.CICSGlobalBreakpointWizard;
import com.ca.intertest.wizards.CICSLineBreakpointWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;

public class BreakpointManager {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private ListerEditor editor;
    private Map<String, Object> attributes = null;
    private boolean global;
    private IMarker marker = null;

    public BreakpointManager(ListerEditor editor, Map<String, Object> attributes, boolean global) {
        this(editor, global);
        this.attributes = attributes;
    }

    public BreakpointManager(ListerEditor editor, IMarker marker, boolean global) {
        this(editor, global);
        this.marker = marker;
    }

    public BreakpointManager(ListerEditor editor, boolean global) {
        this.editor = editor;
        this.global = global;
    }

    public int run() {
        IResource resource = this.editor.getResource();
        IMarker object = this.marker == null ? this.attributes : this.marker;
        boolean isCICS = Debug.getInstance().getSession(resource).isCICS();
        AbstractBreakpointWizard wizard = isCICS ? (this.global ? new CICSGlobalBreakpointWizard(this.editor, object) : new CICSLineBreakpointWizard(this.editor, object)) : (this.global ? new BatchGlobalBreakpointWizard(this.editor, object) : new BatchLineBreakpointWizard(this.editor, object));
        IntertestWizardDialog dialog = new IntertestWizardDialog(this.editor.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        return dialog.open();
    }
}

