/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.BreakpointMarkerAttributes;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.AbstractBreakpointPage;
import com.ca.intertest.wizards.IntertestWizardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractBreakpointWizard
extends Wizard {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected ListerEditor editor;
    protected IMarker marker = null;
    protected Map<String, Object> attributes = null;
    private boolean global = false;
    private AbstractBreakpointPage[] breakpointpages;
    protected IntertestWizardDialog wizardDialog;
    protected IResource resource;
    protected boolean cics;
    protected boolean COBOL;
    protected static final Debug debug = Debug.getInstance();
    protected debugFile debugfile;
    protected boolean preload = false;
    protected Integer stmtNumber;
    protected ArrayList<String> variablesList;
    protected IMarker[] markers;

    public AbstractBreakpointWizard(ListerEditor editor, Object object) {
        this.editor = editor;
        if (object instanceof IMarker) {
            this.marker = (IMarker)object;
            this.preload = true;
            try {
                this.attributes = this.marker.getAttributes();
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        } else if (object instanceof Map) {
            this.preload = true;
            this.attributes = (Map)object;
        } else {
            this.attributes = BreakpointMarkerAttributes.getBaseAttributes();
        }
        this.setForcePreviousAndNextButtons(false);
        this.setNeedsProgressMonitor(false);
        this.resource = editor.getResource();
        this.cics = debug.getSession(this.resource).isCICS();
        this.debugfile = (debugFile)debug.getResource(this.resource);
        HashMap<String, ArrayList<TreeObject>> names = editor.getOutline().getNames();
        this.variablesList = new ArrayList(names.size());
        for (String key : names.keySet()) {
            int toType = names.get(key).get(0).getType();
            if (toType != 1) continue;
            this.variablesList.add(key);
        }
        HashMap<String, NamedNodeMap> altvars = editor.getOutline().getAltVars();
        if (!altvars.isEmpty()) {
            Set<String> altKeys = altvars.keySet();
            for (String key : altKeys) {
                this.variablesList.add(key);
            }
        }
        this.variablesList.trimToSize();
        Collections.sort(this.variablesList);
        this.COBOL = this.debugfile.getLanguage() == 32;
        try {
            this.markers = this.resource.findMarkers("com.ca.intertest.breakpoint", true, 1);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        if (this.markers == null) {
            this.markers = new IMarker[0];
        }
        this.stmtNumber = (Integer)this.attributes.get("stmtNumber");
        if (this.stmtNumber == null) {
            this.stmtNumber = new Integer(0);
        }
    }

    protected final boolean isGlobal() {
        return this.global;
    }

    public String getWindowTitle() {
        return String.format(Messages.AbstractBreakpointWizard_2, this.marker == null ? Messages.AbstractBreakpointWizard_3 : Messages.AbstractBreakpointWizard_4, this.global ? Messages.AbstractBreakpointWizard_5 : Messages.AbstractBreakpointWizard_6);
    }

    protected final void setGlobal(boolean global) {
        this.global = global;
    }

    public void addPages() {
        AbstractBreakpointPage[] abstractBreakpointPageArray = this.breakpointpages;
        int n = this.breakpointpages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBreakpointPage item = abstractBreakpointPageArray[n2];
            this.addPage((IWizardPage)item);
            ++n2;
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.wizardDialog.getCurrentPage();
        if (page == null) {
            return false;
        }
        return page.isPageComplete();
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    public boolean needsProgressMonitor() {
        return false;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            this.attributes.put("programid", this.debugfile.getName());
            this.attributes.put("CICS", this.isCICS());
            AbstractBreakpointPage page = (AbstractBreakpointPage)this.wizardDialog.getCurrentPage();
            page.performBaseFinish();
            BreakpointMessage message = page.performFinish();
            if (message != null) {
                BreakpointMessageFactory.setAttributes(message, this.attributes);
                try {
                    IResource res = this.resource;
                    final BreakpointMessage bpMessage = message;
                    final boolean newCICSBP = page.isNewBP();
                    IWorkspaceRunnable r = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            block5: {
                                try {
                                    IMarker newMarker = BreakpointMessageFactory.buildMarker(AbstractBreakpointWizard.this.attributes, (IBreakpointMessage)bpMessage, AbstractBreakpointWizard.this.debugfile);
                                    if (AbstractBreakpointWizard.this.marker == null || newMarker == null) break block5;
                                    try {
                                        if (!newCICSBP) {
                                            AbstractBreakpointWizard.this.marker.setAttribute("BREAKPOINT_ENABLED", false);
                                        }
                                    }
                                    catch (CoreException e) {
                                        Logger.loggit(e);
                                    }
                                }
                                catch (ITException e) {
                                    Logger.loggit(e);
                                }
                            }
                        }
                    };
                    res.getWorkspace().run(r, null, 1, null);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
                return true;
            }
        }
        return false;
    }

    protected final AbstractBreakpointPage[] getBreakpointpages() {
        return this.breakpointpages;
    }

    protected final void setBreakpointpages(AbstractBreakpointPage[] breakpointpages) {
        this.breakpointpages = breakpointpages;
    }

    public void createPageControls(Composite pageContainer) {
        this.wizardDialog = (IntertestWizardDialog)this.getContainer();
        super.createPageControls(pageContainer);
    }

    public ListerEditor getEditor() {
        return this.editor;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isCICS() {
        return this.cics;
    }

    public boolean isCOBOL() {
        return this.COBOL;
    }

    public debugFile getDebugfile() {
        return this.debugfile;
    }

    public List<String> getVariableNames() {
        return this.variablesList;
    }

    public IMarker[] getMarkers() {
        return this.markers;
    }

    public IMarker[] getMarkers(String markerType) {
        Boolean enabled = null;
        ArrayList<IMarker> markerList = new ArrayList<IMarker>(this.markers.length);
        String typeOfMarker = null;
        IMarker[] iMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                typeOfMarker = marker.getType();
                if (markerType.equals(typeOfMarker) && (enabled = (Boolean)marker.getAttribute("BREAKPOINT_ENABLED")).booleanValue()) {
                    markerList.add(marker);
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++n2;
        }
        return markerList.toArray(new IMarker[markerList.size()]);
    }

    public IWizardPage getStartingPage() {
        String type = "com.ca.intertest.breakpoint.unconditional";
        if (this.marker != null) {
            try {
                type = this.marker.getType();
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        } else {
            type = (String)this.attributes.get("markerType");
            if (type == null || type.length() == 0) {
                type = "com.ca.intertest.breakpoint.unconditional";
            }
        }
        AbstractBreakpointPage[] abstractBreakpointPageArray = this.breakpointpages;
        int n = this.breakpointpages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBreakpointPage page = abstractBreakpointPageArray[n2];
            if (page.getMarkerType().equals(type)) {
                if (this.preload) {
                    page.preLoad();
                }
                return page;
            }
            ++n2;
        }
        return super.getStartingPage();
    }

    public Integer getStmtNumber() {
        return this.stmtNumber;
    }
}

