/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.outline;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ITreeView;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.ui.lister.ListerEditor;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class OutlinePage
extends ContentOutlinePage
implements ITreeView,
IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    private ListerEditor editor;
    private Object input;
    private IDocumentProvider provider;
    private IScanSource scansource;
    private TreeViewer viewer;
    private HashMap<String, String> attributes;
    private Action showlineAction;
    private final debugFile file;
    private static final boolean useFullLine = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/option/fullline"));

    public OutlinePage(IDocumentProvider listerDocumentProvider, ListerEditor listerEditor) {
        this.provider = listerDocumentProvider;
        this.editor = listerEditor;
        this.scansource = this.editor.getScansource();
        this.editor.getOutline();
        this.file = (debugFile)Debug.getInstance().getResource(this.editor.getResource());
        this.file.addPropertyChangeListener(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new outlineLabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.registerContextMenu();
        this.hookDoubleClickAction();
        if (this.input != null) {
            this.viewer.setInput(this.input);
        }
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public ListerEditor getEditor() {
        return this.editor;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        block8: {
            ISelection selection = event.getSelection();
            TreeObject treeobject = (TreeObject)((IStructuredSelection)selection).getFirstElement();
            if (treeobject != null) {
                int line = (Integer)Attribute.getValue("linenumber", treeobject);
                if (line == 0) {
                    line = this.getStatementOwner(treeobject);
                }
                if (line > 0) {
                    --line;
                    try {
                        int regionwidth;
                        IRegion region = this.editor.getDocument().getLineInformation(line);
                        if (useFullLine) {
                            this.editor.setHighlightRange(region.getOffset(), region.getLength(), true);
                            break block8;
                        }
                        int srcStart = this.scansource.getSourceOffset();
                        int maxwidth = this.scansource.getSourceLength();
                        if (maxwidth > (regionwidth = region.getLength() - srcStart)) {
                            maxwidth = regionwidth;
                        }
                        this.editor.selectAndReveal(region.getOffset() + srcStart, maxwidth);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else {
                super.selectionChanged(event);
            }
        }
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.unsetAttribute(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        }
    }

    public void setInput(Object editorInput) {
        this.input = editorInput;
        if (this.viewer != null) {
            this.viewer.setInput(editorInput);
        }
    }

    protected void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    private int getStatementOwner(TreeObject treeobject) {
        TreeObject parent = treeobject.getParent();
        if (parent == null) {
            return 0;
        }
        int line = (Integer)Attribute.getValue("linenumber", parent);
        if (line == 0) {
            return this.getStatementOwner(parent);
        }
        return line;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (OutlinePage.this.showlineAction.isEnabled()) {
                    OutlinePage.this.showlineAction.run();
                }
            }
        });
    }

    private void makeActions() {
        this.showlineAction = new Action(){

            public synchronized void run() {
                IStructuredSelection selection = (IStructuredSelection)OutlinePage.this.viewer.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof TreeObject) {
                    TreeObject treeobject = (TreeObject)object;
                    int line = (Integer)Attribute.getValue("linenumber", treeobject);
                    if (line == 0) {
                        line = OutlinePage.this.getStatementOwner(treeobject);
                    }
                    if (line > 0) {
                        int subStatement = (Integer)Attribute.getValue("statement_sub_number", treeobject);
                        --line;
                        try {
                            IRegion region = OutlinePage.this.editor.getDocument().getLineInformation(line);
                            int srcStart = OutlinePage.this.scansource.getSourceOffset();
                            int maxwidth = OutlinePage.this.scansource.getSourceLength();
                            int regionwidth = region.getLength() - srcStart;
                            if (maxwidth > regionwidth) {
                                maxwidth = regionwidth;
                            }
                            String linetxt = subStatement > 0 ? Messages.OutlinePage_NoSource : OutlinePage.this.editor.getDocument().get(region.getOffset() + srcStart, maxwidth);
                            MessageDialog.openInformation((Shell)OutlinePage.this.getSite().getShell(), (String)"Source Text", (String)HexUtil.Squeeze((String)linetxt));
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            }
        };
        this.showlineAction.setText(Messages.OutlinePage_showline);
    }

    private void registerContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("org.eclipse.ui.views.ContentOutline"));
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.ui.views.ContentOutline", menuMgr, (ISelectionProvider)this.viewer);
    }

    public boolean show(ShowInContext context) {
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.file.equals(event.getSource()) && "com.ca.intertest.property.outline".equals(event.getProperty())) {
            Display display = this.getSite().getShell().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    OutlinePage.this.viewer.refresh();
                }
            });
        }
    }

    public void dispose() {
        this.file.removePropertyChangeListener(this);
        super.dispose();
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String OUTLINE_ELEMENTS = "__outline_elements";
        protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("__outline_elements");
        private TreeObject root = null;

        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeObject) {
                TreeObject treeobject = (TreeObject)parent;
                return treeobject.getChildren();
            }
            return new Object[0];
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(this.root);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                TreeObject treeobject = (TreeObject)child;
                if (treeobject.equals(this.root)) {
                    return null;
                }
                return treeobject.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeObject) {
                return ((TreeObject)parent).hasChildren();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.fillTree(OutlinePage.this.provider.getDocument(newInput));
            }
        }

        private void fillTree(IDocument document) {
            if (document != null) {
                document.addPositionCategory(OUTLINE_ELEMENTS);
                document.addPositionUpdater(this.positionUpdater);
                this.root = OutlinePage.this.editor.getTree();
            }
        }
    }

    public class outlineLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof TreeObject) {
                return ((TreeObject)element).getName();
            }
            return super.getText(element);
        }
    }
}

