/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryRequest;
import com.ca.intertest.common.MemoryUpdateTable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public abstract class ViewData
implements ITreeContentProvider,
IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected MemoryRequest memRequest;
    protected static final int LEVEL1_VARIABLES = 1;
    protected static final int ALL_VARIABLES = 2;
    protected static final int GROUP_VARIABLES = 3;
    protected static final String COBOLDELIMITER = " IN | OF ";
    protected static final String DEFAULTDELIMITER = "\\.";
    protected static final Debug debug = Debug.getInstance();
    protected final IDebug debugitem;
    protected final debugSession session;
    protected final debugFile debugfile;
    protected final ArrayList<TreeObject> keepObjects = new ArrayList();
    protected ArrayList<TreeObject> fetchObjects = new ArrayList();
    protected final AbstractDataViewPage viewpage;
    protected final TreeViewer viewer;
    protected final int lang;
    protected int msgcnt;
    protected CVMO cvmoPacket;
    protected CVMI cvmiPacket;
    protected final IPreferenceStore store = IntertestPlugin.getConfigurationPreferences();
    protected boolean refreshed;
    protected boolean isDataMonitor;
    protected final String UniqueKey = Integer.toString(this.hashCode());

    public ViewData(IResource resource, AbstractDataViewPage viewpage) {
        this.debugitem = debug.getResource(resource);
        this.session = debug.getSession((IResource)resource.getProject());
        this.debugfile = this.session.getFile(resource);
        this.viewpage = viewpage;
        this.viewer = viewpage.getTreeViewer();
        this.debugitem.addPropertyChangeListener(this);
        this.lang = (Integer)Attribute.getValue("gt_m_lang", this.debugitem.getStore());
    }

    public boolean addObject(TreeObject item) {
        if (!this.isDuplicate(item)) {
            return this.keepObjects.add(item);
        }
        return false;
    }

    public boolean isDuplicate(TreeObject newtreeobject) {
        String name = newtreeobject.getName();
        String altname = newtreeobject.getAlternateName();
        if (altname == null) {
            altname = "";
        }
        for (TreeObject item : this.keepObjects) {
            int stmnt2;
            String itemAltName = item.getAlternateName();
            if (itemAltName == null) {
                itemAltName = "";
            }
            if (!item.getName().equals(name) || !itemAltName.equals(altname)) continue;
            int stmnt1 = (Integer)Attribute.getValue("statementnumber", newtreeobject);
            return stmnt1 == (stmnt2 = ((Integer)Attribute.getValue("statementnumber", item)).intValue());
        }
        return false;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public abstract TreeObject[] findObjects(String var1);

    public abstract boolean deleteObject(TreeObject var1);

    public TreeObject getRootObject(TreeObject item) {
        if (item == null) {
            return null;
        }
        String markerid = item.getAttribute(this.getUniqueKey());
        if (markerid == null || markerid.length() == 0) {
            return this.getRootObject(item.getParent());
        }
        return item;
    }

    public boolean removeObject(TreeObject item) {
        if (this.keepObjects.contains(item)) {
            return this.keepObjects.remove(item);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)parentElement;
            return treeobject.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)element;
            if (treeobject.getAttribute(this.UniqueKey) != null) {
                return null;
            }
            return treeobject.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeObject) {
            return ((TreeObject)element).hasChildren();
        }
        return false;
    }

    public abstract Object[] getElements(Object var1);

    public void dispose() {
        this.debugitem.removePropertyChangeListener(this);
    }

    public abstract void inputChanged(Viewer var1, Object var2, Object var3);

    public abstract void sendMemoryMessage(TreeObject var1, TreeObject var2);

    public void propertyChange(PropertyChangeEvent event) {
        Display display;
        String property = event.getProperty();
        if (property.equals("MEMORY_UPDATE") && (display = this.viewpage.getSite().getShell().getDisplay()) != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    for (TreeObject tree : ViewData.this.keepObjects) {
                        tree.nullBackingdata();
                    }
                    ViewData.this.fetchBackingData(true);
                }
            });
        }
    }

    protected boolean ApplyUpdate(MemoryUpdateTable tab, MFAddress startAddr, int lth, TreeObject treeobject) {
        MFAddress addrz = startAddr.add((long)lth);
        MFAddress celladdr = tab.getCelladdr();
        String hexcell = tab.getHexcell();
        if (startAddr.compareTo(celladdr) > 0 || addrz.compareTo(celladdr) < 0) {
            return false;
        }
        byte[] ebytes = new byte[hexcell.length() / 2];
        HexUtil.HextoBytes((String)hexcell, (byte[])ebytes);
        ByteBuffer bb = treeobject.getBackingdata();
        if (bb == null) {
            return false;
        }
        if (MemoryRequest.isBatchRegs(treeobject, this.session)) {
            bb = treeobject.restoreBackingdata(bb);
        }
        int offset = (int)celladdr.subtract(startAddr);
        bb.position(offset);
        bb.put(ebytes);
        if (MemoryRequest.isBatchRegs(treeobject, this.session)) {
            bb = treeobject.reorderBackingdata(bb);
        }
        bb.position(0);
        treeobject.setBackingdata(bb);
        return true;
    }

    protected void fetchBackingData(TreeObject treeobject) {
        boolean monitor = ((debugFile)this.debugitem).isMonitor();
        boolean entered = ((debugFile)this.debugitem).isEntered();
        boolean active = this.viewpage.getPagebook().isActive();
        if (this.session.isAtBreakpoint() && active && entered && monitor) {
            String ix = treeobject.getAttribute("gt_dstyp");
            if (treeobject.getBackingdata() == null || ix.equals("f0")) {
                if (treeobject.getType() == 1) {
                    if (ix.equals("f0") || treeobject.getParent() == null) {
                        this.memRequest.sendMemoryMessage(treeobject, null);
                    } else if (treeobject.getParent().getType() == 1) {
                        this.memRequest.sendMemoryMessage(treeobject, treeobject.getParent());
                    } else if (treeobject.getParent().getType() != 1) {
                        this.memRequest.sendMemoryMessage(treeobject, null);
                    }
                } else {
                    this.memRequest.sendMemoryMessage(treeobject, null);
                }
            }
        }
    }

    protected void fetchBackingData(boolean refresh) {
        block7: {
            boolean monitor = ((debugFile)this.debugitem).isMonitor();
            boolean entered = ((debugFile)this.debugitem).isEntered();
            boolean active = this.viewpage.getPagebook().isActive();
            if (this.session.isAtBreakpoint() && active && entered && monitor) {
                this.msgcnt = 0;
                this.cvmoPacket = null;
                this.cvmiPacket = new CVMI();
                this.fetchObjects.clear();
                this.memRequest = new MemoryRequest(this.session, this.debugitem.getName(), this.msgcnt, this.cvmiPacket, this.fetchObjects, this.viewpage, this.lang);
                for (TreeObject treeobject : this.keepObjects) {
                    this.fetchBackingData(treeobject);
                }
                this.msgcnt = this.memRequest.getMsgcnt();
                if (this.msgcnt > 0) {
                    try {
                        this.cvmoPacket = this.session.getTalker().process(this.cvmiPacket);
                        this.memRequest.processCVMO(this.cvmoPacket);
                        if (refresh) {
                            this.viewer.refresh();
                            break block7;
                        }
                        this.refreshed = false;
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
            } else {
                this.refreshed = false;
            }
        }
    }

    public String getUniqueKey() {
        return this.UniqueKey;
    }

    public boolean isBackTraceStop() {
        return this.session.isBackTraceStop(this.debugfile);
    }

    protected boolean isRefreshed() {
        return this.refreshed;
    }

    protected void setRefreshed(boolean refreshed) {
        this.refreshed = refreshed;
    }
}

