/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.breakpoint;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.breakpoint.BreakpointPage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class Breakpointlabelprovider
extends ColumnLabelProvider {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private int column;
    private debugFile file;
    private debugSession session;
    private ResourceProperty sessionstore;
    private ListerEditor editor;

    private Breakpointlabelprovider() {
    }

    public Breakpointlabelprovider(int column, debugFile file, ListerEditor editor) {
        this();
        this.column = column;
        this.file = file;
        this.session = file.getSession();
        this.sessionstore = this.session.getStore();
        this.editor = editor;
    }

    public Image getImage(Object element) {
        switch (this.column) {
            case 0: {
                if (element instanceof IT_TreeItem && ((IT_TreeItem)element).getType() == TreeType.MARKER) {
                    element = ((IT_TreeItem)element).getObj();
                }
                if (!(element instanceof IMarker) || this.file == null) break;
                IMarker marker = (IMarker)element;
                IResource res = marker.getResource();
                BreakpointMarker breakpoint = null;
                IDebug debugit = Debug.getInstance().getResource(res);
                if (debugit != null && (debugit instanceof debugSession || this.file.equals(debugit))) {
                    breakpoint = debugit.getBreakpointMarker(marker.getId());
                }
                if (breakpoint == null) break;
                return breakpoint.isValid() ? null : BreakpointPage.getWarningimage();
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String label = null;
        if (element instanceof IT_TreeItem && ((IT_TreeItem)element).getType() == TreeType.MARKER) {
            element = ((IT_TreeItem)element).getObj();
        }
        if (element instanceof IMarker) {
            IMarker marker = (IMarker)element;
            try {
                String type = marker.getType();
                switch (this.column) {
                    case 0: {
                        if (type.equals("com.ca.intertest.breakpoint.rbp")) {
                            if (this.session.isBatch()) {
                                label = Messages.BreakpointPage_type_breakpoint;
                                break;
                            }
                            label = Messages.BreakpointPage_rbp;
                            break;
                        }
                        if (type.equals("com.ca.intertest.breakpoint.unconditional")) {
                            label = Messages.BreakpointPage_type_breakpoint;
                            break;
                        }
                        if (type.equals("com.ca.intertest.breakpoint.watch")) {
                            label = Messages.BreakpointPage_type_datawatch;
                            break;
                        }
                        if (type.equals("com.ca.intertest.breakpoint.conditional")) {
                            label = Messages.BreakpointPage_type_dataconditional;
                            break;
                        }
                        label = marker.getAttribute("name", element.toString());
                        break;
                    }
                    case 1: {
                        if (type.equals("com.ca.intertest.breakpoint.rbp")) {
                            label = marker.getAttribute("label", Messages.Breakpointlabelprovider_0);
                            break;
                        }
                        if (type.equals("com.ca.intertest.breakpoint.unconditional")) {
                            int bkptype = marker.getAttribute("sub_type", 0);
                            if (bkptype == 1) {
                                label = Messages.Breakpointlabelprovider_1;
                            }
                            break;
                        }
                        label = (String)marker.getAttribute("left_variable");
                        break;
                    }
                    case 2: {
                        int stmt = marker.getAttribute("stmtNumber", 0);
                        if (stmt > 0) {
                            label = BreakpointPage.stmtformat.format(stmt);
                        }
                        break;
                    }
                    case 3: {
                        int stmt = marker.getAttribute("stmtNumber", 0);
                        if (stmt > 0) {
                            label = this.getStatement(marker);
                            if (label == null) {
                                label = (String)marker.getAttribute("source");
                            }
                            label = HexUtil.Squeeze((String)label);
                        }
                        break;
                    }
                    case 4: {
                        label = Attribute.getValue("userid", this.sessionstore).toString();
                        break;
                    }
                    case 5: {
                        label = Attribute.getValue("termid", this.sessionstore).toString();
                    }
                }
            }
            catch (CoreException coreException) {}
            return label == null ? "" : label;
        }
        if (this.column == 3) {
            return element.toString();
        }
        return "";
    }

    private String getStatement(IMarker marker) {
        IDocument document;
        Outline outline = this.editor.getOutline();
        if (outline != null && (document = this.editor.getDocument()) != null) {
            int statement = marker.getAttribute("stmtNumber", 0);
            int linenumber = outline.getLineNumber(statement);
            try {
                IRegion region = document.getLineInformation(linenumber - 1);
                String line = document.get(region.getOffset(), region.getLength());
                IScanSource scansource = this.editor.getScansource();
                return HexUtil.Squeeze((String)scansource.getSourceSegment(line));
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public String getToolTipText(Object element) {
        if (this.column == 0) {
            BreakpointMarker breakpoint;
            if (element instanceof IT_TreeItem && ((IT_TreeItem)element).getType() == TreeType.MARKER) {
                element = ((IT_TreeItem)element).getObj();
            }
            if (element instanceof IMarker && this.file != null && (breakpoint = this.file.getBreakpointMarker(((IMarker)element).getId())) != null) {
                return breakpoint.getErrorText();
            }
        }
        return super.getToolTipText(element);
    }
}

