/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.cobol;

import com.ca.intertest.common.TreeObject;
import com.ca.intertest.ui.lister.cobol.CobolScanner;
import com.ca.intertest.ui.lister.util.AbstractPartitioner;
import com.ca.intertest.ui.lister.util.IListerTokenScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;

public class CobolPartitioner
extends AbstractPartitioner {
    static String cacopyright = "Copyright (c) 2016 CA";

    public CobolPartitioner(IListerTokenScanner tokenScanner) {
        this.scanner = (CobolScanner)tokenScanner;
    }

    @Override
    protected void initializeSections(String category) {
        TreeObject[] children;
        String dataDiv = "DATA DIVISION";
        IRegion dataReg = null;
        String procDiv = "PROCEDURE DIVISION";
        IRegion procReg = null;
        Integer lineNum = 0;
        TreeObject rootObj = this.getLister().getOutline().getTree();
        String objName = rootObj.getName();
        if (!objName.equals("root")) {
            return;
        }
        TreeObject[] treeObjectArray = children = rootObj.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject obj = treeObjectArray[n2];
            objName = obj.getName().toUpperCase();
            try {
                if (objName.equals(dataDiv)) {
                    lineNum = Integer.parseInt(obj.getAttribute("linenumber"));
                    dataReg = this.document.getLineInformation(lineNum - 1);
                    this.document.get(dataReg.getOffset(), dataReg.getLength());
                }
                if (objName.equals(procDiv)) {
                    lineNum = Integer.parseInt(obj.getAttribute("linenumber"));
                    procReg = this.document.getLineInformation(lineNum - 1);
                    this.document.get(procReg.getOffset(), procReg.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            ++n2;
        }
        if (dataReg != null && procReg != null) {
            int start = dataReg.getOffset() + dataReg.getLength();
            int len = procReg.getOffset() - start;
            try {
                this.document.addPositionCategory(category);
                this.document.addPosition(category, (Position)new TypedPosition(start, len, "__data_division"));
                start = procReg.getOffset() + procReg.getLength();
                IRegion reg = this.document.getLineInformation(this.lastLine - 1);
                len = reg.getOffset() + reg.getLength() - start;
                this.document.addPosition(category, (Position)new TypedPosition(start, len, "__proc_division"));
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }
}

