/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister;

import com.ca.intertest.common.Logger;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class ListerMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    static String cacopyright = "Copyright (c) 2016 CA";
    private IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private IResource resource;

    public ListerMarkerAnnotationModel(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker != null && this.resource.equals((Object)marker.getResource());
    }

    protected void processResourceDelta(IMarkerDelta[] markerDeltaArray) {
        if (markerDeltaArray.length == 0) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = markerDeltaArray;
        int n = markerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            switch (markerDelta.getKind()) {
                case 1: {
                    if (!this.isValidMarker(markerDelta.getMarker())) break;
                    this.addMarkerAnnotation(markerDelta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(markerDelta.getMarker());
                    break;
                }
                case 4: {
                    IMarker marker = markerDelta.getMarker();
                    try {
                        if (!marker.isSubtypeOf("com.ca.intertest.breakpoint")) break;
                        Boolean status = marker.getAttribute("BREAKPOINT_ENABLED", true);
                        if (!status.booleanValue()) {
                            this.removeMarkerAnnotation(markerDelta.getMarker());
                            break;
                        }
                        if (!this.isValidMarker(markerDelta.getMarker())) break;
                        this.modifyMarkerAnnotation(marker);
                        break;
                    }
                    catch (CoreException e) {
                        Logger.loggit(e);
                    }
                }
            }
            ++n2;
        }
        this.fireModelChanged();
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.resource.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        } else {
            this.resource.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.resource.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, (ISchedulingRule)this.resource.getProject(), 1, null);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] allMarkers = this.resource.findMarkers("org.eclipse.core.resources.marker", true, 0);
        ArrayList<IMarker> markerList = new ArrayList<IMarker>(5);
        int i = 0;
        while (i < allMarkers.length) {
            IMarker marker = allMarkers[i];
            Boolean status = null;
            status = (Boolean)marker.getAttribute("BREAKPOINT_ENABLED");
            if (status != null) {
                if (status.booleanValue() && this.isValidMarker(marker)) {
                    markerList.add(marker);
                }
            } else {
                markerList.add(marker);
            }
            ++i;
        }
        IMarker[] validMarkers = new IMarker[markerList.size()];
        validMarkers = markerList.toArray(validMarkers);
        return validMarkers;
    }

    protected boolean isValidMarker(IMarker marker) {
        Integer subType;
        String type;
        block8: {
            block7: {
                block6: {
                    type = marker.getType();
                    if (marker.isSubtypeOf("com.ca.intertest.breakpoint")) break block6;
                    return type.equals("org.eclipse.core.resources.bookmark") || type.equals("org.eclipse.core.resources.taskmarker");
                }
                if (!type.equals("com.ca.intertest.breakpoint.watch")) break block7;
                return false;
            }
            subType = (Integer)marker.getAttribute("sub_type");
            if (!type.equals("com.ca.intertest.breakpoint.unconditional")) break block8;
            return subType.shortValue() != 1;
        }
        try {
            if (type.equals("com.ca.intertest.breakpoint.conditional")) {
                return subType.shortValue() != 4;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return false;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta resourceDelta;
            IResourceDelta eventDelta = e.getDelta();
            if (eventDelta != null && ListerMarkerAnnotationModel.this.resource != null && (resourceDelta = eventDelta.findMember(ListerMarkerAnnotationModel.this.resource.getFullPath())) != null) {
                ListerMarkerAnnotationModel.this.processResourceDelta(resourceDelta.getMarkerDeltas());
            }
        }
    }
}

