/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.ui.views.server.ServerView;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.ServerWizard;
import com.ca.testingtools.core.TTServer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class UpdateServerAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IStructuredSelection selection;
    private ServerView view;

    public void init(IViewPart view) {
        this.view = (ServerView)view;
    }

    public void run(IAction action) {
        ServerElement server = (ServerElement)this.selection.getFirstElement();
        ServerWizard wizard = new ServerWizard(server);
        IntertestWizardDialog dialog = new IntertestWizardDialog(this.view.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            server.checkStatus(500L);
        }
        if (server.isCICS_server()) {
            return;
        }
        TTServer oldTTServer = ServerList.getInstance().getTomcatServer(server);
        if (oldTTServer != null) {
            oldTTServer.setHostname(server.getHostname());
            oldTTServer.setName(server.getName());
            oldTTServer.setPort(server.getPort());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        this.run(null);
    }
}

