/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ExecuteMessage;
import com.ca.intertest.tools.StepSetMessage;
import com.ca.intertest.tools.scanCOBOL;
import com.ca.intertest.ui.actions.AbstractDebuggingAction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StepOverAction
extends AbstractDebuggingAction {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected static final boolean stepafter = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/option/stepafter"));
    public static final String CVMI_STEP_OVER = "1";
    public static final String CVMI_STEP_RETURN = "2";

    @Override
    public void run(IAction action) {
        if (this.session != null && this.session.isAtBreakpoint()) {
            DebugTalker talker = this.session.getTalker();
            BreakMessage breakmessage = talker.getBreakmessage();
            try {
                try {
                    CVMI cvmi = new CVMI();
                    if (stepafter && this.session.isCICS()) {
                        StepSetMessage stepmsg = new StepSetMessage();
                        stepmsg.setAfter(this.session.isStepAfter());
                        stepmsg.setProgram(breakmessage.getProgram());
                        cvmi.addMessage((DebugMessage)stepmsg);
                    }
                    ExecuteMessage msg = new ExecuteMessage();
                    msg.setMessageID((short)12);
                    msg.setSubmessageID((Object)CVMI_STEP_OVER);
                    msg.setProgram(breakmessage.getShortProgram());
                    msg.setStatement(breakmessage.getStatement());
                    cvmi.addMessage((DebugMessage)msg);
                    talker.processExecute(cvmi);
                }
                catch (Exception exception) {
                    this.refocus();
                }
            }
            finally {
                this.refocus();
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        debugFile debugfile = null;
        this.session = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            this.selected = (IStructuredSelection)selection;
            Object obj = this.selected.getFirstElement();
            if (obj instanceof IT_TreeItem) {
                if ((obj = ((IT_TreeItem)obj).getObj()) instanceof debugFile) {
                    debugfile = (debugFile)obj;
                    this.session = debugfile.getSession();
                }
                if (obj instanceof debugSession) {
                    this.session = (debugSession)obj;
                }
            }
        }
        if (this.session != null && this.session.isAtBreakpoint() && debugfile != null && debugfile.getScansource() instanceof scanCOBOL) {
            action.setEnabled(true);
        }
    }
}

