/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.NewcopyRequestMessage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewCopy {
    String program = "";
    private final debugSession session;
    private final Shell shell;
    private CICSConnection connection;

    public NewCopy(Shell shell, debugSession session, String program) {
        this.program = program;
        this.session = session;
        this.shell = shell;
    }

    public void run() {
        CICSServer server = (CICSServer)this.session.getDebugServer();
        this.connection = new CICSConnection(server, this.session);
        CVMO cvmo = null;
        try {
            this.connection.connect(false);
            if (this.connection.getErrorLevel() == 0) {
                CVMI cvmi = new CVMI();
                NewcopyRequestMessage msg = new NewcopyRequestMessage();
                msg.setProgram(this.program);
                cvmi.addMessage((DebugMessage)new SignonMessage(server));
                cvmi.addMessage((DebugMessage)new InitMessage(this.session));
                cvmi.addMessage((DebugMessage)msg);
                cvmo = this.connection.process(cvmi);
                if (cvmo.getErrorLevel() == 0) {
                    this.processCVMO(cvmo);
                } else {
                    Connection.displayError(cvmo, Messages.NewCopy_1);
                }
            } else {
                String text = String.format(Messages.NewCopy_2, this.connection.getErrorLevel(), this.connection.getErrorMessage());
                MessageDialog.openWarning((Shell)this.shell, (String)Messages.NewCopy_3, (String)text);
            }
            this.connection.disconnect();
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    protected void processCVMO(CVMO cvmo) {
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 18: {
                    break;
                }
                default: {
                    String text = String.format(Messages.NewCopy_4, new Object[0]);
                    MessageDialog.openWarning((Shell)this.shell, (String)Messages.NewCopy_3, (String)text);
                }
            }
            ++n2;
        }
    }
}

