/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import com.ca.intertest.wizards.ChannelWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;

public class ChannelKeepItemAction
implements IViewActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private AbstractDataViewPageBook book = null;
    private AbstractDataViewPage page = null;
    protected Object object = null;
    private IDebug debugitem;
    protected ListerEditor editor;
    private boolean expression;

    public void init(IPage page) {
        if (page instanceof AbstractDataViewPage) {
            this.page = (AbstractDataViewPage)page;
            this.debugitem = this.page.getDebugitem();
            this.editor = this.page.getEditor();
        } else {
            page = null;
            this.debugitem = null;
            this.editor = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof AbstractDataViewPageBook) {
            this.book = (AbstractDataViewPageBook)view;
        }
    }

    public void run(IAction action) {
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (!this.page.getSession().isAtBreakpoint()) {
            return;
        }
        ChannelWizard wizard = new ChannelWizard();
        wizard.init(this.editor);
        MemoryWizardDialog dialog = new MemoryWizardDialog(this.page.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null) {
            action.setEnabled(false);
            return;
        }
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        this.object = null;
        if (this.page != null && this.page.getSession().isAtBreakpoint() && this.page.getSession().isCICS()) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 1) {
                Object obj = sel.getFirstElement();
                if (obj instanceof TreeObject) {
                    TreeObject treeobject = (TreeObject)obj;
                    this.expression = treeobject.getAttribute("dataflag").equals("CORE_EXPRESSION");
                    if (this.expression || treeobject.getType() == 1) {
                        enabled = true;
                        this.object = treeobject;
                    }
                }
            } else if (sel.isEmpty()) {
                this.object = null;
                enabled = true;
            }
        }
        if (enabled && this.page != null && !(this.debugitem instanceof debugFile)) {
            enabled = false;
            this.object = null;
        }
        action.setEnabled(enabled);
    }
}

