/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.dialogs.DataViewArrayDialog;
import com.ca.intertest.dialogs.DataViewValueDialog;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.wizards.CoreStructurePage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ChangeStructureItemAction
implements IViewActionDelegate,
IDoubleClickListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected final int maxlength = IntertestPlugin.getConfigurationPreferences().getInt("DATAVIEW_MAXLENGTH");
    private CoreStructurePage page = null;
    protected Object object = null;
    protected IDebug debugitem;

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(null, event.getSelection());
        this.run(null);
    }

    public void init(IWizardPage page) {
        if (page instanceof CoreStructurePage) {
            this.page = (CoreStructurePage)page;
            this.debugitem = this.page.getDebugitem();
        } else {
            page = null;
            this.debugitem = null;
        }
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.object instanceof TreeObject && this.page != null && !this.page.isBackTraceStop()) {
            TreeObject treeobject = (TreeObject)this.object;
            boolean expression = "CORE_EXPRESSION".equals(treeobject.getAttribute("dataflag"));
            if (!expression && treeobject.getType() != 1) {
                return;
            }
            int length = (Integer)Attribute.getValue("length", treeobject);
            Shell shell = this.page.getShell();
            int dmax1 = (Integer)Attribute.getValue("gt_dmax1", treeobject);
            boolean groupVar = this.checkChildren(treeobject);
            if (length > this.maxlength || expression || groupVar) {
                MessageDialog.openWarning(null, (String)Messages.ChangeStructureItemAction_2, (String)Messages.ChangeStructureItemAction_3);
            } else if (dmax1 > 0) {
                DataViewArrayDialog dlgDVArray = new DataViewArrayDialog(this.page.getShell());
                dlgDVArray.init((Variable)treeobject, this.page);
                dlgDVArray.open();
            } else {
                DataViewValueDialog dlgDVValue = new DataViewValueDialog(shell);
                MFAddress addr = treeobject.getAddress();
                if (addr.equals((Object)MFAddress.ZERO_ADDR)) {
                    int offset = (Integer)Attribute.getValue("structureoffset", treeobject);
                    int parentoffset = (Integer)Attribute.getValue("structureoffset", treeobject.getParent());
                    treeobject.setAddress(addr.add((long)(offset - parentoffset)));
                }
                if (treeobject.getBackingdata() == null) {
                    String str = String.valueOf(Messages.ChangeStructureItemAction_4) + treeobject.getName();
                    MessageDialog.openInformation((Shell)this.page.getShell(), (String)Messages.ChangeStructureItemAction_5, (String)str);
                } else {
                    dlgDVValue.init((Variable)treeobject, this.page.getSession());
                    dlgDVValue.open();
                }
            }
            if (!expression) {
                this.page.getTreeViewer().refresh();
                this.page.getTreeViewer().expandAll();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeObject treeobject;
        Object obj;
        IStructuredSelection sel;
        boolean enabled = false;
        this.object = null;
        if (this.page != null && this.page.getSession().isAtBreakpoint() && (sel = (IStructuredSelection)selection).size() == 1 && (obj = sel.getFirstElement()) instanceof TreeObject && ((treeobject = (TreeObject)obj).getAttribute("dataflag").equals("CORE_EXPRESSION") || treeobject instanceof Variable)) {
            enabled = true;
            this.object = treeobject;
        }
        if (enabled && !(this.debugitem instanceof debugFile)) {
            enabled = false;
            this.object = null;
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public boolean checkChildren(TreeObject treeobject) {
        if (treeobject.allChildrenAreIndex()) {
            return false;
        }
        return treeobject.hasChildren();
    }
}

