/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.BreakpointMarkerAttributes;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.ui.lister.ListerEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractRulerMarkerAction
extends Action
implements IUpdate {
    static String cacopyright = "Copyright (c) 2016 CA";
    private ListerEditor lister = null;
    protected String markerType;
    protected List<IMarker> resourceMarkers;
    private final String BLANK_LINE = Messages.AbstractRulerMarkerAction_blank;
    private IVerticalRuler vRuler = null;
    protected IMarker[] markers = null;
    private debugSession session;
    private debugFile debugfile;

    public AbstractRulerMarkerAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        if (editor instanceof ListerEditor) {
            this.lister = (ListerEditor)editor;
            IResource res = this.lister.getResource();
            this.session = Debug.getInstance().getSession(res);
            if (this.session != null) {
                this.debugfile = this.session.getFile(res);
            }
            if (rulerInfo instanceof IVerticalRuler) {
                this.vRuler = (IVerticalRuler)rulerInfo;
            }
        }
    }

    protected ListerEditor getLister() {
        return this.lister;
    }

    protected IVerticalRuler getVerticalRuler() {
        return this.vRuler;
    }

    public abstract String getMarkerType();

    public List<IMarker> getBreakpointMarkers() {
        ArrayList<IMarker> currentList = new ArrayList<IMarker>();
        if (this.lister == null) {
            return currentList;
        }
        IResource resource = this.lister.getResource();
        if (resource == null || !resource.exists()) {
            return currentList;
        }
        try {
            IMarker[] iMarkerArray = this.markers = resource.findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                short subType;
                boolean status;
                IMarker marker = iMarkerArray[n2];
                String markertype = marker.getType();
                if (!"com.ca.intertest.breakpoint.rbp".equals(markertype) && (status = marker.getAttribute("BREAKPOINT_ENABLED", false)) && (subType = (short)marker.getAttribute("sub_type", 1)) != -1 && subType != 1 && subType != 4 && !marker.getType().equals("com.ca.intertest.breakpoint.watch") && this.getMarkerLineNumber(marker) == this.getSelectionLineNumber() + 1) {
                    currentList.add(marker);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return currentList;
    }

    public int getMarkerLineNumber(IMarker marker) {
        int line = 0;
        try {
            Integer iline = null;
            Integer statement = (Integer)marker.getAttribute("stmtNumber");
            if (statement != null) {
                iline = this.debugfile.getOutline().getStatementXref().get(statement);
            }
            if (iline != null) {
                line = iline;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return line;
    }

    public int getSelectionLineNumber() {
        int line = 0;
        if (this.vRuler != null) {
            line = this.vRuler.getLineOfLastMouseButtonActivity();
        }
        return line;
    }

    public List<IMarker> getResourceMarkers() {
        return this.resourceMarkers;
    }

    protected abstract void addMarker();

    protected abstract void removeMarker();

    public abstract void run();

    public String getMarkerLabel(IDocument document, int offset, int length) {
        try {
            String stmt = document.get(offset, length);
            String label = this.lister.getScansource().getSourceSegment(stmt).trim();
            if (label.length() == 0) {
                return this.BLANK_LINE;
            }
            return label;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected void allocateMarker(final Map<?, ?> attributes) throws CoreException {
        this.markerType = this.getMarkerType();
        final IResource res = this.lister.getResource();
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = res.createMarker(AbstractRulerMarkerAction.this.markerType);
                marker.setAttributes(attributes);
            }
        };
        res.getWorkspace().run(r, (ISchedulingRule)res.getProject(), 1, null);
    }

    protected void deleteMarkers(List<?> markers) {
        int i = 0;
        while (i < markers.size()) {
            IMarker marker = (IMarker)markers.get(i);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++i;
        }
    }

    public void update() {
        this.resourceMarkers = this.getBreakpointMarkers();
    }

    protected Map<String, Object> setBaseAttributes(int line) {
        int start = -1;
        int end = -1;
        int length = 0;
        int stmtNumber = 0;
        Map<String, Object> attributes = BreakpointMarkerAttributes.getBaseAttributes();
        IDocument doc = this.lister.getDocument();
        try {
            start = doc.getLineOffset(line - 1);
            length = doc.getLineLength(line - 1);
            end = start + length;
            Integer statement = this.lister.getOutline().getLineXref().get(line);
            stmtNumber = statement == null ? -1 : statement;
        }
        catch (BadLocationException e) {
            Logger.loggit(e);
        }
        attributes.put("lineNumber", new Integer(line));
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(end));
        attributes.put("stmtNumber", stmtNumber);
        attributes.put("sub_type", new Integer(2));
        attributes.put("source", this.getMarkerLabel(doc, start, length));
        return attributes;
    }

    public debugSession getDebugSession() {
        return this.session;
    }

    public debugFile getDebugFile() {
        return this.debugfile;
    }

    protected boolean appendBaseAttributes(Map<String, Object> attributes) {
        if (this.session == null) {
            return false;
        }
        if (this.debugfile == null) {
            return false;
        }
        attributes.put("CICS", this.session.isCICS());
        Integer line = null;
        Integer statement = (Integer)attributes.get("stmtNumber");
        if (statement != null) {
            line = this.debugfile.getOutline().getStatementXref().get(statement);
        }
        if (line == null) {
            line = 0;
        }
        String label = this.debugfile.getName();
        attributes.put("programid", label);
        label = String.valueOf(label) + " Line: " + line.toString();
        attributes.put("name", label);
        StringBuilder hoverText = this.setMarkerType(this.debugfile, line);
        hoverText.append("[Statement: " + attributes.get("stmtNumber").toString() + "] - ");
        hoverText.append(attributes.get("source"));
        attributes.put("message", hoverText.toString());
        if (this.markerType.equals("com.ca.intertest.breakpoint.watch")) {
            this.processVariable(attributes, this.debugfile);
        }
        return true;
    }

    protected abstract StringBuilder setMarkerType(debugFile var1, int var2);

    public Statement getStmtTree() {
        if (this.lister == null) {
            return Statement.nullStatement;
        }
        Outline outline = this.lister.getOutline();
        return outline == null ? Statement.nullStatement : outline.getStmtTree();
    }

    protected void processVariable(Map<String, Object> attributes, debugFile debugfile) {
        String stmt = (String)attributes.get("source");
        List tokens = this.getLister().getScansource().getStringTokens(stmt);
        if (tokens.size() != 0) {
            for (String token : tokens) {
                String key = String.format("%06d:%s", attributes.get("stmtNumber"), token);
                TreeObject[] items = this.getLister().getOutline().getQualifiedObjects(key);
                if (items.length <= 0) continue;
                if (debugfile.getLanguage() == 32 && "FILLER".equalsIgnoreCase(token)) break;
                attributes.put("left_variable", items[0].getAttribute("name"));
                Integer varLen = (Integer)Attribute.getValue("length", items[0]);
                attributes.put("left_value_len", varLen);
                attributes.put("left_type", (byte)1);
                break;
            }
        }
        attributes.put("markerType", this.markerType);
    }

    public boolean isBatch() {
        return this.session.isBatch();
    }

    public boolean isCICS() {
        return this.session.isCICS();
    }
}

