/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Messages;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITSecurityException;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.TTServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FileServer
extends ServerElement {
    public static final int SECURITY_FAILURE = -100;
    private String JCL_stream = null;
    private int reply;
    private String text;
    private Object data = null;

    public FileServer(IMemento child) {
        super(child);
        this.JCL_stream = child.getTextData();
        this.changed = false;
    }

    public FileServer(String name, String host, int port) {
        super(name, host, port, null);
        this.store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.intertest");
        this.name = name;
        this.hostname = host;
        this.port = port;
        this.prefix = String.valueOf(this.name) + "_";
        this.changed = false;
    }

    @Override
    public void setChild(IMemento child) {
        super.setChild(child);
        child.putTextData(this.getJCL_stream());
    }

    public String startServer() throws Exception, ITException {
        final String userID = this.getLogonUser();
        final FTPClient ftp = new FTPClient();
        ftp.connect(this.hostname);
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (ftp.login(userID, FileServer.this.getPassword())) {
                        String jclbuf = FileServer.this.getJCL_stream().replaceAll("%user%", userID.trim().toUpperCase());
                        jclbuf = jclbuf.replaceAll("%password%", FileServer.this.getPassword());
                        jclbuf = jclbuf.replaceAll("%port%", Integer.toString(FileServer.this.port));
                        jclbuf = jclbuf.replaceAll(Messages.FileServer_4, FileServer.this.hostname);
                        ftp.enterLocalPassiveMode();
                        FileServer.this.reply = ftp.site("FILETYPE=JES");
                        if (!FTPReply.isPositiveCompletion((int)FileServer.this.reply)) {
                            ftp.disconnect();
                            FileServer.this.reply = -1;
                            FileServer.this.text = String.valueOf(Messages.FileServer_6) + ftp.getReplyString();
                        } else if (!ftp.storeFile("JCL", (InputStream)new ByteArrayInputStream(jclbuf.getBytes()))) {
                            ftp.disconnect();
                            FileServer.this.reply = -1;
                            FileServer.this.text = String.valueOf(Messages.FileServer_8) + ftp.getReplyString();
                        } else {
                            String[] result = ftp.getReplyStrings();
                            FileServer.this.text = Messages.FileServer_9;
                            int index = result[0].indexOf("250-");
                            if (index >= 0) {
                                FileServer fileServer = FileServer.this;
                                fileServer.text = String.valueOf(fileServer.text) + result[0].substring(index + 4).trim();
                            }
                            ftp.disconnect();
                            FileServer.this.reply = 0;
                        }
                    } else {
                        ftp.disconnect();
                        FileServer.this.resetUserDialog();
                        FileServer.this.reply = -100;
                        FileServer.this.text = Messages.FileServer_11;
                    }
                }
                catch (IOException e) {
                    FileServer.this.reply = -1;
                    FileServer.this.text = HexUtil.getErrorText((Throwable)e);
                }
            }
        });
        if (this.reply == 0) {
            return this.text;
        }
        if (this.reply == -100) {
            throw new ITSecurityException(this.text);
        }
        throw new ITException(this.text);
    }

    public boolean stopServer() {
        return true;
    }

    public String getJCL_stream() {
        if (this.JCL_stream == null || this.JCL_stream.length() < 3) {
            this.JCL_stream = IntertestPlugin.getConfigurationPreferences().getString("JCL_stream");
        }
        return this.JCL_stream;
    }

    public void setJCL_stream(String jcl_stream) {
        this.JCL_stream = jcl_stream;
        this.changed = true;
    }

    @Override
    public boolean isCICS_server() {
        return false;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String getLogonUser() throws ITException {
        TTServer thisServer = ServerList.getInstance().getInterTestServerByName(this.getName());
        try {
            thisServer.getLogonUser();
        }
        catch (TTException e) {
            throw new ITException((Throwable)e);
        }
        String newUser = thisServer.getUser();
        this.setPassword(HexUtil.decryptPassword((String)newUser, (String)thisServer.getEPassword()));
        this.setUser(newUser);
        this.setSavepassword(thisServer.isSavepassword());
        this.setUserDialog();
        return super.getLogonUser();
    }
}

