/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Structures;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.CoreExprNameDialog;
import com.ca.intertest.dialogs.LayoutDialog;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.wizards.CoreWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public abstract class CoreExpressionDialog
extends LayoutDialog {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected static final int ALL_GRAY = 0;
    protected static final int CICS_SYSTEM_AREAS = 1;
    protected static final int CICS_TASK_AREAS = 3;
    protected static final int KEYWORD_AREAS = 4;
    protected static final int PROGRAM = 5;
    protected static final int ASSEMBLER_AREAS = 6;
    protected static final int CORE_EXPRESSION = 7;
    protected static final int CORE_LOCATION = 8;
    protected static final String TYPE_LITERAL = "type";
    protected static final String DSECT_LITERAL = "DSECT";
    protected static final String SYSTEM_LITERAL = "system";
    protected static final String MEMBER_LITERAL = "member";
    protected static final String TASK_LITERAL = "task";
    protected static final String BREAKPOINT_LITERAL = "breakpoint";
    protected static final String PROGRAM_LITERAL = "program";
    protected static final String ONE_SPACE = " ";
    protected static final String NULL_STRING = "";
    protected static final int LEVEL1_VARIABLES = 1;
    protected static final int ALL_VARIABLES = 2;
    protected static final int GROUP_VARIABLES = 3;
    protected final IPreferenceStore store = IntertestPlugin.getConfigurationPreferences();
    protected HashMap<String, IMemento> map = new HashMap();
    protected HashMap<String, String> attributes;
    protected HashMap<String, String> views = new HashMap();
    protected static final int SELECTIONGROUP_COLUMNS = 2;
    protected Group selectionGroup = null;
    protected Group optionsGroup = null;
    protected IResource resource;
    protected IDialogSettings settings;
    protected static final String KEYWORD_LITERAL = "keyword";
    protected static final String EXPRESSION_LITERAL = "expression";
    protected static final String ASSEMBLER_LITERAL = "assembler";
    protected int goFlag;
    protected int systemCount;
    protected int taskCount;
    protected int keywordCount;
    protected int programCount;
    protected int lang;
    protected ListerEditor listeditor;
    protected AbstractDataViewPage page;
    protected Debug debug = Debug.getInstance();
    protected Button coreExpressionRadioButton = null;
    protected Button locationRadioButton = null;
    protected Button cicsSystemAreasRadioButton = null;
    protected Button cicsTaskAreasRadioButton = null;
    protected Button keywordAreasRadioButton = null;
    protected Button programRadioButton = null;
    protected Button assemblerAreasRadioButton = null;
    protected Button whereCheckbox = null;
    protected Button enquoteCheckbox = null;
    protected Button enquote2Checkbox = null;
    protected GridData gridData;
    protected GridData gridData2;
    protected Combo cicsSystemAreasCombo;
    protected Combo cicsTaskAreasCombo;
    protected Combo keywordAreasCombo;
    protected Combo programCombo;
    protected Combo registerSymbolCombo;
    protected Text offsetText = null;
    protected Text coreExpressionText = null;
    protected Text locationText = null;
    protected Text displacementText = null;
    protected Text keywordAreasParmText = null;
    protected Text programParmText = null;
    protected Text baseText = null;
    protected Text labelText = null;
    protected Text registerText = null;
    protected Text argumentText = null;
    public TreeObject treeobject;
    public TreeObject useTreeobject;
    protected boolean whereFlag = false;
    protected boolean useWhere = false;
    protected boolean decimalFlag = false;
    protected boolean go2core = false;
    private boolean isDump = false;
    protected int grayFlag = 0;
    protected boolean noDsect = false;
    protected boolean isCICS;
    protected String title;
    protected String initialCmd = " ";
    protected String key = "";
    protected String type = "";
    protected String dsect = "";
    protected String member = "";
    protected String exprCmd = "";
    protected String keyWord = "";
    protected String[] values;
    protected String program = "";
    protected String options = "";
    protected String smsg = "";
    protected String offsetIncre = "";
    protected String errMsg = "";
    protected String asmBase = "";
    protected String asmLabel = "";
    protected String displacement = "";
    protected String view = "";
    protected String description = "";
    protected short asmRegister = 0;
    protected short asmArgument = 0;
    protected short errLevel = 0;
    protected ArrayList<String> cicsSystemAreasValues = new ArrayList();
    protected ArrayList<String> cicsTaskAreasValues = new ArrayList();
    protected ArrayList<String> keywordAreasValues = new ArrayList();
    protected ArrayList<String> programAreasValues = new ArrayList();
    protected boolean isSession = false;
    protected Object[] objstr;

    public CoreExpressionDialog(Shell parentShell) {
        super(parentShell);
    }

    public CoreExpressionDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public abstract void init(ListerEditor var1, IResource var2, String var3, String var4, int var5, AbstractDataViewPage var6, debugSession var7);

    @Override
    protected Control createDialogArea(Composite parent) {
        this.settings = this.getDialogSettings();
        this.grayFlag = this.initSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.gridData = new GridData(1808);
        composite.setLayoutData((Object)this.gridData);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createSelectionGroup(composite);
        this.grayControls(this.grayFlag);
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    protected void createSelectionGroup(Composite parent) {
        this.selectionGroup = new Group(parent, 0);
        this.selectionGroup.setText(Messages.CoreExpressionDialog_16);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        this.selectionGroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.selectionGroup.setLayoutData((Object)this.gridData);
    }

    protected void createCoreExpressionRadioButton() {
        this.coreExpressionRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.coreExpressionRadioButton.setText(Messages.CoreExpressionDialog_17);
        this.coreExpressionRadioButton.setSelection(this.settings.getBoolean(EXPRESSION_LITERAL));
        this.gridData = new GridData(32);
        this.coreExpressionRadioButton.setLayoutData((Object)this.gridData);
        this.coreExpressionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(7);
            }
        });
        this.coreExpressionText = new Text((Composite)this.selectionGroup, 2048);
        this.coreExpressionText.setText(this.initialCmd);
        this.gridData = new GridData(32);
        this.gridData.widthHint = 300;
        this.coreExpressionText.setTextLimit(128);
        this.coreExpressionText.setLayoutData((Object)this.gridData);
        this.coreExpressionText.addVerifyListener((VerifyListener)new verifytoUpperCase());
    }

    protected void createCICSSystemAreasRadioButton() {
        this.cicsSystemAreasRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.cicsSystemAreasRadioButton.setText(Messages.CoreExpressionDialog_18);
        this.cicsSystemAreasRadioButton.setSelection(this.settings.getBoolean(SYSTEM_LITERAL));
        this.gridData = new GridData(32);
        this.cicsSystemAreasRadioButton.setLayoutData((Object)this.gridData);
        this.cicsSystemAreasRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(1);
            }
        });
        this.cicsSystemAreasCombo = new Combo((Composite)this.selectionGroup, 524);
        this.gridData = new GridData(32);
        this.cicsSystemAreasCombo.setTextLimit(12);
        this.gridData.grabExcessHorizontalSpace = false;
        this.objstr = this.cicsSystemAreasValues.toArray();
        Arrays.sort(this.objstr);
        Object[] objectArray = this.objstr;
        int n = this.objstr.length;
        int n2 = 0;
        while (n2 < n) {
            Object ss = objectArray[n2];
            this.cicsSystemAreasCombo.add((String)ss);
            ++n2;
        }
        this.cicsSystemAreasCombo.setText((String)this.objstr[0]);
        this.cicsSystemAreasCombo.setLayoutData((Object)this.gridData);
        this.cicsSystemAreasCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createCICSTaskAreasRadioButton() {
        this.cicsTaskAreasRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.cicsTaskAreasRadioButton.setText(Messages.CoreExpressionDialog_19);
        this.cicsTaskAreasRadioButton.setSelection(this.settings.getBoolean(TASK_LITERAL));
        this.gridData = new GridData(32);
        this.cicsTaskAreasRadioButton.setLayoutData((Object)this.gridData);
        this.cicsTaskAreasRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(3);
            }
        });
        this.cicsTaskAreasCombo = new Combo((Composite)this.selectionGroup, 524);
        this.gridData = new GridData(32);
        this.cicsTaskAreasCombo.setTextLimit(12);
        this.gridData.grabExcessHorizontalSpace = false;
        this.objstr = this.cicsTaskAreasValues.toArray();
        Arrays.sort(this.objstr);
        Object[] objectArray = this.objstr;
        int n = this.objstr.length;
        int n2 = 0;
        while (n2 < n) {
            Object ss = objectArray[n2];
            this.cicsTaskAreasCombo.add((String)ss);
            ++n2;
        }
        this.cicsTaskAreasCombo.setText((String)this.objstr[0]);
        this.cicsTaskAreasCombo.setLayoutData((Object)this.gridData);
        this.cicsTaskAreasCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createKeywordAreasRadioButton() {
        this.keywordAreasRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.keywordAreasRadioButton.setText(Messages.CoreExpressionDialog_20);
        this.keywordAreasRadioButton.setSelection(this.settings.getBoolean(KEYWORD_LITERAL));
        this.gridData = new GridData(32);
        this.keywordAreasRadioButton.setLayoutData((Object)this.gridData);
        this.keywordAreasRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(4);
            }
        });
        this.keywordAreasCombo = new Combo((Composite)this.selectionGroup, 524);
        this.gridData = new GridData(32);
        this.keywordAreasCombo.setTextLimit(12);
        this.gridData.grabExcessHorizontalSpace = false;
        this.objstr = this.keywordAreasValues.toArray();
        Arrays.sort(this.objstr);
        Object[] objectArray = this.objstr;
        int n = this.objstr.length;
        int n2 = 0;
        while (n2 < n) {
            Object ss = objectArray[n2];
            this.keywordAreasCombo.add((String)ss);
            ++n2;
        }
        this.keywordAreasCombo.setText((String)this.objstr[0]);
        this.keywordAreasCombo.setLayoutData((Object)this.gridData);
        this.keywordAreasCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createProgramRadioButton() {
        this.programRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.programRadioButton.setText(Messages.CoreExpressionDialog_21);
        this.programRadioButton.setSelection(this.settings.getBoolean(PROGRAM_LITERAL));
        this.gridData = new GridData(32);
        this.programRadioButton.setLayoutData((Object)this.gridData);
        this.programRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(5);
            }
        });
        Composite programgroup = new Composite((Composite)this.selectionGroup, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        programgroup.setLayout((Layout)groupLayout);
        this.programCombo = new Combo(programgroup, 524);
        this.gridData = new GridData(32);
        this.programCombo.setTextLimit(12);
        this.gridData.grabExcessHorizontalSpace = false;
        this.objstr = this.programAreasValues.toArray();
        Arrays.sort(this.objstr);
        Object[] objectArray = this.objstr;
        int n = this.objstr.length;
        int n2 = 0;
        while (n2 < n) {
            Object ss = objectArray[n2];
            this.programCombo.add((String)ss);
            ++n2;
        }
        this.programCombo.setText((String)this.objstr[0]);
        this.programCombo.setLayoutData((Object)this.gridData);
        this.programCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(programgroup, 0);
        label.setText(Messages.CoreExpressionDialog_22);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.programParmText = new Text(programgroup, 2048);
        this.programParmText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.programParmText.setTextLimit(8);
        this.programParmText.setLayoutData((Object)this.gridData);
    }

    protected void createAssemblerAreasRadioButton() {
        this.assemblerAreasRadioButton = new Button((Composite)this.selectionGroup, 16);
        this.assemblerAreasRadioButton.setText(Messages.CoreExpressionDialog_23);
        this.assemblerAreasRadioButton.setSelection(this.settings.getBoolean(ASSEMBLER_LITERAL));
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 2;
        this.assemblerAreasRadioButton.setLayoutData((Object)this.gridData);
        this.assemblerAreasRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreExpressionDialog.this.grayControls(6);
            }
        });
        Composite asmgroup = new Composite((Composite)this.selectionGroup, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        asmgroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.gridData.horizontalIndent = 10;
        this.gridData.horizontalSpan = 2;
        asmgroup.setLayoutData((Object)this.gridData);
        Label label = new Label(asmgroup, 0);
        label.setText(Messages.CoreExpressionDialog_24);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.baseText = new Text(asmgroup, 2048);
        this.baseText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.baseText.setTextLimit(8);
        this.baseText.setLayoutData((Object)this.gridData);
        this.baseText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        label = new Label(asmgroup, 0);
        label.setText(Messages.CoreExpressionDialog_25);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.labelText = new Text(asmgroup, 2048);
        this.labelText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.labelText.setTextLimit(8);
        this.labelText.setLayoutData((Object)this.gridData);
        this.labelText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        label = new Label(asmgroup, 0);
        label.setText(Messages.CoreExpressionDialog_26);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.registerText = new Text(asmgroup, 2048);
        this.registerText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.registerText.setTextLimit(2);
        this.registerText.setLayoutData((Object)this.gridData);
        this.registerText.addVerifyListener((VerifyListener)new verifyDigit(false));
        label = new Label(asmgroup, 0);
        label.setText(Messages.CoreExpressionDialog_27);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.registerSymbolCombo = new Combo(asmgroup, 524);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.registerSymbolCombo.setTextLimit(12);
        this.gridData.grabExcessHorizontalSpace = false;
        Object[] registerSymbolValues = new String[]{ONE_SPACE, Messages.CoreExpressionDialog_28, Messages.CoreExpressionDialog_29, Messages.CoreExpressionDialog_30};
        Arrays.sort(registerSymbolValues);
        int i = 0;
        while (i < registerSymbolValues.length) {
            this.registerSymbolCombo.add((String)registerSymbolValues[i]);
            ++i;
        }
        this.registerSymbolCombo.setText((String)registerSymbolValues[0]);
        this.registerSymbolCombo.setLayoutData((Object)this.gridData);
        this.registerSymbolCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(asmgroup, 0);
        label.setText(Messages.CoreExpressionDialog_31);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.argumentText = new Text(asmgroup, 2048);
        this.argumentText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.argumentText.setTextLimit(2);
        this.argumentText.setLayoutData((Object)this.gridData);
        this.argumentText.addVerifyListener((VerifyListener)new verifyDigit(false));
    }

    protected void createOptionsGroup(Composite parent) {
        this.optionsGroup = new Group(parent, 0);
        this.optionsGroup.setText(Messages.CoreExpressionDialog_32);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        this.optionsGroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.optionsGroup.setLayoutData((Object)this.gridData);
        Label label = new Label((Composite)this.optionsGroup, 0);
        label.setText(Messages.CoreExpressionDialog_33);
        this.gridData = new GridData(128);
        label.setLayoutData((Object)this.gridData);
        this.offsetText = new Text((Composite)this.optionsGroup, 2048);
        this.offsetText.setText(NULL_STRING);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.offsetText.setTextLimit(9);
        this.offsetText.setLayoutData((Object)this.gridData);
        this.buildWhereCheckbox((Composite)this.optionsGroup);
        this.buildNullLabel((Composite)this.optionsGroup);
        this.buildUseControls((Composite)this.optionsGroup);
        this.optionsGroup.setSize(this.optionsGroup.computeSize(-1, -1));
    }

    protected void buildNullLabel(Composite parent) {
        Label nullLabel = new Label(parent, 0);
        nullLabel.setText(ONE_SPACE);
        this.gridData = new GridData(64);
        nullLabel.setLayoutData((Object)this.gridData);
    }

    protected void doProcessKeywords() {
        if (this.errLevel < 5) {
            boolean b = true;
            if (this.keyWord.length() > 0 && this.exprCmd.length() == 0 && (this.offsetIncre.length() > 0 || this.whereFlag)) {
                this.exprCmd = this.keyWord;
                b = false;
            }
            if (b && this.dsect != null && this.dsect.length() > 0) {
                try {
                    if (this.useProgram.length() == 0) {
                        this.treeobject = Keywords.getTree(this.keyWord, this.serverType, this.version);
                        this.treeobject.setAlternateName(String.valueOf(this.dsect) + "." + this.member);
                    } else {
                        this.treeobject = this.useTreeobject;
                        this.treeobject.setAlternateName(String.valueOf(this.useProgram) + "." + this.useStructure);
                        this.serverType = NULL_STRING;
                        this.version = NULL_STRING;
                    }
                    if (this.treeobject != null) {
                        String prefix = NULL_STRING;
                        this.errMsg = String.valueOf(Messages.CoreExpressionDialog_36) + Messages.CoreExpressionDialog_37 + prefix + this.keyWord;
                        this.errMsg = this.useProgram.length() > 0 ? String.valueOf(this.errMsg) + Messages.CoreExpressionDialog_38 + this.useProgram + "." + this.useStructure : String.valueOf(this.errMsg) + Messages.CoreExpressionDialog_40 + this.dsect + Messages.CoreExpressionDialog_41 + this.member + Messages.CoreExpressionDialog_42 + this.serverType + Messages.CoreExpressionDialog_43 + this.version;
                        this.errLevel = (short)99;
                        this.doError(this.errMsg, this.errLevel);
                        if (this.errLevel == 0) {
                            this.treeobject.setKeyword(this.keyWord);
                            if (!this.isDump) {
                                this.save_keyword();
                            } else {
                                this.exprCmd = this.keyWord;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
        }
    }

    protected void doProcessExpressions() {
        String exprName = NULL_STRING;
        if (this.errLevel < 5 && this.exprCmd.length() > 0 && this.exprCmd != null) {
            if (this.offsetIncre.length() > 0) {
                this.exprCmd = String.valueOf(this.exprCmd) + this.offsetIncre;
            }
            if (this.whereFlag) {
                this.exprCmd = String.valueOf(this.exprCmd) + Messages.CoreExpressionDialog_44;
            }
            this.errMsg = String.valueOf(Messages.CoreExpressionDialog_45) + Messages.CoreExpressionDialog_46 + this.exprCmd;
            if (this.useProgram.length() > 0) {
                this.errMsg = String.valueOf(this.errMsg) + Messages.CoreExpressionDialog_38 + this.useProgram + "." + this.useStructure;
            }
            this.errLevel = (short)99;
            this.doError(this.errMsg, this.errLevel);
            if (this.errLevel == 0) {
                if (this.useProgram.length() > 0) {
                    this.keyWord = this.exprCmd;
                    this.treeobject = this.useTreeobject;
                    this.treeobject.setAlternateName(String.valueOf(this.useProgram) + "." + this.useStructure);
                    this.treeobject.setKeyword(this.keyWord);
                    this.serverType = NULL_STRING;
                    this.version = NULL_STRING;
                    if (this.view.length() < 1) {
                        this.view = this.isSession ? "com.ca.intertest.ui.views.sessionview" : "com.ca.intertest.ui.views.dataview";
                    }
                }
                if (!this.isDump) {
                    int dlgFlag = 99;
                    if (this.noDsect) {
                        dlgFlag = 0;
                        exprName = this.exprCmd;
                    } else {
                        CoreExprNameDialog exprNameDlg = new CoreExprNameDialog(this.getShell());
                        exprNameDlg.init(Messages.CoreExpressionDialog_50);
                        exprNameDlg.setView(this.view);
                        dlgFlag = exprNameDlg.open();
                        if (dlgFlag == 0) {
                            exprName = exprNameDlg.getExprName();
                        }
                    }
                    if (dlgFlag == 0) {
                        this.treeobject = Expressions.getTree(exprName, "CORE_EXPRESSION");
                        this.treeobject.setKeyword(exprName);
                        this.treeobject.setAlternateName(this.exprCmd);
                        Integer len = this.store.getInt("DATAVIEW_ASM_VAR_DEFAULT_LENGTH");
                        if (len == 0) {
                            len = 20;
                        }
                        this.treeobject.setAttribute("length", Integer.toString(len));
                        this.save_exprcmd(exprName, this.exprCmd);
                        CoreWizard wizard = new CoreWizard();
                        wizard.initCmd(this.listeditor, this.exprCmd, true);
                        MemoryWizardDialog dialog = new MemoryWizardDialog(this.page.getSite().getShell(), (IWizard)wizard);
                        dialog.create();
                        dialog.open();
                    } else {
                        this.errLevel = (short)5;
                    }
                }
            }
        }
        if (this.errLevel < 5) {
            this.checkSettings();
            super.okPressed();
        }
    }

    private synchronized void save_exprcmd(final String exprName, final String postCmd) {
        if (this.resource != null) {
            IWorkspaceRunnable rr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        CoreExpressionDialog.this.setAttribute("altname", postCmd);
                        CoreExpressionDialog.this.setAttribute("keeptype", "DATAVIEW_EXPRESSION");
                        CoreExpressionDialog.this.setAttribute(CoreExpressionDialog.KEYWORD_LITERAL, exprName);
                        CoreExpressionDialog.this.setAttribute("name", CoreExpressionDialog.this.treeobject.getName());
                        CoreExpressionDialog.this.setAttribute("postview", CoreExpressionDialog.this.view);
                        IMarker marker = CoreExpressionDialog.this.resource.createMarker("com.ca.intertest.keep");
                        if (marker != null && marker.exists()) {
                            marker.setAttributes(CoreExpressionDialog.this.attributes);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            try {
                this.resource.getWorkspace().run(rr, (ISchedulingRule)this.resource.getProject(), 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    protected abstract void checkSettings();

    protected abstract int initSettings();

    public synchronized void save_keyword() {
        if (this.resource != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        CoreExpressionDialog.this.setAttribute("altname", CoreExpressionDialog.this.treeobject.getAlternateName());
                        CoreExpressionDialog.this.setAttribute("keeptype", "DATAVIEW_KEYWORD");
                        CoreExpressionDialog.this.setAttribute(CoreExpressionDialog.KEYWORD_LITERAL, CoreExpressionDialog.this.keyWord);
                        CoreExpressionDialog.this.setAttribute("name", CoreExpressionDialog.this.treeobject.getName());
                        CoreExpressionDialog.this.setAttribute("postview", CoreExpressionDialog.this.view);
                        CoreExpressionDialog.this.setAttribute("servertype", CoreExpressionDialog.this.serverType);
                        CoreExpressionDialog.this.setAttribute("serverversion", CoreExpressionDialog.this.version);
                        IMarker marker = CoreExpressionDialog.this.resource.createMarker("com.ca.intertest.keep");
                        if (marker != null && marker.exists()) {
                            marker.setAttributes(CoreExpressionDialog.this.attributes);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            try {
                this.resource.getWorkspace().run(r, (ISchedulingRule)this.resource.getProject(), 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void doCoreExpression() {
        this.exprCmd = this.coreExpressionText.getText();
        if (this.exprCmd.equals(Messages.CoreExpressionDialog_51) || this.exprCmd.equals(Messages.CoreExpressionDialog_52)) {
            this.view = "com.ca.intertest.ui.views.registerview";
        }
    }

    protected void doCicsSystemAreas() {
        this.values = this.cicsSystemAreasCombo.getText().split(ONE_SPACE);
        IMemento im = this.map.get(this.values[0]);
        this.dsect = im.getString(DSECT_LITERAL);
        this.member = im.getString(MEMBER_LITERAL);
        if (this.dsect == null) {
            this.exprCmd = this.values[0];
            this.noDsect = true;
        } else {
            this.keyWord = this.values[0];
        }
    }

    protected void doCicsTaskAreas() {
        this.values = this.cicsTaskAreasCombo.getText().split(ONE_SPACE);
        IMemento im = this.map.get(this.values[0]);
        this.dsect = im.getString(DSECT_LITERAL);
        this.member = im.getString(MEMBER_LITERAL);
        if (this.dsect == null) {
            this.exprCmd = this.values[0];
            this.noDsect = true;
        } else {
            this.keyWord = this.values[0];
        }
    }

    protected void doKeywordAreas() {
        this.values = this.keywordAreasCombo.getText().split(ONE_SPACE);
        IMemento im = this.map.get(this.values[0]);
        this.dsect = im.getString(DSECT_LITERAL);
        this.member = im.getString(MEMBER_LITERAL);
        this.view = this.views.get(this.values[0]);
        if (this.view == null) {
            this.view = NULL_STRING;
        }
        if (this.dsect == null) {
            this.exprCmd = this.values[0];
            this.noDsect = true;
        } else {
            this.keyWord = this.values[0];
        }
        if (this.values.length > 2) {
            this.description = this.values[2];
        }
    }

    protected void doProgram() {
        this.values = this.programCombo.getText().split(ONE_SPACE);
        String val = this.values[0];
        this.program = this.programParmText.getText().toUpperCase();
        if (this.program.length() > 0) {
            if (val.equals(Messages.CoreExpressionDialog_55) && this.program.length() > 4) {
                this.errMsg = String.valueOf(Messages.CoreExpressionDialog_56) + this.program;
                this.errLevel = (short)16;
                this.doError(this.errMsg, this.errLevel);
            }
            this.exprCmd = String.valueOf(val) + "=" + this.program;
        } else {
            this.errMsg = String.valueOf(Messages.CoreExpressionDialog_58) + this.values[0];
            this.errLevel = (short)16;
            this.doError(this.errMsg, this.errLevel);
        }
    }

    protected void doAssemblerAreas() {
        this.errLevel = 0;
        this.asmBase = NULL_STRING;
        this.asmLabel = NULL_STRING;
        this.asmRegister = (short)-1;
        this.asmArgument = (short)-1;
        if (this.baseText.getText().length() > 0 && !this.baseText.getText().equals(ONE_SPACE)) {
            this.asmBase = this.baseText.getText();
        }
        this.asmLabel = this.labelText.getText();
        if (this.registerText.getText().length() > 0) {
            this.asmRegister = Short.valueOf(this.registerText.getText());
        }
        if (this.argumentText.getText().length() > 0) {
            this.asmArgument = Short.valueOf(this.argumentText.getText());
        }
        if (this.argumentText.getText().length() > 0 && (this.registerText.getText().length() > 0 || this.asmBase.length() > 0 || this.asmLabel.length() > 0)) {
            this.errMsg = Messages.CoreExpressionDialog_59;
            this.errLevel = (short)16;
        }
        if (this.registerText.getText().length() > 0 && (this.argumentText.getText().length() > 0 || this.asmBase.length() > 0 || this.asmLabel.length() > 0)) {
            this.errMsg = Messages.CoreExpressionDialog_60;
            this.errLevel = (short)16;
        }
        if (this.asmBase.length() > 0 && (this.registerText.getText().length() > 0 || this.argumentText.getText().length() > 0)) {
            this.errMsg = Messages.CoreExpressionDialog_61;
            this.errLevel = (short)16;
        }
        if (this.asmLabel.length() > 0 && this.asmBase.length() == 0) {
            this.errMsg = Messages.CoreExpressionDialog_62;
            this.errLevel = (short)16;
        }
        if (this.errLevel > 4) {
            this.doError(this.errMsg, this.errLevel);
        } else {
            if (this.asmRegister > -1) {
                this.exprCmd = "R" + this.registerText.getText();
                this.values = this.registerSymbolCombo.getText().split(ONE_SPACE);
                if (this.registerSymbolCombo.getSelectionIndex() > 0) {
                    this.exprCmd = String.valueOf(this.exprCmd) + this.values[0];
                }
            } else if (this.asmArgument > -1) {
                this.exprCmd = "ARG" + this.argumentText.getText();
            } else if (this.asmBase.length() > 0) {
                this.exprCmd = "'" + this.asmBase;
                this.exprCmd = this.asmLabel.length() > 0 ? String.valueOf(this.exprCmd) + "." + this.asmLabel + "'" : String.valueOf(this.exprCmd) + "'";
            }
            this.errMsg = this.exprCmd;
        }
    }

    protected void doOptions() {
        this.offsetIncre = this.offsetText.getText();
        if (this.offsetIncre.length() > 0) {
            if (this.isCICS) {
                if (!(this.offsetIncre.substring(0, 1).equals("-") || this.offsetIncre.substring(0, 1).equals("+") || this.offsetIncre.substring(0, 1).equals("@") || this.offsetIncre.substring(0, 1).equals("%"))) {
                    this.offsetIncre = "+" + this.offsetIncre;
                }
            } else if (!(this.offsetIncre.substring(0, 1).equals("-") || this.offsetIncre.substring(0, 1).equals("+") || this.offsetIncre.substring(0, 1).equals("!") || this.offsetIncre.substring(0, 1).equals("?") || this.offsetIncre.substring(0, 1).equals("%"))) {
                this.offsetIncre = "+" + this.offsetIncre;
            }
        }
        if (this.useWhere) {
            this.whereFlag = this.whereCheckbox.getSelection();
        }
        this.doUse();
    }

    protected void doUse() {
        this.useProgram = this.useProgramCombo.getText();
        this.useStructure = this.useStructureCombo.getText();
        if (this.useStructure.length() > 0 && !this.useStructure.equals(ONE_SPACE)) {
            this.structobjs = Structures.getStructObjs();
            int i = 0;
            while (i < this.structobjs.size()) {
                if (this.useStructure.equals(((TreeObject)this.structobjs.get(i)).getName())) {
                    this.useTreeobject = (TreeObject)this.structobjs.get(i);
                }
                ++i;
            }
        } else {
            this.useProgram = NULL_STRING;
            this.useStructure = NULL_STRING;
        }
        if (this.useStructure.length() > 0 && this.useProgram.length() == 0) {
            this.errMsg = Messages.CoreExpressionDialog_80;
            this.errLevel = (short)8;
            this.doError(this.errMsg, this.errLevel);
            this.useProgram = NULL_STRING;
            this.useStructure = NULL_STRING;
        } else if (this.useStructure.length() == 0 && this.useProgram.length() > 0) {
            this.errMsg = Messages.CoreExpressionDialog_81;
            this.errLevel = (short)16;
            this.doError(this.errMsg, this.errLevel);
        }
    }

    protected void doError(String msg, short level) {
        if (level == 99) {
            this.errLevel = 0;
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)(String.valueOf(Messages.CoreExpressionDialog_82) + Messages.CoreExpressionDialog_83 + level), (String)(String.valueOf(msg) + "\n"));
        }
    }

    public String getExprCmd() {
        return this.exprCmd;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public String getProgram() {
        return this.program;
    }

    public boolean getGo2Core() {
        return this.go2core;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    protected void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.unsetAttribute(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        }
    }

    protected abstract void grayControls(int var1);

    protected abstract void buildWhereCheckbox(Composite var1);

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    protected boolean isDump() {
        return this.isDump;
    }

    protected void setDump(boolean isDump) {
        this.isDump = isDump;
    }
}

