/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.debug.debugPropertySource;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileType;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.scanASM;
import com.ca.intertest.tools.scanCOBOL;
import com.ca.intertest.tools.scanPLI;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySource;

public class debugFile
implements IDebug,
IAdaptable,
IPropertyChangeListener {
    String cacopyright = "Copyright (c) 2016 CA";
    private final IFile file;
    private ZipFile zipfile = null;
    private final debugSession session;
    private debugPropertySource source = null;
    private final ResourceProperty store;
    private IScanSource scansource;
    private IResourceChangeListener listener;
    private final ListenerList fileListeners = new ListenerList();
    private boolean count = false;
    private boolean datamonitor = false;
    private boolean backtrace = false;
    private boolean entered = false;
    private Outline outline;
    private boolean initialbreakpoint;
    private final decorator filedecorator;
    private HashMap<Long, BreakpointMarker> breakpointmarkers = null;
    private final ListenerList propertyChangeListeners = new ListenerList(1);
    protected FileType filetype;
    private int language;
    private IPropertyChangeListener propertylistener = null;

    public debugFile(IFile file, final debugSession session) throws ITException {
        this.store = new FileStore((IResource)file);
        this.filedecorator = new decorator();
        this.session = session;
        if (!decorator.isIntertest(this.store)) {
            throw new ITException(String.format(Messages.debugFile_2, file.getFullPath()));
        }
        this.file = file;
        this.count = this.store.getBoolean("execution_count");
        this.listener = new ResourceChangeListener();
        this.setScanner();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 1);
        String type = this.store.getString("item_type");
        if (type == null) {
            type = "PROGID";
        }
        try {
            this.filetype = Enum.valueOf(FileType.class, this.store.getString("item_type"));
        }
        catch (Exception exception) {
            this.filetype = FileType.PROGID;
        }
        this.datamonitor = this.store.getBoolean("data_monitor");
        this.backtrace = this.store.getBoolean("back_trace");
        this.addPropertyChangeListener(this);
        if (session.isBatch()) {
            debugMarkerGroup group = this.getMarkergroup();
            IDebugMarker marker = group.getMarker((short)128);
            this.initialbreakpoint = marker.isEnabled();
            this.propertylistener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (!event.getProperty().equals("monitor_pgm")) {
                        return;
                    }
                    if (session.isDebugging()) {
                        return;
                    }
                    boolean enabled = Boolean.parseBoolean(event.getNewValue().toString());
                    if (!enabled) {
                        return;
                    }
                    final debugBatchSession debugsession = (debugBatchSession)session;
                    final String protsym = (String)Attribute.getValue("dsn", debugFile.this.store);
                    if (protsym.length() == 0) {
                        return;
                    }
                    if (debugsession.getProtsymlist().indexOf(protsym) != -1) {
                        return;
                    }
                    final Display display = Display.getDefault();
                    if (display != null) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                String message = String.valueOf(Messages.debugFile_4) + IConstants.LINEFEED + IConstants.LINEFEED + Messages.debugFile_5 + debugFile.this.getName() + Messages.debugFile_6 + protsym + Messages.debugFile_7 + IConstants.LINEFEED + IConstants.LINEFEED + Messages.debugFile_8;
                                if (MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)(String.valueOf(Messages.debugFile_9) + debugFile.this.getName()), (String)message)) {
                                    debugsession.addProtsym(protsym);
                                }
                            }
                        });
                    }
                }
            };
            this.store.addPropertyChangeListener(this.propertylistener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    @Override
    public void dispose() {
        this.store.removePropertyChangeListener(this.propertylistener);
        this.propertyChangeListeners.clear();
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
        this.store.save();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof debugFile)) {
            return false;
        }
        debugFile proj = (debugFile)obj;
        return proj.getResource().equals((Object)this.file);
    }

    @Override
    public void firePropertyChangeListeners(PropertyChangeEvent event) {
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IPropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.source == null) {
                this.source = new debugPropertySource(this);
            }
            return this.source;
        }
        if (this.file != null) {
            return this.file.getAdapter(adapter);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public Object[] getChildren() {
        return new Object[0];
    }

    @Override
    public debugMarkerGroup getMarkergroup() {
        try {
            return debugMarkerGroup.LoadMarkers(this);
        }
        catch (ITException iTException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return decorator.getShortName(this.store);
    }

    @Override
    public Object getParent() {
        return this.session;
    }

    @Override
    public debugSession getSession() {
        return this.session;
    }

    @Override
    public IResource getResource() {
        return this.file;
    }

    public IScanSource getScansource() {
        return this.scansource;
    }

    @Override
    public ResourceProperty getStore() {
        return this.store;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    private void setScanner() {
        this.language = this.store.getHex("gt_m_lang");
        switch (this.language) {
            case 32: {
                if (this.scansource instanceof scanCOBOL) break;
                this.scansource = new scanCOBOL(this.store.getString("gt_m_cty"));
                break;
            }
            case 16: {
                if (this.scansource instanceof scanASM) break;
                this.scansource = new scanASM(this.store.getString("gt_m_aty"));
                break;
            }
            case 128: {
                if (!(this.scansource instanceof scanPLI)) {
                    this.scansource = new scanPLI(this.store.getString("gt_m_plc"));
                }
                ((scanPLI)this.scansource).setScantype(this.store.getInt("scantype"));
            }
        }
    }

    public void refresh() {
        if (this.outline != null) {
            try {
                this.outline.reLoad();
            }
            catch (ITException e) {
                Logger.loggit(e);
                this.outline = null;
            }
        }
        this.store.reLoad();
        this.setScanner();
    }

    @Override
    public synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public String toString() {
        String format = Messages.debugFile_15;
        if (this.filetype == FileType.PROGID) {
            format = String.valueOf(format) + Messages.debugFile_16;
        }
        return String.format(format, this.getName(), this.isMonitor() ? "" : "Not", this.isEntered() ? Messages.debugFile_19 : "Not");
    }

    public InputStream getSettingsstream() {
        ZipEntry entry;
        if (this.zipfile == null) {
            try {
                this.zipfile = new ZipFile(this.file.getLocation().toFile(), 1);
            }
            catch (IOException iOException) {}
        }
        if (this.zipfile != null && (entry = this.zipfile.getEntry("metadata")) != null) {
            try {
                return this.zipfile.getInputStream(entry);
            }
            catch (IOException e) {
                Logger.loggit(e);
            }
        }
        return null;
    }

    public boolean isMonitor() {
        return this.store.getBoolean("monitor_pgm");
    }

    public boolean isSubModule() {
        return this.isProgram() && this.getName().indexOf(95) > 0;
    }

    public boolean isModule() {
        return !this.isMainModule() && !this.isSubModule();
    }

    public boolean isMainModule() {
        if (this.isSubModule()) {
            return false;
        }
        if (this.filetype != FileType.PROGID) {
            return false;
        }
        Integer mflag = (Integer)Attribute.getValue("gt_m_flg", this.store);
        if ((mflag & 4) == 4) {
            return true;
        }
        for (debugFile item : this.session.getMonitored(this.isMonitor())) {
            if (!item.getName().startsWith(this.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public void setMonitor(boolean monitor) {
        this.setMonitor(monitor, true);
    }

    public void setMonitor(boolean monitor, boolean post) {
        boolean oldvalue = this.isMonitor();
        if (oldvalue != monitor) {
            this.store.setValue("monitor_pgm", monitor);
            this.store.save();
            if (this.isSubModule()) {
                if (!monitor) {
                    if (this.breakpointmarkers == null) {
                        this.loadbreakpointmarkers();
                    }
                    if (this.breakpointmarkers != null) {
                        for (BreakpointMarker marker : this.breakpointmarkers.values()) {
                            marker.setBreakpointID(0L);
                        }
                    }
                }
            } else {
                for (debugFile item : this.session.getMonitored(oldvalue)) {
                    if (!item.getName().startsWith(this.getPrefix())) continue;
                    item.setMonitor(monitor, false);
                }
                if (post && this.session.isDebugging()) {
                    try {
                        Display display;
                        if (monitor && this.isDataMonitor() && this.isStatementTrace() && !this.session.isDataMonitorOK() && this.session.isCICS() && (display = Display.getDefault()) != null) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String msg = String.format(Messages.debugFile_23, debugFile.this.filetype.toString());
                                    MessageDialog.openWarning((Shell)display.getActiveShell(), (String)(String.valueOf(Messages.debugFile_9) + debugFile.this.getTitle()), (String)msg);
                                }
                            });
                        }
                        this.session.addMonitor(this);
                        this.session.post(null);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
            }
            this.entered = false;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.intertest.ui.views.debug", (Object)this, (Object)this);
            this.firePropertyChangeListeners(event);
        }
    }

    @Override
    public boolean isExecutionCount() {
        if (this.session.isBatch()) {
            return this.session.isExecutionCount();
        }
        return this.count;
    }

    @Override
    public void setExecutionCount(boolean count) {
        if (this.session.isBatch()) {
            this.session.setExecutionCount(count);
            return;
        }
        if (this.count != count) {
            this.count = count;
            this.store.setValue("execution_count", count);
            this.store.save();
            if (this.session.isDebugging() && this.isMonitor()) {
                short sub = count ? (short)1 : 2;
                DebugTalker talker = this.session.getTalker();
                try {
                    if (this.session.isAtBreakpoint() && talker.getDebugfile().equals(this)) {
                        CVMI cvmi = new CVMI();
                        ExecutionCountsMessage msg = new ExecutionCountsMessage(this);
                        msg.setSubmessageID(sub);
                        cvmi.addMessage((DebugMessage)msg);
                        talker.process(cvmi);
                    } else {
                        this.session.addExecutionCount(this, true, sub);
                        this.session.post(null);
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "execution_count", (Object)this, (Object)this));
        }
    }

    @Override
    public void fireDebugMessageListeners(debugEvent event) {
        Object[] objectArray = this.fileListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDebugListener)listener).debugEventOccured(event);
            ++n2;
        }
    }

    @Override
    public synchronized void removeDebugListener(IDebugListener listener) {
        if (listener != null) {
            this.fileListeners.remove((Object)listener);
        }
    }

    @Override
    public synchronized void addDebugListener(IDebugListener listener) {
        if (listener != null) {
            this.fileListeners.add((Object)listener);
        }
    }

    @Override
    public String getTitle() {
        return this.filedecorator.decorateText("", this.file, this.store);
    }

    @Override
    public BreakpointMarker getBreakpointMarker(long ID) {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        return this.getBreakpointMarker(new Long(ID));
    }

    private void loadbreakpointmarkers() {
        this.breakpointmarkers = new HashMap();
        try {
            IMarker marker;
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.file.findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.exists() && marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                    try {
                        this.addBreakpointMarker(marker);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
            iMarkerArray = markers = this.file.findMarkers("com.ca.intertest.monitor", true, 0);
            n = markers.length;
            n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.exists()) {
                    try {
                        this.addBreakpointMarker(marker);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    @Override
    public BreakpointMarker getBreakpointMarker(Long ID) {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        return this.breakpointmarkers.get(ID);
    }

    protected void removeBreakpointMarker(IMarker marker) {
        if (this.breakpointmarkers != null) {
            Long id = new Long(marker.getId());
            this.breakpointmarkers.remove(id);
        }
    }

    @Override
    public BreakpointMarker addBreakpointMarker(IMarker marker) {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        Long id = new Long(marker.getId());
        BreakpointMarker item = null;
        item = this.getBreakpointMarker(id);
        if (item == null) {
            try {
                item = new BreakpointMarker(marker);
                this.breakpointmarkers.put(id, item);
            }
            catch (ITException iTException) {}
        }
        return item;
    }

    @Override
    public synchronized BreakpointMarker[] getBreakpointmarkers() {
        if (this.breakpointmarkers == null) {
            this.loadbreakpointmarkers();
        }
        ArrayList<BreakpointMarker> list = new ArrayList<BreakpointMarker>(this.breakpointmarkers.size());
        for (Map.Entry<Long, BreakpointMarker> bmarker : this.breakpointmarkers.entrySet()) {
            BreakpointMarker item = bmarker.getValue();
            if (!item.exists()) continue;
            list.add(item);
        }
        return list.toArray(new BreakpointMarker[list.size()]);
    }

    public void closeSettingsFile() {
        if (this.zipfile != null) {
            try {
                this.zipfile.close();
            }
            catch (IOException iOException) {}
        }
        this.zipfile = null;
    }

    public int getLanguage() {
        return this.language;
    }

    @Override
    public boolean isStatementTrace() {
        if (this.session.isBatch()) {
            return this.session.isStatementTrace();
        }
        return this.backtrace;
    }

    @Override
    public boolean isDataMonitor() {
        return this.datamonitor;
    }

    @Override
    public void setStatementTrace(boolean backtrace) {
        if (this.session.isBatch()) {
            this.session.setStatementTrace(backtrace);
            return;
        }
        if (this.backtrace != backtrace) {
            this.backtrace = backtrace;
            this.store.setValue("back_trace", backtrace);
            this.store.save();
            if (this.session.isDebugging() && this.isMonitor()) {
                try {
                    this.session.addStatementTrace(this, backtrace);
                    this.session.post(null);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "back_trace", (Object)this, (Object)this));
        }
    }

    @Override
    public void setDataMonitor(boolean datamonitor) {
        if (this.datamonitor != datamonitor) {
            this.datamonitor = datamonitor;
            this.store.setValue("data_monitor", datamonitor);
            this.store.save();
            if (this.session.isDebugging() && this.isMonitor()) {
                Display display;
                if (datamonitor && !this.session.isDataMonitorOK() && this.session.isBatch() && (display = Display.getDefault()) != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String msg = String.format(Messages.debugFile_26, debugFile.this.filetype.toString());
                            MessageDialog.openWarning((Shell)display.getActiveShell(), (String)(String.valueOf(Messages.debugFile_27) + debugFile.this.getTitle()), (String)msg);
                        }
                    });
                }
                try {
                    this.session.addDataMonitor(this, datamonitor);
                    this.session.post(null);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            this.firePropertyChangeListeners(new PropertyChangeEvent((Object)this, "data_monitor", (Object)this, (Object)this));
        }
    }

    public Outline getOutline() {
        return this.outline;
    }

    public void setOutline(Outline outline) {
        this.outline = outline;
    }

    public boolean isEntered() {
        return this.entered;
    }

    public void setEntered(boolean entered) {
        this.entered = entered;
    }

    public String getPrefix() {
        return String.valueOf(this.getName()) + "_";
    }

    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public BreakpointMarker getBreakpointMarkerbyID(long breakpointID) {
        if (this.breakpointmarkers == null) {
            return null;
        }
        for (BreakpointMarker item : this.breakpointmarkers.values()) {
            if (item.getBreakpointID() != breakpointID) continue;
            return item;
        }
        return null;
    }

    public FileType getFiletype() {
        return this.filetype;
    }

    public boolean isProgram() {
        return this.filetype == FileType.PROGID;
    }

    public boolean isTermID() {
        return this.filetype == FileType.TERMID;
    }

    public boolean isTranID() {
        return this.filetype == FileType.TRANID;
    }

    @Override
    public boolean hasInitialBreakpoint() {
        if (this.session.hasInitialBreakpoint()) {
            return true;
        }
        return this.initialbreakpoint;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals("com.ca.intertest.breakpoint.rbp")) {
            return;
        }
        if (!event.getSource().equals(this)) {
            return;
        }
        Object oldvalue = event.getOldValue();
        Object newvalue = event.getNewValue();
        boolean deleted = newvalue == null;
        IMarker marker = (IMarker)(oldvalue == null ? newvalue : oldvalue);
        if (marker == null || !marker.exists() || deleted) {
            return;
        }
        short commandID = (short)marker.getAttribute("cmd", 0);
        if (commandID != 128) {
            return;
        }
        this.initialbreakpoint = marker.getAttribute("BREAKPOINT_ENABLED", false);
    }

    private class FileStore
    extends ResourceProperty {
        public FileStore(IResource resource) {
            super(resource);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public synchronized void resourceChanged(IResourceChangeEvent event) {
            IMarkerDelta[] deltas;
            IMarkerDelta[] iMarkerDeltaArray = deltas = event.findMarkerDeltas("com.ca.intertest.intertestmarker", true);
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta element = iMarkerDeltaArray[n2];
                if (debugFile.this.file.equals((Object)element.getResource())) {
                    String type = element.getType();
                    IMarker marker = element.getMarker();
                    int kind = element.getKind();
                    BreakpointMarker bpmarker = null;
                    switch (kind) {
                        case 1: {
                            bpmarker = debugFile.this.addBreakpointMarker(marker);
                            if (bpmarker == null) break;
                            debugFile.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugFile.this, type, null, (Object)marker));
                            break;
                        }
                        case 2: {
                            debugFile.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugFile.this, type, (Object)marker, null));
                            debugFile.this.removeBreakpointMarker(marker);
                            break;
                        }
                        case 4: {
                            bpmarker = debugFile.this.getBreakpointMarker(marker.getId());
                            if (bpmarker != null) {
                                bpmarker.setValid(true);
                            }
                            debugFile.this.firePropertyChangeListeners(new PropertyChangeEvent((Object)debugFile.this, type, (Object)marker, (Object)marker));
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

