/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.OptionRecord;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MonitorOptions {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    HashMap<Integer, ArrayList<OptionRecord>> options = new HashMap(19);
    IDebug debugitem;
    debugSession session;
    private static final OptionRecord[] EMPTY = new OptionRecord[0];
    String[] attributeNames = new String[]{"BREAKPOINT_ENABLED", "monitor_option", "monitor_option_parm1", "monitor_option_parm2"};

    private MonitorOptions() {
    }

    public MonitorOptions(IDebug item) {
        this();
        this.debugitem = item;
        this.session = item.getSession();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.debugitem.getResource().findMarkers("com.ca.intertest.monitor", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                boolean enabled = marker.getAttribute("BREAKPOINT_ENABLED", false);
                if (enabled) {
                    Integer key = marker.getAttribute("monitor_option", -1);
                    String parm1 = marker.getAttribute("monitor_option_parm1", "");
                    String parm2 = marker.getAttribute("monitor_option_parm2", null);
                    ArrayList<OptionRecord> list = this.options.get(key);
                    if (list == null) {
                        list = new ArrayList();
                        this.options.put(key, list);
                    }
                    list.add(new OptionRecord(key, parm1, parm2));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    public OptionRecord[] getOption(int option) {
        ArrayList<OptionRecord> list = this.options.get(new Integer(option));
        if (list == null) {
            return EMPTY;
        }
        return list.toArray(new OptionRecord[list.size()]);
    }

    public void putOption(int option, OptionRecord[] values) {
        if (values == null) {
            this.options.remove(new Integer(option));
        } else {
            ArrayList<OptionRecord> list = new ArrayList<OptionRecord>(values.length);
            OptionRecord[] optionRecordArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                OptionRecord item = optionRecordArray[n2];
                if (item != null) {
                    list.add(item);
                }
                ++n2;
            }
            this.options.put(new Integer(option), list);
        }
    }

    public void putOption(int option, Collection<OptionRecord> values) {
        if (values == null || values.size() == 0) {
            this.options.remove(new Integer(option));
        } else {
            ArrayList<OptionRecord> list = new ArrayList<OptionRecord>(values);
            this.options.put(new Integer(option), list);
        }
    }

    public void save() {
        IWorkspaceRunnable disable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    IMarker[] markers;
                    IMarker[] iMarkerArray = markers = MonitorOptions.this.debugitem.getResource().findMarkers("com.ca.intertest.monitor", true, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                            marker.setAttribute("BREAKPOINT_ENABLED", false);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Logger.loggit(e);
                }
            }
        };
        IWorkspaceRunnable enable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                for (ArrayList<OptionRecord> entry : MonitorOptions.this.options.values()) {
                    for (OptionRecord value : entry) {
                        String parm1;
                        if (value == null || (parm1 = value.getParameter1()) == null || parm1.length() == 0) continue;
                        String parm2 = value.getParameter2();
                        if (parm2 == null) {
                            parm2 = "";
                        }
                        try {
                            IMarker marker = MonitorOptions.this.debugitem.getResource().createMarker("com.ca.intertest.monitor");
                            marker.setAttributes(MonitorOptions.this.attributeNames, new Object[]{Boolean.TRUE, new Integer(value.getOption()), parm1, parm2});
                        }
                        catch (CoreException e) {
                            Logger.loggit(e);
                        }
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(disable, (ISchedulingRule)this.session.getResource(), 1, null);
            ResourcesPlugin.getWorkspace().run(enable, (ISchedulingRule)this.session.getResource(), 1, null);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }
}

