/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.MemoryUpdate;
import com.ca.intertest.common.verifyHexFixed;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.wizards.CoreDumpRow;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class HexCellsEditingSupport
extends BasicEditingSupport {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected final int cellIX;
    protected final debugSession session;

    public HexCellsEditingSupport(ColumnViewer viewer, debugSession sess, debugFile debugfile, int columnIndex) {
        super(viewer, sess, debugfile, columnIndex);
        this.session = sess;
        this.cellIX = columnIndex - 2;
    }

    @Override
    protected boolean canEdit(Object element) {
        if (this.isBackTraceStop()) {
            return false;
        }
        if (this.session.isAtBreakpoint() && element instanceof CoreDumpRow) {
            return ((CoreDumpRow)element).canEditDisplay(this.cellIX);
        }
        return false;
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        TextCellEditor celleditor = new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        celleditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return null;
            }
        });
        Text text = (Text)celleditor.getControl();
        text.setMenu(this.getViewer().getControl().getMenu());
        text.addVerifyListener((VerifyListener)new verifyHexFixed());
        text.setTextLimit(this.getValue(element).toString().length());
        this.setEditorFont((CellEditor)celleditor);
        return celleditor;
    }

    @Override
    protected Object getValue(Object element) {
        return HexUtil.toHex((byte[])((CoreDumpRow)element).getCellData(this.cellIX), (int)4);
    }

    @Override
    protected void setValue(Object element, Object value) {
        if (value == null || value.equals(this.getValue(element))) {
            return;
        }
        CoreDumpRow row = (CoreDumpRow)element;
        byte[] oldvalue = row.getCellData(this.cellIX);
        byte[] newvalue = HexUtil.HextoBytes((String)value.toString());
        MemoryUpdate memory = new MemoryUpdate(this.session);
        String sOldvalue = HexUtil.toHex((byte[])oldvalue, (int)0);
        String sNewvalue = HexUtil.toHex((byte[])newvalue, (int)0);
        if (!sNewvalue.equals(sOldvalue)) {
            memory.sendMemoryUpdateMessage(sNewvalue, sOldvalue, row.getCellAddress(this.cellIX));
        }
    }
}

