/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.wizards.CoreStructurePage;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class CoreStructureContentProvider
implements ITreeContentProvider,
IPropertyChangeListener {
    protected static final int LEVEL1_VARIABLES = 1;
    protected static final int ALL_VARIABLES = 2;
    protected static final int GROUP_VARIABLES = 3;
    protected static final Debug debug = Debug.getInstance();
    protected final IDebug debugitem;
    protected final debugSession session;
    protected final ArrayList<TreeObject> keepObjects = new ArrayList();
    protected final CoreStructurePage viewpage;
    protected final TreeViewer viewer;
    protected final int lang;
    protected final String UniqueKey = Integer.toString(this.hashCode());

    public CoreStructureContentProvider(IResource resource, CoreStructurePage viewpage) {
        this.debugitem = debug.getResource(resource);
        this.session = debug.getSession((IResource)resource.getProject());
        this.viewpage = viewpage;
        this.viewer = viewpage.getTreeViewer();
        this.lang = (Integer)Attribute.getValue("gt_m_lang", this.debugitem.getStore());
        this.debugitem.addPropertyChangeListener(this);
    }

    public Object[] getElements(Object inputElement) {
        Object[] objs = new Variable[1];
        TreeObject treeobject = this.viewpage.getStructureTreeObject();
        if (treeobject == null) {
            return new Object[0];
        }
        this.loadChildren(treeobject, 0, treeobject.getBackingdataAddress());
        objs[0] = (Variable)treeobject;
        return objs;
    }

    protected void loadChildren(TreeObject to, int backingdataOffset, MFAddress backingdataAddr) {
        to.setBackingdataAddress(backingdataAddr);
        to.setBackingdataOffset(backingdataOffset);
        String keyword = to.getKeyword();
        TreeObject[] treeObjectArray = to.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject element = treeObjectArray[n2];
            element.setBackingdata(to.getBackingdata());
            element.setKeyword(keyword);
            if (element.getAddress().equals((Object)MFAddress.ZERO_ADDR)) {
                int elementOffset = (Integer)Attribute.getValue("structureoffset", element);
                element.setAddress(backingdataAddr.add((long)(elementOffset - backingdataOffset)));
            }
            this.loadChildren(element, backingdataOffset, backingdataAddr);
            ++n2;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)parentElement;
            return treeobject.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TreeObject) {
            TreeObject treeobject = (TreeObject)element;
            if (treeobject.getAttribute(this.UniqueKey) != null) {
                return null;
            }
            return treeobject.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeObject) {
            return ((TreeObject)element).hasChildren();
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
        this.debugitem.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Display display;
        String property = event.getProperty();
        if (property.equals("MEMORY_UPDATE") && (display = this.viewpage.getShell().getDisplay()) != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    CoreStructureContentProvider.this.viewpage.getTreeViewer().refresh();
                    CoreStructureContentProvider.this.viewpage.getTreeViewer().expandAll();
                }
            });
        }
    }
}

