/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.MonitorOptions;
import com.ca.intertest.common.OptionRecord;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugMarker;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.dialogs.CICSConfigDialog;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.wizards.CICSConfigWizard;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CICSConfigPage
extends WizardPage
implements Listener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final boolean mon_system = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/option/sysmonitor"));
    private static final boolean statementtrace = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/option/statementtrace"));
    protected short submessageID = 0;
    protected String subText = "";
    protected String parameter1 = "";
    protected String parameter2 = "";
    protected boolean enable = true;
    private static final String EMPTY = "";
    private Group mainGroup;
    private Button monitor = null;
    private Button count = null;
    private Button trace;
    private Button datamonitor;
    private Group protectGroup;
    private Table tableProtect;
    private TableColumn columnProtect;
    private TableViewer tab_viewerProtect;
    private Button addProtect;
    private Button delProtect;
    private Group replaceGroup;
    private Table tableReplace;
    private TableColumn columnReplace;
    private TableViewer tab_viewerReplace;
    private Button addReplace;
    private Button delReplace;
    private Group specialGroup;
    private Button nupCheckbox;
    private Button rntCheckbox;
    private Button ushCheckbox;
    private Text ictText;
    private Text folText;
    private Text musText;
    private Text mxsText;
    private Text mxrText;
    private Text tonText;
    private boolean isAllParagraphs;
    private IMarker marker;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.cicsConfigPage";
    private Group systemGroup;
    protected CICSConfigWizard wizard;
    protected Group rbpGroup;
    protected debugMarkerGroup markerGroup;
    protected ContainerCheckedTreeViewer viewer;
    protected FocusListener focuslistener;
    protected SelectionListener selectionlistener;
    protected ModifyListener modifylistener;
    private boolean changed = false;
    protected static boolean repalcereq;
    protected MonitorRecord rec = null;
    protected MonitorRecord[] records = null;
    protected ArrayList<MonitorRecord> prot_rec = null;
    protected ArrayList<MonitorRecord> repl_rec = null;
    public static final int MON_TYPE = 0;
    public static final int MON_PARM1 = 1;
    public static final int MON_PARM2 = 2;
    static final String[] labels;
    static final int[] styles;
    static final int[] Column_width;
    private debugFile item;
    private MonitorOptions settings;
    private OptionRecord[] results;
    private Button allParagraphs;

    static {
        labels = new String[]{Messages.CICSConfigPage_4, Messages.CICSConfigPage_5, Messages.CICSConfigPage_6};
        styles = new int[]{16384, 16384, 16384};
        Column_width = new int[]{150, 80, 80};
    }

    public CICSConfigPage(String pageName) {
        super(pageName);
    }

    public CICSConfigPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.wizard = (CICSConfigWizard)this.getWizard();
        this.item = this.wizard.getDebugfile();
        this.settings = new MonitorOptions(this.item);
        this.isAllParagraphs = this.isAllParagraphBP();
        this.selectionlistener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    CICSConfigPage.this.changed = true;
                    CICSConfigPage.this.wizard.getContainer().updateButtons();
                }
            }
        };
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        CTabFolder folder = new CTabFolder(composite, 2180);
        folder.setLayoutData((Object)new GridData(4, 4, true, false));
        folder.setSimple(false);
        folder.setToolTipText(Messages.CICSConfigPage_7);
        folder.setSingle(false);
        folder.setUnselectedImageVisible(true);
        folder.setUnselectedCloseVisible(false);
        folder.setMinimizeVisible(false);
        folder.setMaximizeVisible(false);
        CTabItem maintab = new CTabItem(folder, 0);
        maintab.setToolTipText(Messages.CICSConfigPage_8);
        maintab.setText(Messages.CICSConfigPage_9);
        Composite pagecomposite = new Composite((Composite)folder, 0);
        gridLayout = new GridLayout(1, true);
        pagecomposite.setLayout((Layout)gridLayout);
        maintab.setControl((Control)pagecomposite);
        this.createMainGroup(pagecomposite);
        CTabItem protecttab = new CTabItem(folder, 0);
        protecttab.setToolTipText(Messages.CICSConfigPage_10);
        protecttab.setText(Messages.CICSConfigPage_11);
        pagecomposite = new Composite((Composite)folder, 0);
        gridLayout = new GridLayout(2, false);
        pagecomposite.setLayout((Layout)gridLayout);
        protecttab.setControl((Control)pagecomposite);
        this.createProtectGroup(pagecomposite);
        CTabItem replacetab = new CTabItem(folder, 0);
        replacetab.setToolTipText(Messages.CICSConfigPage_12);
        replacetab.setText(Messages.CICSConfigPage_13);
        pagecomposite = new Composite((Composite)folder, 0);
        gridLayout = new GridLayout(2, false);
        pagecomposite.setLayout((Layout)gridLayout);
        replacetab.setControl((Control)pagecomposite);
        this.createReplaceGroup(pagecomposite);
        CTabItem specialtab = new CTabItem(folder, 0);
        specialtab.setToolTipText(Messages.CICSConfigPage_14);
        specialtab.setText(Messages.CICSConfigPage_15);
        pagecomposite = new Composite((Composite)folder, 0);
        gridLayout = new GridLayout(1, true);
        pagecomposite.setLayout((Layout)gridLayout);
        specialtab.setControl((Control)pagecomposite);
        this.createSpecialGroup(pagecomposite);
        if (mon_system) {
            CTabItem systemtab = new CTabItem(folder, 0);
            systemtab.setToolTipText(Messages.CICSConfigPage_16);
            systemtab.setText(Messages.CICSConfigPage_17);
            pagecomposite = new Composite((Composite)folder, 0);
            gridLayout = new GridLayout(1, true);
            pagecomposite.setLayout((Layout)gridLayout);
            systemtab.setControl((Control)pagecomposite);
            this.createSystemGroup(pagecomposite);
        }
        folder.setSelection(0);
        this.setControl((Control)parent);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.cicsConfigPage");
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null, 2);
        return this.changed;
    }

    public boolean doFinish() {
        MonitorRecord rec1 = null;
        OptionRecord opt_rec = null;
        OptionRecord[] opt_rec1 = null;
        ArrayList<OptionRecord> opt_01 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_02 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_03 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_04 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_05 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_06 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_07 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_08 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_09 = new ArrayList<OptionRecord>();
        ArrayList<OptionRecord> opt_10 = new ArrayList<OptionRecord>();
        this.markerGroup.cleanEnable();
        this.markerGroup.checkChanged();
        this.markerGroup.save();
        this.item.setMonitor(this.monitor.getSelection());
        this.item.setExecutionCount(this.count.getSelection());
        this.item.setStatementTrace(this.trace.getSelection());
        if (this.datamonitor != null) {
            this.item.setDataMonitor(this.datamonitor.getSelection());
        }
        int count = this.prot_rec.size();
        int i = 0;
        while (i < count) {
            rec1 = this.prot_rec.get(i);
            opt_rec = new OptionRecord(rec1.submessageID, rec1.parm1, rec1.parm2);
            if (rec1.submessageID == 1) {
                opt_01.add(opt_rec);
            }
            if (rec1.submessageID == 2) {
                opt_02.add(opt_rec);
            }
            if (rec1.submessageID == 3) {
                opt_03.add(opt_rec);
            }
            if (rec1.submessageID == 4) {
                opt_04.add(opt_rec);
            }
            if (rec1.submessageID == 5) {
                opt_05.add(opt_rec);
            }
            if (rec1.submessageID == 6) {
                opt_06.add(opt_rec);
            }
            ++i;
        }
        this.settings.putOption(1, opt_01);
        this.settings.putOption(2, opt_02);
        this.settings.putOption(3, opt_03);
        this.settings.putOption(4, opt_04);
        this.settings.putOption(5, opt_05);
        this.settings.putOption(6, opt_06);
        count = this.repl_rec.size();
        i = 0;
        while (i < count) {
            rec1 = this.repl_rec.get(i);
            opt_rec = new OptionRecord(rec1.submessageID, rec1.parm1, rec1.parm2);
            if (rec1.submessageID == 8) {
                opt_07.add(opt_rec);
            }
            if (rec1.submessageID == 9) {
                opt_08.add(opt_rec);
            }
            if (rec1.submessageID == 10) {
                opt_09.add(opt_rec);
            }
            if (rec1.submessageID == 11) {
                opt_10.add(opt_rec);
            }
            ++i;
        }
        this.settings.putOption(8, opt_07);
        this.settings.putOption(9, opt_08);
        this.settings.putOption(10, opt_09);
        this.settings.putOption(11, opt_10);
        opt_rec1 = new OptionRecord[]{null};
        if (this.nupCheckbox.getSelection()) {
            opt_rec1[0] = new OptionRecord(12, "ON", null);
        }
        this.settings.putOption(12, opt_rec1);
        opt_rec1[0] = null;
        if (this.rntCheckbox.getSelection()) {
            opt_rec1[0] = new OptionRecord(13, "ON", null);
        }
        this.settings.putOption(13, opt_rec1);
        opt_rec1[0] = null;
        if (this.ushCheckbox.getSelection()) {
            opt_rec1[0] = new OptionRecord(18, "ON", null);
        }
        this.settings.putOption(18, opt_rec1);
        opt_rec1[0] = null;
        String parm = this.ictText.getText();
        if (parm.length() > 0) {
            opt_rec1[0] = new OptionRecord(19, parm, null);
        }
        this.settings.putOption(19, opt_rec1);
        opt_rec1[0] = null;
        parm = this.folText.getText();
        if (parm.length() > 0) {
            opt_rec1[0] = new OptionRecord(14, parm, null);
        }
        this.settings.putOption(14, opt_rec1);
        opt_rec1[0] = null;
        parm = this.musText.getText();
        if (this.valuedParm(parm)) {
            opt_rec1[0] = new OptionRecord(15, parm, null);
        }
        this.settings.putOption(15, opt_rec1);
        opt_rec1[0] = null;
        parm = this.mxsText.getText();
        if (this.valuedParm(parm)) {
            opt_rec1[0] = new OptionRecord(16, parm, null);
        }
        this.settings.putOption(16, opt_rec1);
        opt_rec1[0] = null;
        parm = this.mxrText.getText();
        if (this.valuedParm(parm)) {
            opt_rec1[0] = new OptionRecord(17, parm, null);
        }
        this.settings.putOption(17, opt_rec1);
        opt_rec1[0] = null;
        parm = this.tonText.getText();
        if (this.valuedParm(parm)) {
            opt_rec1[0] = new OptionRecord(7, parm, null);
        }
        this.settings.putOption(7, opt_rec1);
        this.settings.save();
        if (this.allParagraphs != null && this.isAllParagraphs != this.allParagraphs.getSelection()) {
            try {
                final HashMap<String, Object> attributes = this.marker != null ? this.marker.getAttributes() : new HashMap<String, Object>();
                attributes.put("programid", this.item.getName());
                attributes.put("CICS", this.item.getSession().isCICS());
                attributes.put("all_sections", true);
                attributes.put("sub_type", 1);
                attributes.put("message", this.allParagraphs.getText());
                attributes.put("BREAKPOINT_ENABLED", this.allParagraphs.getSelection());
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (CICSConfigPage.this.marker == null) {
                            CICSConfigPage.this.marker = CICSConfigPage.this.item.getResource().createMarker("com.ca.intertest.breakpoint.unconditional");
                        }
                        CICSConfigPage.this.marker.setAttributes(attributes);
                    }
                };
                this.item.getResource().getWorkspace().run(r, null, 1, null);
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    private boolean valuedParm(String parm) {
        if (parm.length() > 0) {
            try {
                int number = Integer.parseInt(parm);
                return number != 0;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return false;
    }

    protected void createMainGroup(Composite pagecomposite) {
        this.mainGroup = new Group(pagecomposite, 0);
        this.mainGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mainGroup.setLayout((Layout)new GridLayout(1, false));
        this.mainGroup.setText(Messages.CICSConfigPage_22);
        this.monitor = new Button((Composite)this.mainGroup, 32);
        this.monitor.setSelection(this.item.isMonitor());
        this.monitor.setText(Messages.CICSConfigPage_23);
        this.monitor.addSelectionListener(this.selectionlistener);
        this.count = new Button((Composite)this.mainGroup, 32);
        this.count.setText(Messages.CICSConfigPage_24);
        this.count.setSelection(this.item.isExecutionCount());
        this.count.addSelectionListener(this.selectionlistener);
        if (this.item.isProgram()) {
            String word;
            String format = Messages.CICSConfigPage_25;
            String rbpTooltip = Messages.CICSConfigPage_26;
            this.allParagraphs = new Button((Composite)this.mainGroup, 32);
            switch (this.item.getLanguage()) {
                case 16: {
                    word = Messages.CICSConfigPage_27;
                    break;
                }
                case 128: {
                    word = Messages.CICSConfigPage_28;
                    break;
                }
                default: {
                    word = Messages.CICSConfigPage_29;
                }
            }
            this.allParagraphs.setText(String.format(format, word));
            this.allParagraphs.setToolTipText(String.format(rbpTooltip, word));
            this.allParagraphs.setSelection(this.isAllParagraphs);
            this.allParagraphs.addSelectionListener(this.selectionlistener);
        } else {
            this.allParagraphs = null;
        }
        this.trace = new Button((Composite)this.mainGroup, 32);
        this.trace.setText(Messages.CICSConfigPage_30);
        this.trace.setSelection(this.item.isStatementTrace());
        this.trace.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (CICSConfigPage.this.datamonitor != null) {
                    CICSConfigPage.this.datamonitor.setEnabled(CICSConfigPage.this.trace.getSelection());
                }
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        if (!statementtrace) {
            this.trace.setEnabled(!this.item.isSubModule());
        }
        if (this.item.getLanguage() == 32) {
            this.datamonitor = new Button((Composite)this.mainGroup, 32);
            this.datamonitor.setText(Messages.CICSConfigPage_31);
            GC gc = new GC((Drawable)this.trace);
            Point size = this.trace.computeSize(-1, -1);
            this.trace.setSize(size);
            Point textsize = gc.textExtent(this.trace.getText());
            GridData data = new GridData(256, 0, true, false);
            data.horizontalIndent = (int)((double)(size.x - textsize.x) * 0.9);
            this.datamonitor.setLayoutData((Object)data);
            this.datamonitor.setSelection(this.item.isDataMonitor());
            this.datamonitor.setEnabled(this.trace.getSelection() && this.trace.isEnabled());
            this.datamonitor.addSelectionListener(this.selectionlistener);
        } else {
            this.datamonitor = null;
        }
        this.createBreakpointsView((Composite)this.mainGroup);
    }

    protected void createReplaceGroup(Composite pagecomposite) {
        String[] ReplaceType = new String[]{Messages.CICSConfigPage_32, Messages.CICSConfigPage_33, Messages.CICSConfigPage_34, Messages.CICSConfigPage_35, Messages.CICSConfigPage_36};
        this.replaceGroup = new Group(pagecomposite, 0);
        this.replaceGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.replaceGroup.setLayout((Layout)new GridLayout(1, false));
        this.replaceGroup.setText(Messages.CICSConfigPage_37);
        this.tableReplace = new Table((Composite)this.replaceGroup, 66308);
        this.tableReplace.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < labels.length) {
            this.columnReplace = new TableColumn(this.tableReplace, styles[i]);
            this.columnReplace.setText(labels[i]);
            this.columnReplace.setMoveable(true);
            this.columnReplace.setResizable(true);
            this.columnReplace.setData((Object)new Integer(i));
            this.columnReplace.setWidth(Column_width[i]);
            ++i;
        }
        this.tableReplace.setHeaderVisible(true);
        this.tableReplace.setLinesVisible(true);
        this.tab_viewerReplace = new TableViewer(this.tableReplace);
        this.tab_viewerReplace.setContentProvider((IContentProvider)new MonitorContentProvider());
        this.tab_viewerReplace.setLabelProvider((IBaseLabelProvider)new MonitorLabelProvider());
        this.tab_viewerReplace.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CICSConfigPage.this.delReplace.setEnabled(true);
                ISelection sel = CICSConfigPage.this.tab_viewerReplace.getSelection();
                CICSConfigPage.this.tab_viewerReplace.setSelection(sel, true);
            }
        });
        this.tab_viewerReplace.setInput(this.repl_rec);
        this.tab_viewerReplace.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    CICSConfigPage.this.delReplace.setEnabled(false);
                } else {
                    CICSConfigPage.this.delReplace.setEnabled(true);
                }
            }
        });
        this.addReplace = new Button(pagecomposite, 0);
        this.addReplace.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.addReplace.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                repalcereq = true;
                Shell shell = CICSConfigPage.this.getShell();
                CICSConfigDialog dialog = new CICSConfigDialog(shell, CICSConfigPage.this.item);
                dialog.init(true);
                dialog.create();
                if (dialog.open() == 0) {
                    CICSConfigPage.this.changed = true;
                    CICSConfigPage.this.wizard.getContainer().updateButtons();
                    CICSConfigPage.this.rec = new MonitorRecord();
                    CICSConfigPage.this.rec.submessageID = (short)(dialog.getIDX() + 8);
                    if (CICSConfigPage.this.rec.submessageID == 12) {
                        CICSConfigPage.this.rec.submessageID = (short)11;
                    }
                    CICSConfigPage.this.rec.type = dialog.getIDText();
                    CICSConfigPage.this.rec.parm1 = dialog.getPrm1Txt();
                    CICSConfigPage.this.rec.parm2 = dialog.getPrm2Txt();
                    CICSConfigPage.this.repl_rec.add(CICSConfigPage.this.repl_rec.size(), CICSConfigPage.this.rec);
                    CICSConfigPage.this.tab_viewerReplace.insert((Object)CICSConfigPage.this.rec, -1);
                }
            }
        });
        this.addReplace.setText(Messages.CICSConfigPage_38);
        this.delReplace = new Button(pagecomposite, 0);
        this.delReplace.setEnabled(false);
        this.delReplace.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.delReplace.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MonitorRecord rec = (MonitorRecord)((IStructuredSelection)CICSConfigPage.this.tab_viewerReplace.getSelection()).getFirstElement();
                if (rec != null) {
                    CICSConfigPage.this.repl_rec.remove(rec);
                }
                CICSConfigPage.this.delReplace.setEnabled(false);
                CICSConfigPage.this.tab_viewerReplace.refresh();
                CICSConfigPage.this.records = new MonitorRecord[CICSConfigPage.this.repl_rec.size()];
                CICSConfigPage.this.repl_rec.toArray(CICSConfigPage.this.records);
                CICSConfigPage.this.tab_viewerReplace.add((Object[])CICSConfigPage.this.records);
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        this.delReplace.setText(Messages.CICSConfigPage_39);
        this.repl_rec = new ArrayList();
        int idx = 8;
        while (idx < 12) {
            this.results = this.settings.getOption(idx);
            int i2 = 0;
            while (i2 < this.results.length) {
                this.rec = new MonitorRecord();
                this.rec.submessageID = (short)idx;
                this.rec.parm1 = this.results[i2].getParameter1();
                this.rec.parm2 = this.results[i2].getParameter2();
                this.rec.type = ReplaceType[idx - 8];
                if (this.rec.submessageID == 11 && this.rec.parm1.charAt(0) == 'X') {
                    this.rec.type = ReplaceType[idx - 7];
                }
                this.repl_rec.add(this.repl_rec.size(), this.rec);
                ++i2;
            }
            ++idx;
        }
        this.records = new MonitorRecord[this.repl_rec.size()];
        this.repl_rec.toArray(this.records);
        this.tab_viewerReplace.add((Object[])this.records);
    }

    protected void createProtectGroup(Composite pagecomposite) {
        String[] ProtectType = new String[]{Messages.CICSConfigPage_40, Messages.CICSConfigPage_41, Messages.CICSConfigPage_42, Messages.CICSConfigPage_43, Messages.CICSConfigPage_44, Messages.CICSConfigPage_45};
        this.protectGroup = new Group(pagecomposite, 0);
        this.protectGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.protectGroup.setLayout((Layout)new GridLayout(1, false));
        this.protectGroup.setText(Messages.CICSConfigPage_46);
        this.tableProtect = new Table((Composite)this.protectGroup, 66308);
        this.tableProtect.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < labels.length) {
            this.columnProtect = new TableColumn(this.tableProtect, styles[i]);
            this.columnProtect.setText(labels[i]);
            this.columnProtect.setMoveable(true);
            this.columnProtect.setResizable(true);
            this.columnProtect.setData((Object)new Integer(i));
            this.columnProtect.setWidth(Column_width[i]);
            ++i;
        }
        this.tableProtect.setHeaderVisible(true);
        this.tableProtect.setLinesVisible(true);
        this.tab_viewerProtect = new TableViewer(this.tableProtect);
        this.tab_viewerProtect.setContentProvider((IContentProvider)new MonitorContentProvider());
        this.tab_viewerProtect.setLabelProvider((IBaseLabelProvider)new MonitorLabelProvider());
        this.tab_viewerProtect.setInput(this.prot_rec);
        this.tab_viewerProtect.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    CICSConfigPage.this.delProtect.setEnabled(false);
                } else {
                    CICSConfigPage.this.delProtect.setEnabled(true);
                }
            }
        });
        this.addProtect = new Button(pagecomposite, 0);
        this.addProtect.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.addProtect.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                repalcereq = false;
                Shell shell = CICSConfigPage.this.getShell();
                CICSConfigDialog dialog = new CICSConfigDialog(shell, CICSConfigPage.this.item);
                dialog.create();
                dialog.init(false);
                dialog.create();
                if (dialog.open() == 0) {
                    CICSConfigPage.this.rec = new MonitorRecord();
                    CICSConfigPage.this.rec.submessageID = (short)(dialog.getIDX() + 1);
                    CICSConfigPage.this.rec.type = dialog.getIDText();
                    CICSConfigPage.this.rec.parm1 = dialog.getPrm1Txt();
                    CICSConfigPage.this.rec.parm2 = dialog.getPrm2Txt();
                    CICSConfigPage.this.prot_rec.add(CICSConfigPage.this.repl_rec.size(), CICSConfigPage.this.rec);
                    CICSConfigPage.this.tab_viewerProtect.insert((Object)CICSConfigPage.this.rec, -1);
                    CICSConfigPage.this.changed = true;
                    CICSConfigPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
        this.addProtect.setText(Messages.CICSConfigPage_47);
        this.delProtect = new Button(pagecomposite, 0);
        this.delProtect.setEnabled(false);
        this.delProtect.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.delProtect.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MonitorRecord rec = (MonitorRecord)((IStructuredSelection)CICSConfigPage.this.tab_viewerProtect.getSelection()).getFirstElement();
                if (rec != null) {
                    CICSConfigPage.this.prot_rec.remove(rec);
                }
                CICSConfigPage.this.delProtect.setEnabled(false);
                CICSConfigPage.this.tab_viewerProtect.refresh();
                CICSConfigPage.this.records = new MonitorRecord[CICSConfigPage.this.prot_rec.size()];
                CICSConfigPage.this.prot_rec.toArray(CICSConfigPage.this.records);
                CICSConfigPage.this.tab_viewerProtect.add((Object[])CICSConfigPage.this.records);
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        this.delProtect.setText(Messages.CICSConfigPage_48);
        this.prot_rec = new ArrayList();
        int idx = 1;
        while (idx < 7) {
            this.results = this.settings.getOption(idx);
            int i2 = 0;
            while (i2 < this.results.length) {
                this.rec = new MonitorRecord();
                this.rec.submessageID = (short)idx;
                this.rec.type = ProtectType[idx - 1];
                this.rec.parm1 = this.results[i2].getParameter1();
                this.rec.parm2 = this.results[i2].getParameter2();
                this.prot_rec.add(this.prot_rec.size(), this.rec);
                ++i2;
            }
            ++idx;
        }
        this.records = new MonitorRecord[this.prot_rec.size()];
        this.prot_rec.toArray(this.records);
        this.tab_viewerProtect.add((Object[])this.records);
    }

    protected void createSpecialGroup(Composite pagecomposite) {
        this.specialGroup = new Group(pagecomposite, 0);
        this.specialGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.specialGroup.setLayout((Layout)new GridLayout(2, false));
        this.specialGroup.setText(Messages.CICSConfigPage_49);
        this.nupCheckbox = new Button((Composite)this.specialGroup, 32);
        this.nupCheckbox.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.nupCheckbox.setText(Messages.CICSConfigPage_50);
        this.results = this.settings.getOption(12);
        if (this.results.length > 0) {
            this.nupCheckbox.setSelection(true);
        }
        this.nupCheckbox.addSelectionListener(this.selectionlistener);
        this.rntCheckbox = new Button((Composite)this.specialGroup, 32);
        this.rntCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.rntCheckbox.setText(Messages.CICSConfigPage_51);
        this.results = this.settings.getOption(13);
        if (this.results.length > 0) {
            this.rntCheckbox.setSelection(true);
        }
        this.rntCheckbox.addSelectionListener(this.selectionlistener);
        this.ushCheckbox = new Button((Composite)this.specialGroup, 32);
        this.ushCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.ushCheckbox.setText(Messages.CICSConfigPage_52);
        this.results = this.settings.getOption(18);
        if (this.results.length > 0) {
            this.ushCheckbox.setSelection(true);
        }
        this.ushCheckbox.addSelectionListener(this.selectionlistener);
        Label ictlabel = new Label((Composite)this.specialGroup, 0);
        ictlabel.setLayoutData((Object)new GridData(4, 0, false, false));
        ictlabel.setText(Messages.CICSConfigPage_53);
        this.ictText = new Text((Composite)this.specialGroup, 2048);
        this.ictText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(19);
        if (this.results.length > 0) {
            this.ictText.setText(this.results[0].getParameter1());
        }
        this.ictText.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.ictText.setTextLimit(5);
        this.ictText.setText(HexUtil.spaceFill((String)this.ictText.getText(), (int)8).trim());
        this.ictText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        Label follabel = new Label((Composite)this.specialGroup, 0);
        follabel.setLayoutData((Object)new GridData(4, 0, false, false));
        follabel.setText(Messages.CICSConfigPage_54);
        this.folText = new Text((Composite)this.specialGroup, 2048);
        this.folText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(14);
        if (this.results.length > 0) {
            this.folText.setText(this.results[0].getParameter1());
        }
        this.folText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.folText.addSelectionListener(this.selectionlistener);
        this.folText.setTextLimit(8);
        this.folText.setText(HexUtil.spaceFill((String)this.folText.getText(), (int)8).trim());
        this.folText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        Label muslabel = new Label((Composite)this.specialGroup, 0);
        muslabel.setLayoutData((Object)new GridData(4, 0, false, false));
        muslabel.setText(Messages.CICSConfigPage_55);
        this.musText = new Text((Composite)this.specialGroup, 2048);
        this.musText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(15);
        if (this.results.length > 0) {
            this.musText.setText(this.results[0].getParameter1());
        }
        this.musText.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.musText.addSelectionListener(this.selectionlistener);
        this.musText.setTextLimit(5);
        this.musText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        Label mxslabel = new Label((Composite)this.specialGroup, 0);
        mxslabel.setLayoutData((Object)new GridData(4, 0, false, false));
        mxslabel.setText(Messages.CICSConfigPage_56);
        this.mxsText = new Text((Composite)this.specialGroup, 2048);
        this.mxsText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(16);
        if (this.results.length > 0) {
            this.mxsText.setText(this.results[0].getParameter1());
        }
        this.mxsText.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.mxsText.addSelectionListener(this.selectionlistener);
        this.mxsText.setTextLimit(7);
        this.mxsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        Label mxrlabel = new Label((Composite)this.specialGroup, 0);
        mxrlabel.setLayoutData((Object)new GridData(4, 0, false, false));
        mxrlabel.setText(Messages.CICSConfigPage_57);
        this.mxrText = new Text((Composite)this.specialGroup, 2048);
        this.mxrText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(17);
        if (this.results.length > 0) {
            this.mxrText.setText(this.results[0].getParameter1());
        }
        this.mxrText.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.mxrText.addSelectionListener(this.selectionlistener);
        this.mxrText.setTextLimit(7);
        this.mxrText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        Label tonlabel = new Label((Composite)this.specialGroup, 0);
        tonlabel.setLayoutData((Object)new GridData(4, 0, false, false));
        tonlabel.setText(Messages.CICSConfigPage_58);
        this.tonText = new Text((Composite)this.specialGroup, 2048);
        this.tonText.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.results = this.settings.getOption(7);
        if (this.results.length > 0) {
            this.tonText.setText(this.results[0].getParameter1());
        }
        this.tonText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.tonText.addSelectionListener(this.selectionlistener);
        this.tonText.setTextLimit(4);
        this.tonText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
    }

    protected void createSystemGroup(Composite pagecomposite) {
        this.systemGroup = new Group(pagecomposite, 0);
        this.systemGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.systemGroup.setLayout((Layout)new GridLayout(3, false));
        this.systemGroup.setText(Messages.CICSConfigPage_59);
        Label txtlabel = new Label((Composite)this.systemGroup, 0);
        txtlabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        txtlabel.setText(Messages.CICSConfigPage_60);
        Label txton_off = new Label((Composite)this.systemGroup, 0);
        txton_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        txton_off.setText(Messages.CICSConfigPage_61);
        Label txtterm = new Label((Composite)this.systemGroup, 0);
        txtterm.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        txtterm.setText(Messages.CICSConfigPage_62);
        Label abplabel = new Label((Composite)this.systemGroup, 0);
        abplabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        abplabel.setText(Messages.CICSConfigPage_63);
        Label abpon_off = new Label((Composite)this.systemGroup, 0);
        abpon_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        abpon_off.setText("___");
        Label abpterm = new Label((Composite)this.systemGroup, 0);
        abpterm.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        abpterm.setText(Messages.CICSConfigPage_65);
        Label gloglabel = new Label((Composite)this.systemGroup, 0);
        gloglabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        gloglabel.setText(Messages.CICSConfigPage_66);
        Label glogon_off = new Label((Composite)this.systemGroup, 0);
        glogon_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        glogon_off.setText("___");
        Label glogtdque = new Label((Composite)this.systemGroup, 0);
        glogtdque.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        glogtdque.setText(Messages.CICSConfigPage_68);
        Label catlabel = new Label((Composite)this.systemGroup, 0);
        catlabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        catlabel.setText(Messages.CICSConfigPage_69);
        Label caton_off = new Label((Composite)this.systemGroup, 0);
        caton_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        caton_off.setText("___");
        Label catdummy = new Label((Composite)this.systemGroup, 0);
        catdummy.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        catdummy.setText(" ");
        Label syslabel = new Label((Composite)this.systemGroup, 0);
        syslabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        syslabel.setText(Messages.CICSConfigPage_72);
        Label syson_off = new Label((Composite)this.systemGroup, 0);
        syson_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        syson_off.setText("___");
        Label sysdummy = new Label((Composite)this.systemGroup, 0);
        sysdummy.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        sysdummy.setText(" ");
        Label dmplabel = new Label((Composite)this.systemGroup, 0);
        dmplabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        dmplabel.setText(Messages.CICSConfigPage_75);
        Label dmpon_off = new Label((Composite)this.systemGroup, 0);
        dmpon_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        dmpon_off.setText("___");
        Label dmpdummy = new Label((Composite)this.systemGroup, 0);
        dmpdummy.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        dmpdummy.setText(" ");
        Label ckptlabel = new Label((Composite)this.systemGroup, 0);
        ckptlabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        ckptlabel.setText(Messages.CICSConfigPage_78);
        Label ckpton_off = new Label((Composite)this.systemGroup, 0);
        ckpton_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        ckpton_off.setText("___");
        Label ckpttime = new Label((Composite)this.systemGroup, 0);
        ckpttime.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        ckpttime.setText("HH:MM");
        Label prgelabel = new Label((Composite)this.systemGroup, 0);
        prgelabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        prgelabel.setText(Messages.CICSConfigPage_81);
        Label prgeon_off = new Label((Composite)this.systemGroup, 0);
        prgeon_off.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        prgeon_off.setText("___");
        Label prgetime = new Label((Composite)this.systemGroup, 0);
        prgetime.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        prgetime.setText("HH:MM");
    }

    public void handleEvent(Event event) {
    }

    protected void createBreakpointsView(Composite composite) {
        this.markerGroup = this.item.getMarkergroup();
        this.rbpGroup = new Group(composite, 0);
        this.rbpGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.rbpGroup.setLayout((Layout)new GridLayout(2, false));
        this.rbpGroup.setText(Messages.CICSConfigPage_84);
        this.viewer = new ContainerCheckedTreeViewer((Composite)this.rbpGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true, 2, 5);
        Control control = this.viewer.getControl();
        control.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] children = CICSConfigPage.this.markerGroup.getChildren();
                while (children.length == 1 && children[0] instanceof debugMarkerGroup) {
                    children = ((debugMarkerGroup)children[0]).getChildren();
                }
                return children;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    viewer.refresh();
                    CICSConfigPage.this.setRBPChecked();
                }
            }

            public Object[] getChildren(Object parent) {
                if (parent instanceof debugMarkerGroup) {
                    return ((debugMarkerGroup)parent).getChildren();
                }
                return new Object[0];
            }

            public Object getParent(Object child) {
                if (child instanceof debugFile) {
                    return ((debugFile)child).getParent();
                }
                if (child instanceof IDebugMarker) {
                    return ((IDebugMarker)child).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object parent) {
                if (parent instanceof Debug) {
                    return ((Debug)parent).hasChildren();
                }
                if (parent instanceof debugMarkerGroup) {
                    return ((debugMarkerGroup)parent).hasChildren();
                }
                return false;
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                int cat = 0;
                if (element instanceof IDebugMarker && ((IDebugMarker)element).getType() == 2) {
                    ++cat;
                }
                return cat;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof debugMarker && e2 instanceof debugMarker) {
                    return ((debugMarker)e1).compareTo((debugMarker)e2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IDebugMarker) {
                    ((IDebugMarker)element).setEnabled(event.getChecked());
                }
                CICSConfigPage.this.changed = true;
                CICSConfigPage.this.wizard.getContainer().updateButtons();
            }
        });
        this.viewer.setInput((Object)this.item.getResource());
        this.setRBPChecked();
        this.viewer.expandToLevel(1);
        Button expandAll = new Button((Composite)this.rbpGroup, 0);
        expandAll.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        expandAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CICSConfigPage.this.viewer.expandAll();
            }
        });
        expandAll.setText(Messages.CICSConfigPage_85);
        Button collapseAll = new Button((Composite)this.rbpGroup, 0);
        collapseAll.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        collapseAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CICSConfigPage.this.viewer.collapseAll();
            }
        });
        collapseAll.setText(Messages.CICSConfigPage_86);
    }

    private void setRBPChecked() {
        ArrayList<IDebugMarker> checked = this.markerGroup.getEnabled();
        if (checked.size() > 0) {
            this.viewer.setCheckedElements(checked.toArray());
        } else {
            this.viewer.setAllChecked(false);
        }
    }

    public boolean isPageComplete() {
        return this.validatePage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAllParagraphBP() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.item.getResource().findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                int found;
                IMarker element = iMarkerArray[n2];
                boolean enabled = element.getAttribute("BREAKPOINT_ENABLED", false);
                if (enabled && (found = element.getAttribute("sub_type", 0)) == 1) {
                    this.marker = element;
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        this.marker = null;
        return false;
    }

    private final class MonitorContentProvider
    implements IStructuredContentProvider {
        private MonitorContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (repalcereq) {
                if (CICSConfigPage.this.repl_rec == null) {
                    return new MonitorRecord[0];
                }
                CICSConfigPage.this.records = new MonitorRecord[CICSConfigPage.this.repl_rec.size()];
                CICSConfigPage.this.repl_rec.toArray(CICSConfigPage.this.records);
            } else {
                if (CICSConfigPage.this.prot_rec == null) {
                    return new MonitorRecord[0];
                }
                CICSConfigPage.this.records = new MonitorRecord[CICSConfigPage.this.prot_rec.size()];
                CICSConfigPage.this.prot_rec.toArray(CICSConfigPage.this.records);
            }
            return CICSConfigPage.this.records;
        }

        public void dispose() {
        }
    }

    private class MonitorLabelProvider
    implements ITableLabelProvider {
        private MonitorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MonitorRecord item = (MonitorRecord)element;
            switch (columnIndex) {
                case 0: {
                    return item.type;
                }
                case 1: {
                    return item.parm1;
                }
                case 2: {
                    return item.parm2;
                }
            }
            return Messages.CICSConfigPage_87;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class MonitorRecord {
        public short submessageID;
        public String type;
        public String parm1;
        public String parm2;
    }
}

