/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.debugtree;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.DragDebugFile;
import com.ca.intertest.common.DropDebugFile;
import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.ITreeView;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeType;
import com.ca.intertest.common.decorator;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.CVMO;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.ui.actions.BrowseAction;
import com.ca.intertest.ui.actions.ConfigureBreakpointAction;
import com.ca.intertest.ui.views.debugtree.DebugTreeContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class DebugTreeView
extends ViewPart
implements IShowInTarget,
ITreeView {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final String PROGRAMS = "MONITORED";
    public static final String UNMONITORED = "UNMONITORED";
    public static final String STATUS = Messages.DebugTreeView_0;
    public static final String PROGRAMS_TEXT = Messages.DebugTreeView_monitored;
    public static final String UNMONITORED_TEXT = Messages.DebugTreeView_unmonitored;
    public static final String STATUS_TEXT = Messages.DebugTreeView_1;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.debugview";
    private final Debug debug = Debug.getInstance();
    private BrowseAction doubleClickBrowseAction;
    private ConfigureBreakpointAction doubleClickConfigureAction;
    protected IPropertyChangeListener propertychangelistener;
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        DebugTreeContentProvider provider = new DebugTreeContentProvider(this);
        this.propertychangelistener = new propertyChangeListener(this.viewer, provider);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DebugTreeLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{ResourceTransfer.getInstance()};
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)new DragDebugFile((StructuredViewer)this.viewer));
        this.viewer.addDropSupport(operations, transferTypes, (DropTargetListener)new DropDebugFile((Viewer)this.viewer));
        this.viewer.expandToLevel(1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookDoubleClickAction();
        this.registerContextMenu();
        this.debug.addPropertyChangeListener(this.propertychangelistener);
        ServerList.getInstance().addPropertyChangeListener(this.propertychangelistener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
    }

    public void dispose() {
        for (debugSession item : this.debug.getSessions()) {
            item.removePropertyChangeListener(this.propertychangelistener);
        }
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider != null) {
            provider.dispose();
        }
        this.getSite().setSelectionProvider(null);
        this.debug.removePropertyChangeListener(this.propertychangelistener);
        ServerList.getInstance().removePropertyChangeListener(this.propertychangelistener);
        this.viewer.getControl().dispose();
        super.dispose();
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private void registerContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.add((IContributionItem)new Separator("com.ca.intertest.viewcontribution.debugfile"));
        manager.add((IContributionItem)new Separator("com.ca.intertest.viewcontribution.debugall"));
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickBrowseAction);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickConfigureAction);
    }

    private void makeActions() {
        this.doubleClickBrowseAction = new BrowseAction();
        this.doubleClickBrowseAction.init((IViewPart)this.getSite().getPart());
        this.doubleClickConfigureAction = new ConfigureBreakpointAction();
        this.doubleClickConfigureAction.init((IViewPart)this.getSite().getPart());
    }

    public boolean run(Object source, Object target) {
        return false;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public boolean show(ShowInContext context) {
        DebugTreeContentProvider provider;
        IT_TreeItem found;
        ISelection selection;
        Object object = context.getInput();
        if (!(object instanceof debugFile) && (selection = context.getSelection()) instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            object = this.debug.getResource((IResource)object);
        }
        if ((object instanceof debugFile || object instanceof IFile) && (found = (provider = (DebugTreeContentProvider)this.viewer.getContentProvider()).findObject(object)) != null) {
            IT_TreeItem item = found;
            StructuredSelection sel = new StructuredSelection((Object)item);
            if (Display.getCurrent() == null) {
                this.viewer.getControl().getDisplay().syncExec(new Runnable((IStructuredSelection)sel){
                    private final /* synthetic */ IStructuredSelection val$sel;
                    {
                        this.val$sel = iStructuredSelection;
                    }

                    @Override
                    public void run() {
                        DebugTreeView.this.viewer.setSelection((ISelection)this.val$sel, true);
                    }
                });
            } else {
                this.viewer.setSelection((ISelection)sel, true);
            }
            return true;
        }
        return false;
    }

    public IPropertyChangeListener getPropertyChangeListener() {
        return this.propertychangelistener;
    }

    private class DebugTreeLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        final decorator dec = new decorator(true);
        final Image monitoredImage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("MONITORED_ICON").createImage(true);
        final Image unmonitoredImage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("UNMONITORED_ICON").createImage(true);

        private DebugTreeLabelProvider() {
        }

        public Image getImage(Object obj) {
            IResource res = null;
            Image image = null;
            if (obj instanceof IT_TreeItem) {
                IT_TreeItem treeitem = (IT_TreeItem)obj;
                Object object = treeitem.getObj();
                switch (treeitem.getType()) {
                    case SESSION: {
                        res = ((debugSession)object).getResource();
                        break;
                    }
                    case PROGRAM: {
                        res = ((debugFile)object).getResource();
                        break;
                    }
                    case TAG: {
                        if (DebugTreeView.PROGRAMS.equals(treeitem.getObj())) {
                            return this.monitoredImage;
                        }
                        if (DebugTreeView.UNMONITORED.equals(treeitem.getObj())) {
                            return this.unmonitoredImage;
                        }
                        return null;
                    }
                }
                if (res != null) {
                    image = this.dec.decorateImage(null, res);
                }
                return image;
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public String getText(Object obj) {
            String text = null;
            if (obj instanceof IT_TreeItem) {
                IT_TreeItem treeitem = (IT_TreeItem)obj;
                Object object = treeitem.getObj();
                switch (treeitem.getType()) {
                    case SESSION: {
                        debugSession session = (debugSession)object;
                        text = session.getTitle();
                        ServerElement server = session.getDebugServer();
                        if (server == null) break;
                        text = String.valueOf(text) + String.format(" (%s)", server.getName());
                        break;
                    }
                    case TAG: {
                        if (STATUS.equals(treeitem.getObj())) {
                            debugSession session;
                            text = treeitem.toString();
                            IT_TreeItem parent = treeitem.getParent();
                            if (parent == null || !((obj = parent.getObj()) instanceof debugSession) || !(session = (debugSession)obj).isDebugging()) break;
                            if (session.isAtBreakpoint()) {
                                text = session.getBreakText();
                                break;
                            }
                            text = Messages.DebugTreeView_status;
                            break;
                        }
                        text = treeitem.toString();
                        break;
                    }
                    case PROGRAM: {
                        text = ((IDebug)object).getTitle();
                    }
                }
                return text;
            }
            return obj.toString();
        }

        public boolean isLabelProperty(Object element, String property) {
            return super.isLabelProperty(element, property);
        }

        public void dispose() {
            if (this.dec != null) {
                this.dec.dispose();
            }
            if (this.monitoredImage != null) {
                this.monitoredImage.dispose();
            }
            if (this.unmonitoredImage != null) {
                this.unmonitoredImage.dispose();
            }
            super.dispose();
        }
    }

    private class NameSorter
    extends ViewerSorter {
        private NameSorter() {
        }

        public int category(Object element) {
            if (element instanceof IT_TreeItem) {
                return ((IT_TreeItem)element).getType().ordinal();
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof IT_TreeItem && e2 instanceof IT_TreeItem) {
                IT_TreeItem item1 = (IT_TreeItem)e1;
                IT_TreeItem item2 = (IT_TreeItem)e2;
                if (item1.getObj().equals(STATUS)) {
                    return -1;
                }
                if (item2.getObj().equals(STATUS)) {
                    return 1;
                }
                if (item1.getObj().equals(DebugTreeView.PROGRAMS)) {
                    return -1;
                }
                if (item2.getObj().equals(DebugTreeView.PROGRAMS)) {
                    return 1;
                }
                if (item1.getType().equals((Object)item2.getType()) && item1.getType() == TreeType.PROGRAM) {
                    return item1.toString().compareTo(item2.toString());
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    public class debugListener
    implements IDebugListener {
        Debugeventrunner runner = new Debugeventrunner();
        private debugSession session;
        private IT_TreeItem treeitem;

        public debugListener(debugSession session, IT_TreeItem treeitem) {
            this.session = session;
            this.treeitem = treeitem;
        }

        @Override
        public void debugEventOccured(debugEvent event) {
            Control control;
            if (DebugTreeView.this.viewer != null && !(control = DebugTreeView.this.viewer.getControl()).isDisposed()) {
                this.runner.init(event);
                control.getDisplay().syncExec((Runnable)this.runner);
            }
        }

        private final class Debugeventrunner
        implements Runnable {
            private debugEvent event = null;

            private Debugeventrunner() {
            }

            public void init(debugEvent event) {
                this.event = event;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            @Override
            public void run() {
                if (!debugListener.this.session.isAtBreakpoint()) {
                    return;
                }
                IActionBars bars = DebugTreeView.this.getViewSite().getActionBars();
                IStatusLineManager statusLine = bars.getStatusLineManager();
                statusLine.setMessage(debugListener.this.session.getBreakText());
                Object obj = this.event.getSource();
                if (!(obj instanceof DSECT)) {
                    return;
                }
                DSECT dsect = (DSECT)obj;
                if (dsect instanceof CVMO) {
                    DebugTreeContentProvider provider = (DebugTreeContentProvider)DebugTreeView.this.viewer.getContentProvider();
                    DebugMessage[] debugMessageArray = dsect.getMessages();
                    int n = debugMessageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IT_TreeItem found;
                        DebugMessage msg = debugMessageArray[n2];
                        if (msg.getMessageID() == 1) {
                            BreakMessage breakmessage = (BreakMessage)msg;
                            String progid = breakmessage.getProgram();
                            debugFile debugfile = debugListener.this.session.getFile(progid);
                            IT_TreeItem found2 = provider.findObject(debugfile);
                            if (found2 != null) {
                                DebugTreeView.this.viewer.refresh((Object)debugListener.this.treeitem.getParent(), true);
                                DebugTreeView.this.viewer.refresh((Object)debugListener.this.treeitem);
                                StructuredSelection sel = new StructuredSelection((Object)found2);
                                DebugTreeView.this.viewer.setSelection((ISelection)sel, true);
                            }
                        } else if (msg.getMessageID() == 4 && (found = provider.findObject(debugListener.this.session)) != null) {
                            DebugTreeView.this.viewer.refresh((Object)debugListener.this.treeitem.getParent(), true);
                            DebugTreeView.this.viewer.refresh((Object)debugListener.this.treeitem);
                            StructuredSelection sel = new StructuredSelection((Object)found);
                            DebugTreeView.this.viewer.setSelection((ISelection)sel, true);
                        }
                        ++n2;
                    }
                } else {
                    DebugMessage[] debugMessageArray = dsect.getMessages();
                    int n = debugMessageArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        DebugMessage message = debugMessageArray[n3];
                        short msgID = message.getMessageID();
                        switch (msgID) {
                            case 4: 
                            case 11: 
                            case 12: 
                            case 15: 
                            case 17: {
                                IT_TreeItem found = null;
                                DebugTalker talker = this.event.getTalker();
                                if (talker == null || (found = ((DebugTreeContentProvider)DebugTreeView.this.viewer.getContentProvider()).findObject(talker.getDebugfile())) == null) break;
                                DebugTreeView.this.viewer.refresh((Object)found, true);
                            }
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private class propertyChangeListener
    implements IPropertyChangeListener {
        private final DebugTreeContentProvider provider;
        private TreeViewer viewer;

        public propertyChangeListener(TreeViewer viewer, DebugTreeContentProvider provider) {
            this.provider = provider;
            this.viewer = viewer;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            if (event == null || this.provider == null) {
                return;
            }
            Display display = this.viewer.getControl().getDisplay();
            if (display == null) {
                display = Display.getCurrent();
            }
            if (display == null) {
                return;
            }
            String property = event.getProperty();
            final Object source = event.getSource();
            if ("com.ca.intertest.ui.views.debug".equals(property)) {
                final Object oldValue = event.getOldValue();
                final Object newValue = event.getNewValue();
                if (oldValue != null && !(oldValue instanceof IDebug)) {
                    return;
                }
                if (newValue != null && !(newValue instanceof IDebug)) {
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (newValue == null) {
                            propertyChangeListener.this.provider.remove(oldValue);
                        } else {
                            debugSession session = null;
                            if (newValue instanceof debugFile) {
                                session = ((IDebug)newValue).getSession();
                            }
                            if (oldValue == null) {
                                propertyChangeListener.this.provider.add(session, newValue);
                            } else {
                                propertyChangeListener.this.viewer.refresh(newValue, true);
                            }
                        }
                    }
                });
                return;
            }
            if (source instanceof IFile) {
                final debugFile file = (debugFile)Debug.getInstance().getResource((IResource)source);
                if (file == null) {
                    return;
                }
                if ("monitor_pgm".equals(property)) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            debugSession session = file.getSession();
                            propertyChangeListener.this.provider.remove(file);
                            propertyChangeListener.this.provider.add(session, file);
                            propertyChangeListener.this.viewer.refresh((Object)session, true);
                        }
                    });
                } else if ("gt_m_lang".equals(property)) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IT_TreeItem object = propertyChangeListener.this.provider.findObject(file);
                            propertyChangeListener.this.viewer.refresh(object == null ? source : object, true);
                        }
                    });
                }
                return;
            }
            if (source instanceof ServerElement) {
                if ("Name".equals(property)) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ServerElement server = (ServerElement)source;
                            for (debugSession session : Debug.getInstance().getSessions()) {
                                IT_TreeItem object;
                                if (!server.equals(session.getDebugServer()) || (object = propertyChangeListener.this.provider.findObject(session)) == null) continue;
                                propertyChangeListener.this.viewer.refresh((Object)object, true);
                            }
                            propertyChangeListener.this.viewer.refresh();
                        }
                    });
                }
                return;
            }
            if (source instanceof debugSession) {
                if ("com.ca.intertest.project".equals(property)) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IT_TreeItem object = propertyChangeListener.this.provider.findObject(source);
                            propertyChangeListener.this.viewer.refresh(object == null ? source : object, true);
                        }
                    });
                }
                return;
            }
        }
    }
}

