/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.common.verifyFixed;
import com.ca.intertest.common.verifyNumber;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ValueEditingSupport
extends BasicEditingSupport {
    static String cacopyright = "Copyright \u00a9 2016 CA";

    public ValueEditingSupport(ColumnViewer viewer, debugSession session, debugFile debugfile, int columnIndex) {
        super(viewer, session, debugfile, columnIndex);
    }

    @Override
    protected boolean canEdit(Object element) {
        if (this.isBackTraceStop()) {
            return false;
        }
        if (this.session.isAtBreakpoint() && element instanceof Variable) {
            if (((TreeObject)element).getBackingdata() == null) {
                return false;
            }
            if (this.isKeyWord((TreeObject)element)) {
                return false;
            }
            return ((Variable)element).canEditDisplay();
        }
        return false;
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        Variable variable = (Variable)element;
        TextCellEditor celleditor = new TextCellEditor((Composite)((TreeViewer)this.getViewer()).getTree());
        Text text = (Text)celleditor.getControl();
        text.setMenu(this.getViewer().getControl().getMenu());
        celleditor.setValidator((ICellEditorValidator)new ValueValidator());
        ((ValueValidator)celleditor.getValidator()).setObject((Variable)element);
        text.setTextLimit(variable.getEditSize());
        switch (variable.getDatatype()) {
            case ALPHA: {
                break;
            }
            case SIGNED: 
            case UNSIGNED: {
                text.addVerifyListener((VerifyListener)new verifyFixed());
                break;
            }
            default: {
                text.addVerifyListener((VerifyListener)new verifyNumber(true));
            }
        }
        this.setEditorFont((CellEditor)celleditor);
        return celleditor;
    }

    @Override
    protected Object getValue(Object element) {
        try {
            return ((Variable)element).getEditValue();
        }
        catch (Exception exception) {
            return Messages.ValueEditingSupport_0;
        }
    }

    @Override
    protected void setValue(Object element, Object object) {
        if (object == null) {
            return;
        }
        String value = (String)object;
        Variable variable = (Variable)element;
        Exception exception = null;
        if (value.equals((String)this.getValue(element))) {
            return;
        }
        String msg = this.getCellEditor(element).getErrorMessage();
        if (msg == null) {
            try {
                variable.updateValue(this.session, value);
            }
            catch (Exception e) {
                exception = e;
                msg = HexUtil.getErrorText((Throwable)e);
                msg = String.format(Messages.ValueEditingSupport_1, msg == null ? e.getClass().getSimpleName() : msg);
            }
        }
        if (msg != null) {
            IT_ErrorDialog.openError(null, Messages.ValueEditingSupport_2, msg, (Throwable)exception);
        }
        super.setValue(element, this.getValue(element));
    }

    private boolean isKeyWord(TreeObject treeobject) {
        return "DATAVIEW_KEYWORD".equals(treeobject.getAttribute("dataflag"));
    }

    private final class ValueValidator
    implements ICellEditorValidator {
        private Variable variable;
        private String previous;

        private ValueValidator() {
        }

        public void setObject(Variable object) {
            this.variable = object;
            this.previous = null;
        }

        public String isValid(Object value) {
            if (value != null && value.equals(this.previous)) {
                return null;
            }
            this.previous = (String)value;
            try {
                this.variable.validateValue((String)value);
                return null;
            }
            catch (Exception e) {
                String msg = HexUtil.getErrorText((Throwable)e);
                return String.format(Messages.ValueEditingSupport_3, value, msg);
            }
        }
    }
}

