/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.calltrace;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.CallTraceListMessage;
import com.ca.intertest.tools.CallTraceMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.calltrace.CalltracePageBook;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class CalltracePage
extends Page
implements IPageBookViewPage,
IAdaptable,
IDebugListener,
ISelectionListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private TableViewer viewer;
    private static final Debug debug = Debug.getInstance();
    private debugSession session = null;
    private Table table;
    private Control control;
    private String description = "";
    private CalltracePageBook pagebook;
    private Color oldcolor = null;
    ImageDescriptor id = null;
    private int currentIP = 0;
    private final AnnotationPreferenceLookup lookup = new AnnotationPreferenceLookup();

    public CalltracePage(IProject project) {
        if (project != null) {
            this.session = debug.getSession((IResource)project);
        }
    }

    public void createControl(Composite parent) {
        if (this.session.isBatch()) {
            Label label = new Label(parent, 16384);
            this.description = Messages.CalltracePage_3;
            label.setText(Messages.CalltracePage_2);
            this.control = label;
            return;
        }
        if (!this.session.isDebugging() || !this.session.isAtBreakpoint()) {
            this.description = Messages.CalltracePage_5;
        }
        this.session.addDebugListener(this);
        this.table = new Table(parent, 66308);
        int i = 0;
        while (i < CalltracePageBook.labels.length) {
            TableColumn column = new TableColumn(this.table, CalltracePageBook.styles[i]);
            column.setText(CalltracePageBook.labels[i]);
            column.setMoveable(true);
            column.setResizable(true);
            column.setData((Object)new Integer(i));
            column.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    Table table;
                    if (CalltracePage.this.viewer != null && !(table = CalltracePage.this.viewer.getTable()).isDisposed()) {
                        CalltracePage.this.pagebook.setOrder(table.getColumnOrder());
                    }
                }

                public void controlResized(ControlEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData();
                        ((CalltracePage)CalltracePage.this).pagebook.getWidth()[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new CalltraceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CalltraceLabelProvider());
        this.reSize();
        if (this.session.isAtBreakpoint()) {
            CVMO initialCVMO = this.session.getTalker().getBreakpointCVMO();
            this.viewer.setInput((Object)initialCVMO);
        } else {
            this.viewer.setInput((Object)this.session);
        }
        this.control = this.viewer.getControl();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("com.ca.intertest.ui.views.calltrace"));
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.control);
        this.control.setMenu(menu);
        this.getSite().registerContextMenu("com.ca.intertest.ui.views.calltrace", menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.pagebook.setContentDescription(this.description);
    }

    public void reSize() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setColumnOrder(this.pagebook.getOrder());
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                Integer colid = (Integer)column.getData();
                column.setWidth(this.pagebook.getWidth()[colid]);
                ++n2;
            }
        }
        this.pagebook.setContentDescription(this.description);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setPagebook(CalltracePageBook pagebook) {
        this.pagebook = pagebook;
    }

    @Override
    public void debugEventOccured(final debugEvent event) {
        Display display;
        if (this.pagebook.isActive() && (display = Display.getDefault()) != null && !this.viewer.getControl().isDisposed()) {
            try {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object object = event.getSource();
                        if (object instanceof CVMO) {
                            CalltracePage.this.processBreakpoint(event);
                        } else if (object instanceof CVMI) {
                            CalltracePage.this.processExecute(event);
                        }
                    }
                });
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    private void processExecute(debugEvent event) {
        CVMI cvmi = (CVMI)((Object)event.getSource());
        DebugMessage[] debugMessageArray = cvmi.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 47: {
                    if (this.currentIP <= 0 || this.oldcolor == null) break;
                    int ix = this.currentIP - 1;
                    this.table.getItem(ix).setBackground(this.oldcolor);
                    Object element = this.viewer.getElementAt(ix);
                    this.viewer.refresh(element, true, true);
                    break;
                }
            }
            ++n2;
        }
        if (this.currentIP > 0) {
            this.viewer.setInput(null);
            this.currentIP = 0;
        }
    }

    private void processBreakpoint(debugEvent event) {
        CVMO cvmo = (CVMO)((Object)event.getSource());
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 4: {
                    this.viewer.setInput(null);
                    return;
                }
                case 1: {
                    this.viewer.setInput((Object)cvmo);
                    if (this.currentIP > 0) {
                        int ix = this.currentIP - 1;
                        AnnotationPreference ap = this.lookup.getAnnotationPreference("com.ca.intertest.lister.pointer");
                        this.id = ap.getImageDescriptor();
                        RGB rgb = ap.getColorPreferenceValue();
                        TableItem item = this.table.getItem(ix);
                        this.oldcolor = item.getBackground();
                        item.setBackground(new Color((Device)Display.getDefault(), rgb));
                        Object element = this.viewer.getElementAt(ix);
                        this.viewer.refresh(element, true, true);
                        this.id = null;
                        this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
                    }
                    return;
                }
            }
            ++n2;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!part.equals((Object)this.pagebook)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof CallTraceListMessage.CallLogRecord)) {
            return;
        }
        CallTraceListMessage.CallLogRecord record = (CallTraceListMessage.CallLogRecord)obj;
        debugFile debugfile = this.session.getFile(record.getProgram());
        IEditorPart ed = null;
        try {
            ed = this.getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)debugfile.getResource()), "com.ca.intertest.ui.lister");
        }
        catch (PartInitException e) {
            Logger.loggit(e);
            return;
        }
        ListerEditor editor = (ListerEditor)ed;
        IScanSource scansource = editor.getScansource();
        IDocument document = editor.getDocument();
        try {
            IRegion region = document.getLineInformation(record.getLinenumber());
            int srcStart = scansource.getSourceOffset();
            int maxwidth = scansource.getSourceLength();
            int regionwidth = region.getLength() - srcStart;
            if (maxwidth > regionwidth) {
                maxwidth = regionwidth;
            }
            editor.selectAndReveal(region.getOffset() + srcStart, maxwidth);
        }
        catch (BadLocationException e) {
            Logger.loggit(e);
        }
    }

    public debugSession getSession() {
        return this.session;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private final class CalltraceContentProvider
    implements IStructuredContentProvider {
        ArrayList<CallTraceListMessage.CallLogRecord> records = new ArrayList();

        private CalltraceContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CVMO) {
                CVMI cvmi = new CVMI();
                cvmi.addMessage((DebugMessage)new CallTraceMessage());
                this.records.clear();
                try {
                    CVMO cvmo = CalltracePage.this.session.getTalker().process(cvmi);
                    DebugMessage[] debugMessageArray = cvmo.getMessages();
                    int n = debugMessageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugMessage item = debugMessageArray[n2];
                        if (item.getMessageID() == 47) {
                            CalltracePage.this.currentIP = 0;
                            CallTraceListMessage.CallLogRecord[] callLogRecordArray = ((CallTraceListMessage)item).getLogRecords();
                            int n3 = callLogRecordArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                CallTraceListMessage.CallLogRecord rec = callLogRecordArray[n4];
                                this.records.add(rec);
                                ++n4;
                            }
                            CalltracePage.this.currentIP = this.records.size();
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            } else if (!(inputElement instanceof CalltracePage)) {
                if (inputElement instanceof CVMI) {
                    this.records.clear();
                } else {
                    this.records.clear();
                }
            }
            for (CallTraceListMessage.CallLogRecord record : this.records) {
                Outline outline = null;
                IEditorPart editor = null;
                IDocument document = null;
                IScanSource scansource = null;
                Statement stmtTree = null;
                debugFile debugfile = CalltracePage.this.session.getFile(record.getProgram());
                if (debugfile != null) {
                    editor = CalltracePage.this.getSite().getPage().findEditor((IEditorInput)new FileEditorInput((IFile)debugfile.getResource()));
                    if (!(editor instanceof ListerEditor)) {
                        editor = null;
                        document = null;
                        try {
                            outline = Outline.getInstance(debugfile);
                        }
                        catch (ITException iTException) {
                            outline = null;
                            document = null;
                        }
                    } else {
                        outline = ((ListerEditor)editor).getOutline();
                        scansource = ((ListerEditor)editor).getScansource();
                        document = ((ListerEditor)editor).getDocument();
                    }
                }
                if (outline == null) continue;
                stmtTree = outline.hasOffset(record.getOffset(), StatementType.VERB);
                if (stmtTree != null) {
                    record.setStatement(stmtTree.getStatement());
                    record.setLinenumber(outline.getLineNumber(record.getStatement()) - 1);
                    if (document == null) continue;
                    try {
                        IRegion region = document.getLineInformation(record.getLinenumber());
                        String line = document.get(region.getOffset(), region.getLength());
                        record.setText(HexUtil.Squeeze((String)scansource.getSourceSegment(line)));
                    }
                    catch (BadLocationException e) {
                        Logger.loggit(e);
                        record.setText(Messages.CalltracePage_8);
                    }
                    continue;
                }
                record.setLinenumber(0);
                record.setText(Messages.CalltracePage_8);
            }
            return this.records.toArray(new CallTraceListMessage.CallLogRecord[this.records.size()]);
        }

        public void dispose() {
        }
    }

    private class CalltraceLabelProvider
    implements ITableLabelProvider {
        private CalltraceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && CalltracePage.this.id != null) {
                return CalltracePage.this.id.createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            CallTraceListMessage.CallLogRecord item = (CallTraceListMessage.CallLogRecord)element;
            switch (columnIndex) {
                case 0: {
                    return item.getProgram();
                }
                case 1: {
                    if (item.getStatement() > 0) {
                        return String.format("%06d", item.getStatement());
                    }
                    return Messages.CalltracePage_11;
                }
                case 2: {
                    return item.getText() == null ? Messages.CalltracePage_12 : item.getText();
                }
                case 4: {
                    return item.getLang();
                }
                case 5: {
                    return item.getType();
                }
                case 3: {
                    return HexUtil.toHex((byte[])item.getOffset());
                }
            }
            return Messages.CalltracePage_13;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

