/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.pli;

import com.ca.intertest.common.Outline;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.ui.lister.util.AbstractTextHover;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class PLITextHover
extends AbstractTextHover {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private char[] delimiters = new char[]{',', '(', ')', '+', '-', ' ', '\''};

    public PLITextHover(IScanSource scanner, Outline outline) {
        super(scanner, outline);
    }

    @Override
    public char[] getDelimiters() {
        return this.delimiters;
    }

    @Override
    protected String getHoverText(String token, IDocument document) {
        String ucToken = token.toUpperCase();
        ArrayList treeArray = null;
        if (this.names.containsKey(ucToken)) {
            treeArray = (ArrayList)this.names.get(ucToken);
            for (TreeObject to : treeArray) {
                String nflg = to.getAttribute("gt_nflg");
                Integer line = Integer.parseInt(to.getAttribute("linenumber"));
                if (line == null || line <= 0) continue;
                try {
                    IRegion def = document.getLineInformation(line - 1);
                    String source = document.get(def.getOffset(), def.getLength());
                    String text = this.scanner.getSourceSegment(source);
                    if (!nflg.equals("40")) {
                        String stmt;
                        text = stmt = String.valueOf(to.getAttribute("statementnumber")) + "  " + text;
                    }
                    if (text == null || text.length() <= 0) continue;
                    String trimmed = text.trim();
                    return trimmed;
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }
}

