/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.dialogs.RulerCICSBreakpointDialog;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.ui.actions.AbstractRulerMarkerAction;
import com.ca.intertest.wizards.BreakpointManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulerBreakpointAction
extends AbstractRulerMarkerAction {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected int selectedLine = -1;
    protected Statement statement;
    private String addText = String.valueOf(Messages.AbstractRulerMarkerAction_add) + Messages.RulerBreakpointAction_bp;
    private String removeText = String.valueOf(Messages.AbstractRulerMarkerAction_remove) + Messages.RulerBreakpointAction_bp;

    public RulerBreakpointAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        super(editor, rulerInfo);
    }

    @Override
    public void run() {
        if (this.resourceMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarker();
        }
    }

    @Override
    protected void addMarker() {
        int firstLine = this.statement.getLine();
        if (this.bpMarkerExists(firstLine)) {
            return;
        }
        Map<String, Object> attributes = this.setBaseAttributes(firstLine);
        if (!this.appendBaseAttributes(attributes)) {
            return;
        }
        try {
            String bpType = (String)attributes.get("markerType");
            if ("com.ca.intertest.breakpoint.watch".equals(bpType)) {
                debugFile dFile = this.getDebugFile();
                BreakpointMarker[] bpMarkers = dFile.getBreakpointmarkers();
                int i = 0;
                while (i < bpMarkers.length) {
                    IMarker marker = bpMarkers[i].getMarker();
                    String markerType = marker.getType();
                    if ("com.ca.intertest.breakpoint.watch".equals(markerType)) {
                        String varName = "";
                        String attrName = "";
                        varName = (String)marker.getAttribute("left_variable");
                        attrName = (String)attributes.get("left_variable");
                        if (varName != null && varName.equals(attrName)) {
                            BreakpointManager manager = new BreakpointManager(this.getLister(), attributes, true);
                            manager.run();
                            return;
                        }
                    }
                    ++i;
                }
            }
            this.allocateMarker(attributes);
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void update() {
        super.update();
        this.setText(this.resourceMarkers.isEmpty() ? this.addText : this.removeText);
        this.setEnabled(true);
        if (this.resourceMarkers.isEmpty() && !this.isValidStatement()) {
            this.setEnabled(false);
        }
    }

    protected boolean isValidStatement() {
        if (this.getLister() == null) {
            return false;
        }
        this.selectedLine = this.getSelectionLineNumber() + 1;
        if (this.selectedLine < 0) {
            return false;
        }
        this.statement = this.getStmtTree().hasLinenumber(this.selectedLine);
        return this.statement != null && this.statement.getType() != StatementType.NOOP;
    }

    @Override
    public String getMarkerType() {
        return this.markerType;
    }

    @Override
    protected StringBuilder setMarkerType(debugFile file, int line) {
        StringBuilder sbString = new StringBuilder("");
        StatementType stmtType = null;
        Statement stmt = this.getLister().getOutline().getStmtTree().hasLinenumber(line);
        if (stmt == null) {
            sbString.append(file.getName());
            return sbString;
        }
        stmtType = stmt.getType();
        if (stmtType.equals((Object)StatementType.VARIABLE)) {
            sbString.append(Messages.RulerBreakpointAction_3);
            this.markerType = "com.ca.intertest.breakpoint.watch";
        } else {
            sbString.append(Messages.RulerBreakpointAction_4);
            this.markerType = "com.ca.intertest.breakpoint.unconditional";
        }
        sbString.append(file.getName());
        return sbString;
    }

    @Override
    protected void removeMarker() {
        List<IMarker> markers = null;
        markers = this.getResourceMarkers().size() > 1 && this.getDebugSession().isCICS() ? this.getMarkerSelections(false) : this.resourceMarkers;
        int i = 0;
        while (i < markers.size()) {
            IMarker marker = markers.get(i);
            try {
                Boolean status = (Boolean)marker.getAttribute("BREAKPOINT_ENABLED");
                if (status != null) {
                    marker.setAttribute("BREAKPOINT_ENABLED", false);
                } else {
                    marker.delete();
                }
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
            ++i;
        }
    }

    protected IMarker findFirstMarker(int line) {
        try {
            int i = 0;
            while (i < this.markers.length) {
                Boolean status = (Boolean)this.markers[i].getAttribute("BREAKPOINT_ENABLED");
                if (status != null && status.booleanValue() && this.getMarkerLineNumber(this.markers[i]) == line) {
                    return this.markers[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        return null;
    }

    protected boolean bpMarkerExists(int line) {
        IMarker marker = null;
        return this.selectedLine != line && (marker = this.findFirstMarker(line)) != null;
    }

    protected boolean isGlobal(String breakpointType, Integer subType) {
        if (breakpointType.equals("com.ca.intertest.breakpoint.watch")) {
            return true;
        }
        return subType != null && (subType == 1 || subType == 4);
    }

    protected List<IMarker> getMarkerSelections(boolean change) {
        List markerList = this.resourceMarkers;
        ArrayList<IMarker> selectedMarkers = new ArrayList<IMarker>(markerList.size());
        int listSize = markerList.size();
        IMarker[] markerArray = new IMarker[listSize];
        markerList.toArray(markerArray);
        RulerCICSBreakpointDialog dialogList = new RulerCICSBreakpointDialog(this.getVerticalRuler().getControl().getShell(), change);
        dialogList.init(markerArray);
        int rc = dialogList.open();
        if (rc != 0) {
            return selectedMarkers;
        }
        int[] indices = dialogList.getSelectionIndices();
        int i = 0;
        while (i < indices.length) {
            int ix = indices[i];
            selectedMarkers.add(markerArray[ix]);
            ++i;
        }
        return selectedMarkers;
    }
}

