/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServiceConnection;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.ITSecurityException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ManageServerAction
implements IViewActionDelegate {
    private IStructuredSelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        Object obj = this.selection.getFirstElement();
        if (obj instanceof FileServer) {
            FileServer server = (FileServer)obj;
            ServiceConnection connection = new ServiceConnection(server);
            boolean oldAdmin = IntertestPlugin.getDefault().isOldAdmin();
            if (oldAdmin) {
                if (connection.isActive()) {
                    if (MessageDialog.openQuestion(null, (String)Messages.ManageServerAction_0, (String)Messages.ServerView_verifyStop)) {
                        connection.shutDown();
                        server.checkStatus(0L);
                    }
                } else {
                    connection.disconnect(true);
                    if (MessageDialog.openQuestion(null, (String)Messages.ManageServerAction_0, (String)Messages.ServerView_verifyStart)) {
                        try {
                            String result = server.startServer();
                            MessageDialog.openInformation(null, (String)Messages.ManageServerAction_0, (String)result);
                        }
                        catch (ITSecurityException e) {
                            IT_ErrorDialog.openError(null, Messages.ManageServerAction_1, HexUtil.getErrorText((Throwable)e), (Throwable)e);
                        }
                        catch (ITException e) {
                            IT_ErrorDialog.openError(null, Messages.ManageServerAction_0, String.valueOf(Messages.ServerView_Error) + HexUtil.getErrorText((Throwable)e), (Throwable)e);
                        }
                        catch (Exception e) {
                            IT_ErrorDialog.openError(null, Messages.ManageServerAction_0, String.valueOf(Messages.ServerView_Error) + e.getClass().getName() + " " + HexUtil.getErrorText((Throwable)e), (Throwable)e);
                            Logger.loggit(e);
                        }
                        server.checkStatus(1000L);
                    }
                }
            } else {
                String format = Messages.ManageServerAction_3;
                String serverAction = connection.isActive() ? Messages.ManageServerAction_stop : Messages.ManageServerAction_start;
                String text = String.format(format, serverAction, serverAction.toUpperCase());
                MessageDialog.openInformation(null, (String)Messages.ManageServerAction_0, (String)text);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        this.selection = (IStructuredSelection)selection;
        Object obj = this.selection.getFirstElement();
        enabled = obj instanceof FileServer;
        if (!enabled) {
            action.setEnabled(enabled);
        }
    }
}

