/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.ListerEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class CountsResetAction
extends Action
implements IUpdate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private ListerEditor lister = null;
    private IVerticalRuler vRuler = null;
    private IResource resource = null;

    public CountsResetAction() {
    }

    public CountsResetAction(String text) {
        super(text);
    }

    public CountsResetAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public CountsResetAction(String text, int style) {
        super(text, style);
    }

    public CountsResetAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        if (editor instanceof ListerEditor) {
            this.lister = (ListerEditor)editor;
        }
        if (rulerInfo instanceof IVerticalRuler) {
            this.vRuler = (IVerticalRuler)rulerInfo;
        }
        this.setText(Messages.CountsResetAction_0);
        this.setToolTipText(Messages.CountsResetAction_1);
    }

    public ListerEditor getLister() {
        return this.lister;
    }

    public IVerticalRuler getVRuler() {
        return this.vRuler;
    }

    public void update() {
        if (this.lister == null) {
            this.setEnabled(false);
            return;
        }
        this.resource = this.lister.getResource();
        debugSession session = Debug.getInstance().getSession(this.resource);
        if (session.isAtBreakpoint()) {
            if (session.isCICS()) {
                this.setEnabled(session.getFile(this.resource).isExecutionCount());
            } else {
                this.setEnabled(session.getFile(this.resource).isExecutionCount());
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        debugSession dSession = Debug.getInstance().getSession(this.resource);
        debugFile dFile = dSession.getFile(this.resource);
        String action = Messages.CountsResetAction_2;
        PropertyChangeEvent pcEvent = new PropertyChangeEvent((Object)dFile, "execution_count", null, (Object)action);
        dFile.firePropertyChangeListeners(pcEvent);
        if (!dSession.isDebugging() || !dFile.isExecutionCount()) {
            return;
        }
        DebugTalker debugTalker = dSession.getTalker();
        if (debugTalker == null) {
            try {
                if (dSession.isCICS()) {
                    dSession.addExecutionCount(dFile, true, (short)4);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
            return;
        }
        ExecutionCountsMessage resetMsg = new ExecutionCountsMessage(dFile);
        try {
            resetMsg.setSubmessageID((short)4);
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
        CVMI cvmi = new CVMI();
        cvmi.addMessage((DebugMessage)resetMsg);
        try {
            CVMO cvmo = debugTalker.process(cvmi);
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage dMsg = debugMessageArray[n2];
                if (dMsg.getMessageID() == 18) {
                    dFile.firePropertyChangeListeners(pcEvent);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }
}

