/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ServerRequestMessage;

public class ServiceConnection
extends Connection {
    static String cacopyright = "Copyright (c) 2016 CA";
    private boolean active = false;
    private String statusText = Messages.ServiceConnection_1;

    public ServiceConnection(ServerElement server) {
        super(server, "service");
        try {
            this.connect(false);
            this.active = true;
            this.statusText = Messages.ServiceConnection_2;
            this.disconnect(false);
        }
        catch (Exception e) {
            this.active = false;
            Logger.loggit(4, this.getErrorMessage(), e);
            this.statusText = String.valueOf(Messages.ServiceConnection_3) + HexUtil.getErrorText((Throwable)e);
        }
    }

    public void shutDown() {
        if (this.active) {
            try {
                this.connect(false);
                if (this.connected) {
                    CVMI cvmi = new CVMI();
                    cvmi.addMessage((DebugMessage)new ServerRequestMessage(1));
                    this.processRaw(cvmi);
                    this.disconnect(false);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized String getStatusText() {
        return this.statusText;
    }
}

