/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.SynchSymbolic2;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.CSect;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GetCompositeMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import java.util.ArrayList;

public class CICSConnection
extends Connection {
    static String cacopyright = "Copyright (c) 2016 CA";
    private debugSession session;
    private debugFile file;
    private ArrayList<String> monitorNames = null;

    public CICSConnection(CICSServer server, debugSession session) {
        super(server, "CICS");
        this.session = session;
    }

    @Override
    protected CVMO ReadIn() throws Exception {
        DebugMessage msg;
        CVMO cvmo = super.ReadIn();
        if (cvmo.size() == 1 && (msg = cvmo.getMessage(1)) instanceof SynchronizeMessage) {
            SynchSymbolic2 synch = this.monitorNames != null && this.monitorNames.contains(((SynchronizeMessage)msg).getProgram()) || this.monitorNames == null ? new SynchSymbolic2((SynchronizeMessage)msg, this.session, this.file) : new SynchSymbolic2((SynchronizeMessage)msg, this.session, this.file, false);
            return this.process(synch.synchronizeFile());
        }
        return cvmo;
    }

    public debugFile getFile() {
        return this.file;
    }

    public void setFile(debugFile file) {
        this.file = file;
    }

    public CVMO processComposite(CVMI cvmi) {
        if (this.monitorNames == null) {
            this.monitorNames = new ArrayList(((GetCompositeMessage)cvmi.getLastMessage()).getCSects().size());
        } else {
            this.monitorNames.clear();
            this.monitorNames.ensureCapacity(((GetCompositeMessage)cvmi.getLastMessage()).getCSects().size());
        }
        for (CSect cs : ((GetCompositeMessage)cvmi.getLastMessage()).getCSects()) {
            if (cs.getComment().length() != 0) continue;
            this.monitorNames.add(cs.getMonitorName());
        }
        return this.process(cvmi);
    }

    public void resetMonitorNames() {
        this.monitorNames = null;
    }
}

