/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.wizards.SchedulingRow;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SchedulingChangeDialog
extends IntertestDialog {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String EMPTY = "";
    static String INSERT = "Insert";
    static String CHANGE = "Change";
    private final int IDB_MORE = 1024;
    private final int IDB_DONE = 0;
    private final int IDB_QUIT = 1;
    private Text jobnameText;
    private Text programText;
    private Text databaseText;
    private Text userIdText;
    private Text transactionText;
    private Button onetimeCheckbox;
    private String seqno = "";
    private String jobname = "";
    private String program = "";
    private boolean onetime = true;
    private String database = "";
    private String imsUserId = "";
    private String imsTransaction = "";
    private ArrayList<SchedulingRow> rowList;
    private ArrayList<SchedulingRow> newList;
    private SchedulingRow row;
    private String mode = "";
    private int ptr = 0;
    private int rowCnt = 0;

    public SchedulingChangeDialog(Shell parentShell) {
        super(parentShell);
    }

    public SchedulingChangeDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(Messages.SchedulingChangeDialog_8) + this.mode);
    }

    public void init(ArrayList<SchedulingRow> rowLst, String database) {
        this.CONTEXT_ID = "schedulingPage";
        if (rowLst == null) {
            this.rowList = new ArrayList();
            this.seqno = EMPTY;
            this.jobname = EMPTY;
            this.program = EMPTY;
            this.onetime = true;
            this.database = database;
            this.imsUserId = EMPTY;
            this.imsTransaction = EMPTY;
            this.mode = "Insert";
        } else {
            this.rowList = rowLst;
            this.rowCnt = this.rowList.size();
            this.row = this.rowList.get(0);
            this.seqno = this.row.getSeqno();
            this.jobname = this.row.getJobname();
            this.program = this.row.getProgram();
            this.onetime = this.row.isOneTime();
            this.database = this.row.getDatabase();
            this.imsUserId = this.row.getImsUserId();
            this.imsTransaction = this.row.getImsTransaction();
            this.mode = "Change";
        }
        this.newList = new ArrayList();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        int charwidth;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        Label jobnameLabel = new Label(composite, 131072);
        jobnameLabel.setText(Messages.SchedulingChangeDialog_15);
        GridData gridData = new GridData(3);
        jobnameLabel.setLayoutData((Object)gridData);
        this.jobnameText = new Text(composite, 2048);
        gridData = new GridData(1);
        GC gc = new GC((Drawable)this.jobnameText);
        try {
            charwidth = gc.getCharWidth('W');
        }
        finally {
            gc.dispose();
        }
        gridData.widthHint = charwidth * 8;
        this.jobnameText.setLayoutData((Object)gridData);
        this.jobnameText.setText(this.jobname);
        this.jobnameText.setTextLimit(8);
        this.jobnameText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        Label programLabel = new Label(composite, 131072);
        programLabel.setText(Messages.SchedulingChangeDialog_16);
        gridData = new GridData(3);
        programLabel.setLayoutData((Object)gridData);
        this.programText = new Text(composite, 2048);
        gridData = new GridData(1);
        gridData.widthHint = charwidth * 8;
        this.programText.setLayoutData((Object)gridData);
        this.programText.setText(this.program);
        this.programText.setTextLimit(8);
        this.programText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        Shell shell = composite.getShell();
        shell.setMinimumSize(430, 240);
        if (this.database.equals("IMS")) {
            if (this.imsUserId.equals(EMPTY)) {
                this.imsUserId = "*";
            }
            if (this.imsTransaction.equals(EMPTY)) {
                this.imsTransaction = "*";
            }
            Label userIdLabel = new Label(composite, 131072);
            userIdLabel.setText("User ID");
            gridData = new GridData(3);
            userIdLabel.setLayoutData((Object)gridData);
            this.userIdText = new Text(composite, 2048);
            gridData = new GridData(1);
            gridData.widthHint = charwidth * 8;
            this.userIdText.setLayoutData((Object)gridData);
            this.userIdText.setText(this.imsUserId);
            this.userIdText.setTextLimit(8);
            this.userIdText.addVerifyListener((VerifyListener)new verifytoUpperCase());
            Label transactionLabel = new Label(composite, 131072);
            transactionLabel.setText("Transaction");
            gridData = new GridData(3);
            transactionLabel.setLayoutData((Object)gridData);
            this.transactionText = new Text(composite, 2048);
            gridData = new GridData(1);
            gridData.widthHint = charwidth * 8;
            this.transactionText.setLayoutData((Object)gridData);
            this.transactionText.setText(this.imsTransaction);
            this.transactionText.setTextLimit(8);
            this.transactionText.addVerifyListener((VerifyListener)new verifytoUpperCase());
            shell.setMinimumSize(430, 300);
        }
        Label databaseLabel = new Label(composite, 131072);
        databaseLabel.setText(Messages.SchedulingChangeDialog_17);
        gridData = new GridData(3);
        databaseLabel.setLayoutData((Object)gridData);
        this.databaseText = new Text(composite, 8);
        gridData = new GridData(1);
        gridData.widthHint = charwidth * 3;
        this.databaseText.setLayoutData((Object)gridData);
        this.databaseText.setText(this.database);
        this.databaseText.setTextLimit(3);
        this.databaseText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.databaseText.setEnabled(true);
        this.onetimeCheckbox = new Button(composite, 32);
        this.onetimeCheckbox.setText(Messages.SchedulingChangeDialog_18);
        this.onetimeCheckbox.setSelection(this.onetime);
        gridData = new GridData(1);
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 2;
        this.onetimeCheckbox.setLayoutData((Object)gridData);
        return composite;
    }

    protected void morePressed() {
        this.jobname = this.jobnameText.getText();
        this.program = this.programText.getText();
        if (this.database.equals("IMS")) {
            this.imsUserId = this.userIdText.getText();
            this.imsTransaction = this.transactionText.getText();
            if (this.imsUserId.equals(EMPTY) || this.imsUserId.charAt(0) == ' ') {
                this.imsUserId = "*";
            }
            if (this.imsTransaction.equals(EMPTY) || this.imsTransaction.charAt(0) == ' ') {
                this.imsTransaction = "*";
            }
        } else {
            this.imsUserId = EMPTY;
            this.imsTransaction = EMPTY;
        }
        if (this.program.length() == 0 && this.jobname.length() == 0) {
            super.okPressed();
        } else if (this.program.length() == 0) {
            this.doProgramBlank();
        } else {
            this.onetime = this.onetimeCheckbox.getSelection();
            this.row = new SchedulingRow(this.seqno, this.jobname, this.program, this.onetime, this.database, this.imsUserId, this.imsTransaction, 0);
            this.newList.add(this.row);
            ++this.ptr;
            if (this.rowCnt > 0) {
                if (this.ptr == this.rowCnt - 1) {
                    this.getButton(1024).setEnabled(false);
                    this.getButton(0).setEnabled(true);
                }
                if (this.ptr == this.rowCnt) {
                    super.okPressed();
                } else {
                    this.row = this.rowList.get(this.ptr);
                    this.seqno = this.row.getSeqno();
                    this.jobnameText.setText(this.row.getJobname());
                    this.programText.setText(this.row.getProgram());
                    this.onetimeCheckbox.setSelection(this.row.isOneTime());
                    if (this.database.equals("IMS")) {
                        this.imsUserId = this.userIdText.getText();
                        this.imsTransaction = this.transactionText.getText();
                    } else {
                        this.imsUserId = " ";
                        this.imsTransaction = " ";
                    }
                }
            } else {
                this.jobnameText.setText(EMPTY);
                this.programText.setText(EMPTY);
                this.onetimeCheckbox.setSelection(this.onetime);
                this.userIdText.setText("*");
                this.transactionText.setText("*");
            }
            this.jobnameText.setFocus();
        }
    }

    protected void okPressed() {
        this.jobname = this.jobnameText.getText();
        this.program = this.programText.getText();
        if (this.database.equals("IMS")) {
            this.imsUserId = this.userIdText.getText();
            this.imsTransaction = this.transactionText.getText();
            if (this.imsUserId.equals(EMPTY) || this.imsUserId.charAt(0) == ' ') {
                this.imsUserId = "*";
            }
            if (this.imsTransaction.equals(EMPTY) || this.imsTransaction.charAt(0) == ' ') {
                this.imsTransaction = "*";
            }
        } else {
            this.imsUserId = EMPTY;
            this.imsTransaction = EMPTY;
        }
        if (this.program.length() == 0 && this.jobname.length() == 0) {
            super.okPressed();
        } else if (this.program.length() == 0) {
            this.doProgramBlank();
        } else {
            this.onetime = this.onetimeCheckbox.getSelection();
            this.row = new SchedulingRow(this.seqno, this.jobname, this.program, this.onetime, this.database, this.imsUserId, this.imsTransaction, 0);
            this.newList.add(this.row);
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.newList = null;
        super.cancelPressed();
    }

    protected void doProgramBlank() {
        String sMsg = Messages.SchedulingChangeDialog_21;
        MessageDialog.openWarning((Shell)this.getShell(), (String)(String.valueOf(Messages.SchedulingChangeDialog_22) + this.mode + Messages.SchedulingChangeDialog_23), (String)sMsg);
        this.programText.setFocus();
    }

    public ArrayList<SchedulingRow> getRowList() {
        return this.newList;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.morePressed();
                break;
            }
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.SchedulingChangeDialog_4, false);
        this.createButton(parent, 0, Messages.SchedulingChangeDialog_5, false);
        this.createButton(parent, 1, Messages.SchedulingChangeDialog_6, false);
        if (this.rowCnt == 1) {
            this.getButton(1024).setEnabled(false);
            this.getButton(0).setEnabled(true);
        } else if (this.rowCnt > 0) {
            this.getButton(1024).setEnabled(true);
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(1024).setEnabled(true);
            this.getButton(0).setEnabled(true);
        }
    }
}

