/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Variable;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.ArrayRow;
import com.ca.intertest.dialogs.ArrayRowList;
import com.ca.intertest.dialogs.DataViewValueDialog;
import com.ca.intertest.dialogs.IArrayRowListViewer;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.wizards.CoreStructurePage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class DataViewArrayDialog
extends IntertestDialog {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final Debug debug = Debug.getInstance();
    private String title = Messages.DataViewArrayDialog_1;
    private ByteBuffer backingdata = null;
    private Variable variable;
    private String altname;
    private String cellString;
    private int lang;
    private int varLth;
    private Table table;
    private TableViewer viewer;
    private GridData gridData;
    private IResource resource;
    private ArrayRowList rowList;
    private Action doubleClickAction;
    private Action postArrayRow;
    private ListerEditor editor;
    private boolean goUpdate = false;
    private debugSession session;
    private MFAddress backingdataAddr;
    private MenuManager menuMgr;
    protected static final int IDB_CLOSE = 1024;
    private HashMap<String, String> attributes;

    public DataViewArrayDialog(Shell parentShell) {
        super(parentShell);
    }

    public DataViewArrayDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void init(Variable var, AbstractDataViewPage pageparm) {
        this.lang = pageparm.getLang();
        this.session = pageparm.getSession();
        this.editor = pageparm.getEditor();
        this.variable = var;
        this.init_common();
    }

    public void init(Variable var, CoreStructurePage pageStructure) {
        this.lang = pageStructure.getLang();
        this.session = pageStructure.getSession();
        this.editor = pageStructure.getEditor();
        this.variable = var;
        this.init_common();
    }

    public void init_common() {
        this.CONTEXT_ID = "dataviewdialogs";
        debugFile debugfile = (debugFile)debug.getResource(this.editor.getResource());
        this.backingdata = this.variable.getBackingdata();
        this.backingdataAddr = this.variable.getBackingdataAddress();
        this.varLth = (Integer)Attribute.getValue("length", this.variable);
        this.resource = debugfile.getResource();
        this.title = String.valueOf(Messages.DataViewArrayDialog_3) + this.variable.getName();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.gridData = new GridData(1808);
        this.gridData.heightHint = 800;
        this.gridData.widthHint = 900;
        composite.setLayoutData((Object)this.gridData);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.createTable(composite);
        this.createTableViewer();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        this.gridData = new GridData(4, 4, true, true);
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.grabExcessHorizontalSpace = false;
        this.gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)this.gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setFont(JFaceResources.getTextFont());
        TableColumn indexColumn = new TableColumn(this.table, 16384, 0);
        indexColumn.setText(Messages.DataViewArrayDialog_4);
        indexColumn.setWidth(160);
        TableColumn valueColumn = new TableColumn(this.table, 16384, 1);
        valueColumn.setText(Messages.DataViewArrayDialog_5);
        valueColumn.setWidth(160);
        TableColumn hexColumn = new TableColumn(this.table, 16384, 2);
        hexColumn.setText(Messages.DataViewArrayDialog_6);
        hexColumn.setWidth(160);
    }

    private void createTableViewer() {
        this.rowList = new ArrayRowList();
        this.rowList.initData(this.variable, this.backingdata, this.lang);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.viewer.setInput((Object)this.rowList);
        this.makeActions();
        this.hookDoubleClickAction();
        this.hookContextMenu();
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = DataViewArrayDialog.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ArrayRow) {
                    MFAddress addr;
                    ArrayRow row = (ArrayRow)obj;
                    Display display = Display.getDefault();
                    Shell shell = new Shell(display);
                    DataViewValueDialog dlgDVValue = new DataViewValueDialog(shell);
                    try {
                        addr = DataViewArrayDialog.this.backingdataAddr.add((long)row.getLocation());
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                        addr = MFAddress.ZERO_ADDR;
                    }
                    Variable cloneVariable = row.getCloneVar();
                    cloneVariable.setAddress(addr);
                    dlgDVValue.initArray(cloneVariable, DataViewArrayDialog.this.session, row.getCellIndexes());
                    dlgDVValue.open();
                    String hexValue = null;
                    hexValue = dlgDVValue.getCurHexString();
                    if (hexValue != null) {
                        DataViewArrayDialog.this.goUpdate = true;
                        byte[] bytes = new byte[DataViewArrayDialog.this.varLth];
                        HexUtil.HextoBytes((String)hexValue, (byte[])bytes);
                        DataViewArrayDialog.this.backingdata.position(row.getLocation());
                        DataViewArrayDialog.this.backingdata.put(bytes);
                        DataViewArrayDialog.this.rowList.initData(DataViewArrayDialog.this.variable, DataViewArrayDialog.this.backingdata, DataViewArrayDialog.this.lang);
                        DataViewArrayDialog.this.viewer.refresh();
                    }
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataViewArrayDialog.this.doubleClickAction.run();
            }
        });
    }

    private void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        Menu menu = this.menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.postArrayRow = new Action(){

            public void run() {
                ISelection selection = DataViewArrayDialog.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ArrayRow) {
                    ArrayRow row = (ArrayRow)obj;
                    DataViewArrayDialog.this.cellString = row.getCellIndexes();
                    DataViewArrayDialog.this.altname = String.valueOf(DataViewArrayDialog.this.variable.getName()) + DataViewArrayDialog.this.cellString;
                    DataViewArrayDialog.this.save_occurrence();
                    DataViewArrayDialog.this.viewer.refresh();
                }
            }
        };
        this.postArrayRow.setText(Messages.DataViewArrayDialog_8);
        this.menuMgr.add((IAction)this.postArrayRow);
    }

    public synchronized void save_occurrence() {
        if (this.resource != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        DataViewArrayDialog.this.setAttribute("altname", DataViewArrayDialog.this.altname);
                        DataViewArrayDialog.this.setAttribute("keeptype", "DATAVIEW_VARFIABLE");
                        DataViewArrayDialog.this.setAttribute("keyword", DataViewArrayDialog.this.cellString);
                        DataViewArrayDialog.this.setAttribute("name", DataViewArrayDialog.this.variable.getName());
                        IMarker marker = DataViewArrayDialog.this.resource.createMarker("com.ca.intertest.keep");
                        if (marker != null && marker.exists()) {
                            marker.setAttributes((Map)DataViewArrayDialog.this.attributes);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            try {
                this.resource.getWorkspace().run(r, (ISchedulingRule)this.resource.getProject(), 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.unsetAttribute(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        }
    }

    protected void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                super.cancelPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, Messages.DataViewArrayDialog_9, false);
    }

    public ByteBuffer getBackingdata() {
        return this.backingdata;
    }

    public boolean getUpdateFlag() {
        return this.goUpdate;
    }

    class ArrayContentProvider
    implements IStructuredContentProvider,
    IArrayRowListViewer {
        ArrayContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ArrayRowList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ArrayRowList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return DataViewArrayDialog.this.rowList.getRows().toArray();
        }

        @Override
        public void addRow(ArrayRow row) {
            DataViewArrayDialog.this.viewer.add((Object)row);
        }

        @Override
        public void removeRow(ArrayRow row) {
            DataViewArrayDialog.this.viewer.remove((Object)row);
        }

        @Override
        public void updateRow(ArrayRow row) {
            DataViewArrayDialog.this.viewer.update((Object)row, null);
        }
    }

    class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ArrayRow row = (ArrayRow)obj;
            switch (index) {
                case 0: {
                    return row.getCellIndexes();
                }
                case 1: {
                    return row.getCharValue();
                }
                case 2: {
                    return row.getHexValue();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                default: 
            }
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

